/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.util.esbclient;

import com.sonicsw.esb.mgmtapi.config.IAddress;
import com.sonicsw.xq.XQMessage;
import java.util.HashMap;
import java.util.Map;

public interface ESBMessageListener {
    public static final AddressType SERVICE_EXIT_MESSAGE = new AddressType("ServiceExited", 0);
    public static final AddressType SERVICE_REJECTED_MESSAGE = new AddressType("ServiceRejected", 1);
    public static final AddressType SERVICE_FAULTED_MESSAGE = new AddressType("ServiceFaulted", 2);
    public static final AddressType PROCESS_EXIT_MESSAGE = new AddressType("ProcessExited", 3);
    public static final AddressType PROCESS_REJECTED_MESSAGE = new AddressType("ProcessRejected", 4);
    public static final AddressType PROCESS_FAULTED_MESSAGE = new AddressType("ProcessFaulted", 5);
    public static final AddressType OTHER_ADDRESS = new AddressType("MessageExited", 6);

    public void onMessage(XQMessage var1, AddressType var2, IAddress var3);

    public static class AddressType {
        private static Map mapString;
        private static HashMap mapInt;
        private String name;
        private int num;
        private static final String SERVICE_EXIT_MESSAGE = "ServiceExited";
        private static final String SERVICE_REJECTED_MESSAGE = "ServiceRejected";
        private static final String SERVICE_FAULTED_MESSAGE = "ServiceFaulted";
        private static final String PROCESS_EXIT_MESSAGE = "ProcessExited";
        private static final String PROCESS_REJECTED_MESSAGE = "ProcessRejected";
        private static final String PROCESS_FAULTED_MESSAGE = "ProcessFaulted";
        private static final String OTHER_ADDRESS = "MessageExited";
        private static final int SERVICE_EXITED = 0;
        private static final int SERVICE_REJECTED = 1;
        private static final int SERVICE_FAULTED = 2;
        private static final int PROCESS_EXITED = 3;
        private static final int PROCESS_REJECTED = 4;
        private static final int PROCESS_FAULTED = 5;
        private static final int ADDRESS = 6;

        private AddressType(String name, int num) {
            this.name = name;
            this.num = num;
        }

        public String getName() {
            return this.name;
        }

        public int getNumericType() {
            return this.num;
        }

        public boolean isFaulted() {
            return this.num == 2 || this.num == 5;
        }

        public boolean isRejected() {
            return this.num == 1 || this.num == 4;
        }

        public boolean isExited() {
            return this.num == 0 || this.num == 3 || this.num == 6;
        }

        public static synchronized AddressType fromString(String name) {
            if (mapString == null) {
                mapString = new HashMap();
                mapString.put(SERVICE_EXIT_MESSAGE, SERVICE_EXIT_MESSAGE);
                mapString.put(SERVICE_REJECTED_MESSAGE, SERVICE_REJECTED_MESSAGE);
                mapString.put(SERVICE_FAULTED_MESSAGE, SERVICE_FAULTED_MESSAGE);
                mapString.put(PROCESS_EXIT_MESSAGE, PROCESS_EXIT_MESSAGE);
                mapString.put(PROCESS_REJECTED_MESSAGE, PROCESS_REJECTED_MESSAGE);
                mapString.put(PROCESS_FAULTED_MESSAGE, PROCESS_FAULTED_MESSAGE);
                mapString.put(OTHER_ADDRESS, OTHER_ADDRESS);
            }
            return (AddressType)mapString.get(name);
        }

        public static synchronized AddressType fromInt(int num) {
            if (mapInt == null) {
                mapInt = new HashMap();
                mapInt.put(new Integer(0), SERVICE_EXIT_MESSAGE);
                mapInt.put(new Integer(1), SERVICE_REJECTED_MESSAGE);
                mapInt.put(new Integer(2), SERVICE_FAULTED_MESSAGE);
                mapInt.put(new Integer(3), PROCESS_EXIT_MESSAGE);
                mapInt.put(new Integer(4), PROCESS_REJECTED_MESSAGE);
                mapInt.put(new Integer(5), PROCESS_FAULTED_MESSAGE);
                mapInt.put(new Integer(6), OTHER_ADDRESS);
            }
            return (AddressType)mapInt.get(new Integer(num));
        }
    }
}

