/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.util.merge;

import com.sonicsw.esb.service.common.util.merge.MergeMessageAPI;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import java.util.Iterator;

public class MergeMessageImpl
implements MergeMessageAPI {
    private static final String URI = "http://www.sonicsw.com/esbmsg/message";

    @Override
    public void mergeXQMessage(XQMessage sourceMsg, XQMessage targetXQMsg) throws XQMessageException {
        try {
            this.setHeaders(sourceMsg, targetXQMsg);
            for (int i = 0; i < sourceMsg.getPartCount(); ++i) {
                XQPart esbxqPart = sourceMsg.getPart(i);
                String esbprtContId = esbxqPart.getContentId();
                if (!targetXQMsg.doesPartExist(esbprtContId)) {
                    targetXQMsg.addPart(esbxqPart);
                    continue;
                }
                targetXQMsg.replacePart(esbxqPart, esbxqPart.getContentId());
            }
        }
        catch (Exception e) {
            throw new XQMessageException("Cannot  merge message", (Throwable)e);
        }
    }

    private void setHeaders(XQMessage sourceMsg, XQMessage targetXQMsg) throws XQMessageException {
        try {
            Iterator it = sourceMsg.getHeaderNames();
            while (it.hasNext()) {
                String hdrName = (String)it.next();
                Object hdrValue = sourceMsg.getHeaderValue(hdrName);
                targetXQMsg.setHeaderValue(hdrName, hdrValue);
            }
        }
        catch (Exception e) {
            throw new XQMessageException("Cannot set headers on target XQMessage from source while merging", (Throwable)e);
        }
    }
}

