/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.ramps.pools;

import com.sonicsw.esb.service.common.ramps.IConnectionContext;
import com.sonicsw.esb.service.common.ramps.pools.AbstractKeyedPoolConnectionFactory;
import com.sonicsw.esb.service.common.ramps.pools.IPoolableConnectionContext;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class KeyedPoolableConnectionFactory
implements KeyedPooledObjectFactory {
    private static final Logger LOGGER = LogManager.getLogger(KeyedPoolableConnectionFactory.class);

    public PooledObject makeObject(Object _key) throws Exception {
        LOGGER.debug("Creating new pooled object for key: {}", _key);
        this.validateKey(_key);
        AbstractKeyedPoolConnectionFactory.PoolKey key = (AbstractKeyedPoolConnectionFactory.PoolKey)_key;
        try {
            IConnectionContext connection = key.getFactory().createConnection(key.getContext());
            connection.activate();
            LOGGER.debug("Successfully created and activated new connection: {}", (Object)connection);
            return new DefaultPooledObject((Object)connection);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create pooled object for key: {}. Exception: {}", _key, (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    public void activateObject(Object _key, PooledObject _connection) throws Exception {
    }

    public boolean validateObject(Object _key, PooledObject _connection) {
        LOGGER.debug("Validating pooled object for key: {}, connection: {}", _key, (Object)_connection);
        if (_connection == null) {
            LOGGER.warn("Validation failed: PooledObject is null for key: {}", _key);
            return false;
        }
        Object obj = _connection.getObject();
        if (obj == null) {
            LOGGER.warn("Validation failed: Connection object is null for key: {}", _key);
            return false;
        }
        if (obj instanceof IPoolableConnectionContext) {
            IPoolableConnectionContext poolableConn = (IPoolableConnectionContext)obj;
            boolean isValid = false;
            try {
                isValid = poolableConn.validate();
                if (isValid) {
                    LOGGER.debug("Validation successful for key: {}, connection: {}", _key, obj);
                } else {
                    LOGGER.warn("Validation failed for key: {}, connection: {}. validate() returned false", _key, obj);
                }
            }
            catch (Exception e) {
                LOGGER.error("Validation failed with exception for key: {}, connection: {}. Exception: {}", _key, obj, (Object)e.getMessage(), (Object)e);
                isValid = false;
            }
            return isValid;
        }
        LOGGER.debug("Object is not IPoolableConnectionContext, defaulting to valid. Key: {}, Type: {}", _key, (Object)obj.getClass().getName());
        return true;
    }

    public void passivateObject(Object _key, PooledObject _connection) throws Exception {
    }

    public void destroyObject(Object _key, PooledObject _connection) throws Exception {
        if (_connection == null || !(_connection.getObject() instanceof IConnectionContext)) {
            throw new IllegalArgumentException("Not a connection object");
        }
        this.validateKey(_key);
        AbstractKeyedPoolConnectionFactory.PoolKey key = (AbstractKeyedPoolConnectionFactory.PoolKey)_key;
        ((IConnectionContext)_connection.getObject()).deactivate(true);
        key.getFactory().destroyConnection((IConnectionContext)_connection.getObject(), true);
    }

    private void validateKey(Object _key) {
        if (!(_key instanceof AbstractKeyedPoolConnectionFactory.PoolKey)) {
            throw new IllegalArgumentException("The key provided is not a pool key from the ramps.");
        }
    }
}

