/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.service.common.impl.SFCMetricImpl;
import com.sonicsw.esb.service.common.impl.core.MetricsRegistrar;
import com.sonicsw.esb.service.common.impl.events.SFCServiceLifecycleEvent;
import com.sonicsw.esb.service.common.metrics.MetricDescriptor;
import com.sonicsw.esb.service.common.metrics.MetricsBuilder;
import com.sonicsw.esb.service.common.metrics.MetricsHandler;
import com.sonicsw.esb.service.common.metrics.SFCMetric;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEvent;

abstract class AbstractMetricsHandlerImpl
implements MetricsHandler {
    protected static final Logger logger = LogManager.getLogger(MetricsHandler.class);
    protected final MetricsRegistrar registrar;
    protected final Set registeredMetrics = new HashSet();
    private boolean canRegister = true;

    public AbstractMetricsHandlerImpl(MetricsRegistrar registrar) {
        this.registrar = registrar;
    }

    @Override
    public SFCMetric registerMetric(MetricDescriptor desc) {
        this.validate(desc);
        SFCMetricImpl metric = this.createMetricImpl(desc);
        this.registrar.registerMetric(metric.getMetricInfo(), metric.getStatistic());
        this.registeredMetrics.add(desc.getName());
        return metric;
    }

    public MetricsBuilder getMetricsBuilder() {
        return new MetricsBuilder();
    }

    public void disableMetricRegistration() {
        this.canRegister = false;
    }

    protected void validate(MetricDescriptor desc) {
        if (!this.canRegister) {
            throw new IllegalStateException("Metrics can no longer be registered.");
        }
        if (this.registeredMetrics.contains(desc.getName())) {
            throw new IllegalArgumentException("Metric '" + desc.getName() + "' has already been registered by this service.");
        }
    }

    protected SFCMetricImpl createMetricImpl(MetricDescriptor desc) {
        return new SFCMetricImpl(desc);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof SFCServiceLifecycleEvent && 0 == ((SFCServiceLifecycleEvent)event).getEventType()) {
            this.disableMetricRegistration();
        }
    }
}

