/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.impl;

import com.sonicsw.esb.interceptor.XQInterceptorServiceContext;
import com.sonicsw.esb.service.common.SFCInitializationContext;
import com.sonicsw.esb.service.common.SFCParameters;
import com.sonicsw.esb.service.common.SFCServiceContext;
import com.sonicsw.esb.service.common.impl.ContextAwareVariableResolverFactory;
import com.sonicsw.esb.service.common.util.Check;
import com.sonicsw.esb.service.common.util.CheckArg;
import com.sonicsw.esb.service.common.util.variables.VariableParser;
import com.sonicsw.xq.XQAddressFactory;
import com.sonicsw.xq.XQDispatch;
import com.sonicsw.xq.XQEndpointManager;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQEnvelopeFactory;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQLifeCycleManager;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQProcessContext;
import com.sonicsw.xq.XQServiceContext;
import java.util.ListIterator;
import javax.jms.Connection;
import javax.jms.Session;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class SFCServiceContextImpl
implements SFCServiceContext {
    private static final Logger logger = LogManager.getLogger(SFCServiceContext.class);
    private final SFCInitializationContext initContext;
    private final SFCParameters parameters;
    private final VariableParser variableParser;
    private XQServiceContext xqContext;
    private XQEnvelope incoming;

    protected SFCServiceContextImpl(SFCInitializationContext initContext, SFCParameters parameters, VariableParser variableParser, ContextAwareVariableResolverFactory contextAwareResolverFactory) {
        CheckArg.notNull(initContext, "initContext");
        CheckArg.notNull(parameters, "parameters");
        CheckArg.notNull(variableParser, "variableParser");
        this.initContext = initContext;
        this.parameters = parameters;
        contextAwareResolverFactory.setContext(this);
        variableParser.setVariableResolverFactory(contextAwareResolverFactory);
        this.variableParser = variableParser;
    }

    @Override
    public SFCParameters getParameters() {
        return this.parameters;
    }

    @Override
    public VariableParser getVariableParser() {
        return this.variableParser;
    }

    @Override
    public XQEnvelope getMessageEnvelope() {
        return this.incoming;
    }

    @Override
    public int getCurrentListener() {
        return this.xqContext.getCurrentListener();
    }

    @Override
    public boolean isInProcess() {
        return this.getProcessContext() != null;
    }

    @Override
    public void addFault(XQEnvelope fault) {
        this.xqContext.addFault(fault);
        logger.debug("Added envelope to faultbox");
    }

    @Override
    public void addFault(XQMessage fault) {
        this.xqContext.addFault(fault);
        logger.debug("Added message to faultbox");
    }

    @Override
    public boolean hasFaults() {
        if (this.xqContext instanceof XQInterceptorServiceContext) {
            ListIterator iterator = ((XQInterceptorServiceContext)this.xqContext).faultboxIterator();
            return iterator.hasNext();
        }
        return false;
    }

    @Override
    public void clearFaults() {
        this.xqContext.clearFaults();
        logger.debug("Cleared the faultbox.");
    }

    @Override
    public void addOutgoing(XQEnvelope outgoing) {
        this.xqContext.addOutgoing(outgoing);
        logger.debug("Added envelope to outbox");
    }

    @Override
    public void addOutgoing(XQMessage outgoing) {
        this.xqContext.addOutgoing(outgoing);
        logger.debug("Added message to outbox");
    }

    @Override
    public boolean hasOutgoing() {
        if (this.xqContext instanceof XQInterceptorServiceContext) {
            ListIterator iterator = ((XQInterceptorServiceContext)this.xqContext).outboxIterator();
            return iterator.hasNext();
        }
        return false;
    }

    @Override
    public void clearOutgoing() {
        this.xqContext.clearOutgoing();
        logger.debug("Cleared the outbox.");
    }

    @Override
    public void addIncomingToOutbox() {
        if (this.incoming.getAddresses().hasNext()) {
            this.xqContext.addOutgoing(this.incoming);
            logger.debug("Added incoming envelope to outbox");
        } else {
            logger.debug("Incoming envelope has no addresses, not adding to outbox");
        }
    }

    @Override
    public String getProcessID() {
        return this.isInProcess() ? this.getProcessContext().getTrackingID() : "";
    }

    @Override
    public String getProcessName() {
        return this.isInProcess() ? this.getProcessContext().getName() : "";
    }

    @Override
    public String getProcessStepName() {
        return this.isInProcess() ? this.getProcessContext().getStepName() : "";
    }

    @Override
    public String getDomainName() {
        return this.initContext.getDomainName();
    }

    @Override
    public String getMFContainerName() {
        return this.initContext.getMFContainerName();
    }

    @Override
    public String getESBContainerName() {
        return this.initContext.getESBContainerName();
    }

    @Override
    public String getServiceName() {
        return this.initContext.getServiceName();
    }

    @Override
    public String getServiceTypeName() {
        return this.initContext.getServiceTypeName();
    }

    @Override
    public String getAbsoluteServiceInstanceName() {
        return this.initContext.getAbsoluteServiceInstanceName();
    }

    @Override
    public int getNumberOfListeners() {
        return this.initContext.getNumberOfListeners();
    }

    @Override
    public XQProcessContext getProcessContext() {
        return this.xqContext.getProcessContext();
    }

    @Override
    public XQAddressFactory getAddressFactory() {
        return this.xqContext.getAddressFactory();
    }

    @Override
    public XQDispatch getDispatcher() {
        return this.xqContext.getDispatcher();
    }

    @Override
    public XQEndpointManager getEndpointManager() {
        return this.xqContext.getEndpointManager();
    }

    @Override
    public XQEnvelopeFactory getEnvelopeFactory() {
        return this.xqContext.getEnvelopeFactory();
    }

    @Override
    public XQMessageFactory getMessageFactory() {
        return this.xqContext.getMessageFactory();
    }

    @Override
    public XQLifeCycleManager getLifeCycle() {
        return this.xqContext.getLifeCycle();
    }

    @Override
    public XQInitContext getXQInitContext() {
        return this.initContext.getXQInitContext();
    }

    @Override
    public XQServiceContext getXQServiceContext() {
        return this.xqContext;
    }

    public void setXQServiceContext(XQServiceContext xqContext) {
        Check.notSet(this.xqContext, "xqContext");
        Check.notSet(this.incoming, "incoming");
        this.xqContext = xqContext;
        this.incoming = this.xqContext.getFirstIncoming();
    }

    @Override
    public Connection getCurrentJMSConnection() {
        return this.xqContext.getCurrentJMSConnection();
    }

    @Override
    public Session getCurrentJMSSession() {
        return this.xqContext.getCurrentJMSSession();
    }

    @Override
    public void setXQInitContext(XQInitContext xqInitContext) {
        throw new UnsupportedOperationException();
    }
}

