/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.ramps;

import com.sonicsw.esb.service.common.SFCInitializationContext;
import com.sonicsw.esb.service.common.SFCServiceContext;
import com.sonicsw.esb.service.common.ramps.AbstractSyncRamp;
import com.sonicsw.esb.service.common.ramps.ICompositeConnectionContext;
import com.sonicsw.esb.service.common.ramps.IConnectionContext;
import com.sonicsw.esb.service.common.ramps.IDataSink;
import com.sonicsw.esb.service.common.ramps.InvalidConnectionException;
import com.sonicsw.esb.service.common.ramps.MappingException;
import com.sonicsw.esb.service.common.ramps.impl.ExitToServiceException;
import com.sonicsw.esb.service.common.ramps.utils.Utils;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQServiceException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SyncOffRamp
extends AbstractSyncRamp {
    private static final Logger LOGGER = LogManager.getLogger(SyncOffRamp.class);
    private IDataSink dataSink_;
    private boolean continueFlow_ = true;

    public SyncOffRamp(String _serviceGroupName) {
        super(_serviceGroupName);
    }

    public SyncOffRamp(IDataSink _sink, String _serviceGroupName) {
        this(_serviceGroupName);
        this.setDataSink(_sink);
    }

    public void setDataSink(IDataSink _sink) {
        this.dataSink_ = _sink;
        this.getErrorHandler().setFaultInfoProvider(this.dataSink_);
        this.getErrorHandler().setConnectionFactory(this.dataSink_);
    }

    public void init(SFCInitializationContext _ctx) throws XQServiceException {
        this.internalInit(_ctx);
        this.continueFlow_ = Boolean.valueOf(_ctx.getParameters().getParameter("ContinueFlow", String.valueOf(this.continueFlow_)));
        Utils.delegateCall(this.dataSink_, "init", new Class[]{SFCInitializationContext.class}, new Object[]{_ctx});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(SFCServiceContext _ctx, XQEnvelope _envelope) throws XQMessageException, XQServiceException {
        LOGGER.trace("DIAGNOSTIC: SyncOffRamp.service() - ENTER");
        this.validateCurrentState();
        XQMessage msg = _envelope.getMessage();
        boolean isRetry = SyncOffRamp.getInitialRetryValue(msg);
        this.stopRequested_ = false;
        boolean success = false;
        boolean blockForCompletion = this.getErrorHandler().getBlockForCompletion();
        if (blockForCompletion) {
            this.addToBlocking();
        }
        try {
            do {
                LOGGER.trace("DIAGNOSTIC: SyncOffRamp.service() - Step 1: Creating connection via ErrorHandler");
                IConnectionContext connection = this.getErrorHandler().createConnection(this.dataSink_, _ctx, msg);
                LOGGER.trace("DIAGNOSTIC: SyncOffRamp.service() - Step 1 complete. Connection: {}", (Object)(connection != null ? connection.getClass().getName() : "null"));
                try {
                    do {
                        LOGGER.trace("DIAGNOSTIC: SyncOffRamp.service() - Step 2: Opening connection");
                        this.getErrorHandler().openConnection(connection, _ctx, msg);
                        LOGGER.trace("DIAGNOSTIC: SyncOffRamp.service() - Step 2 complete. Connection opened");
                        try {
                            Object[] messsages;
                            IConnectionContext underlying = connection;
                            if (connection instanceof ICompositeConnectionContext) {
                                underlying = ((ICompositeConnectionContext)((Object)connection)).getUnderlying();
                            }
                            LOGGER.trace("DIAGNOSTIC: SyncOffRamp.service() - Step 3: Mapping message for offramp. Underlying: {}", (Object)(underlying != null ? underlying.getClass().getName() : "null"));
                            try {
                                messsages = this.dataSink_.getMessageMapper().mapForOfframp(msg, underlying, _ctx);
                                LOGGER.trace("DIAGNOSTIC: SyncOffRamp.service() - Step 3 complete. Mapped messages count: {}", messsages != null ? Integer.valueOf(messsages.length) : "null");
                                if (messsages != null && messsages.length > 0) {
                                    LOGGER.trace("DIAGNOSTIC: SyncOffRamp.service() - First mapped message type: {}, isNull: {}", (Object)(messsages[0] != null ? messsages[0].getClass().getName() : "N/A"), (Object)(messsages[0] == null ? 1 : 0));
                                }
                                if (null == messsages || messsages.length == 0) {
                                    LOGGER.error("DIAGNOSTIC: SyncOffRamp.service() - Step 3 FAILED: No messages produced from mapping!");
                                    throw new XQMessageException("The incoming message did not produce any messages for the data sink.");
                                }
                            }
                            catch (MappingException e) {
                                LOGGER.error("DIAGNOSTIC: SyncOffRamp.service() - Step 3 FAILED with MappingException: {}", (Object)e.getMessage(), (Object)e);
                                throw new XQMessageException((Throwable)e);
                            }
                            try {
                                do {
                                    try {
                                        LOGGER.trace("DIAGNOSTIC: SyncOffRamp.service() - Step 4: Consuming messages. isRetry: {}", (Object)isRetry);
                                        this.dataSink_.consume(underlying, messsages, isRetry);
                                        LOGGER.trace("DIAGNOSTIC: SyncOffRamp.service() - Step 4 complete. Consume successful!");
                                        success = true;
                                    }
                                    catch (XQServiceException e) {
                                        LOGGER.error("DIAGNOSTIC: SyncOffRamp.service() - Step 4 FAILED with XQServiceException: {}", (Object)e.getMessage(), (Object)e);
                                        this.getErrorHandler().handleException(_ctx, msg, connection, e);
                                    }
                                    finally {
                                        isRetry = true;
                                    }
                                } while (!success && !this.stopRequested_);
                            }
                            finally {
                                LOGGER.trace("DIAGNOSTIC: SyncOffRamp.service() - Cleaning up message mapper");
                                this.dataSink_.getMessageMapper().cleanup(underlying, messsages);
                            }
                        }
                        finally {
                            LOGGER.trace("DIAGNOSTIC: SyncOffRamp.service() - Deactivating connection. Success: {}", (Object)success);
                            connection.deactivate(success);
                        }
                    } while (!success && !this.stopRequested_);
                }
                catch (InvalidConnectionException e) {
                    LOGGER.error("DIAGNOSTIC: SyncOffRamp.service() - InvalidConnectionException: {}", (Object)e.getMessage(), (Object)e);
                    this.getErrorHandler().handleInvalidConnectionException(e);
                }
                finally {
                    LOGGER.trace("DIAGNOSTIC: SyncOffRamp.service() - Destroying connection. Success: {}", (Object)success);
                    this.dataSink_.destroyConnection(connection, success);
                }
            } while (!success && !this.stopRequested_);
            if (this.stopRequested_ && !success) {
                LOGGER.trace("DIAGNOSTIC: SyncOffRamp.service() - Stop requested and not successful. Aborting.");
                this.getErrorHandler().failureModeAbort_Service(_ctx, msg, null, null);
                return;
            }
        }
        catch (ExitToServiceException e) {
            LOGGER.trace("DIAGNOSTIC: SyncOffRamp.service() - ExitToServiceException caught (normal flow)");
        }
        finally {
            if (blockForCompletion) {
                this.removeFromBlocking();
            }
        }
        LOGGER.trace("DIAGNOSTIC: SyncOffRamp.service() - EXIT. Success: {}, ContinueFlow: {}", (Object)success, (Object)this.continueFlow_);
        if (this.continueFlow_ && success && _envelope.getAddresses().hasNext()) {
            XQMessage message = this.handleMessageRetaining(msg);
            _ctx.addOutgoing(message);
        }
    }

    private void validateCurrentState() {
        if (null == this.dataSink_) {
            throw new IllegalStateException("No data sink is set.");
        }
        if (null == this.dataSink_.getMessageMapper()) {
            throw new IllegalStateException("The data sink has no mapper set.");
        }
    }
}

