/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.ramps.cleanup;

import com.sonicsw.esb.service.common.ramps.cleanup.ICleanupActions;
import com.sonicsw.esb.service.common.ramps.filename.FilenameCreator;
import com.sonicsw.xq.XQServiceException;
import java.lang.reflect.Constructor;

public final class CleanupInfo {
    public static final String MOVE = "move";
    public static final String RENAME = "rename";
    public static final String DELETE = "delete";
    public static final String NONE = "none";
    private String cleanupAction_ = "none";
    private String destination_ = "";
    private String class_ = "";
    private String prefix_ = "";
    private String suffix_ = "";
    private FilenameCreator renameFileCreator_;

    public String getClassName() {
        return this.class_;
    }

    public void setClassName(String _class) {
        this.class_ = _class;
    }

    public void setCleanupAction(String _cleanupAction) {
        this.cleanupAction_ = _cleanupAction;
    }

    public boolean isDelete() {
        return DELETE.equals(this.cleanupAction_);
    }

    public boolean isMove() {
        return MOVE.equals(this.cleanupAction_);
    }

    public boolean isRename() {
        return RENAME.equals(this.cleanupAction_);
    }

    public String getDestination() {
        return this.destination_;
    }

    public void setDestination(String _destination) {
        this.destination_ = _destination;
    }

    public String getPrefix() {
        return this.prefix_;
    }

    public void setPrefix(String _prefix) {
        this.prefix_ = _prefix;
    }

    public String getSuffix() {
        return this.suffix_;
    }

    public void setSuffix(String _suffix) {
        this.suffix_ = _suffix;
    }

    public void perform(ICleanupActions _cleanupAction, String _path) throws Exception {
        String movePath;
        if (this.isDelete()) {
            _cleanupAction.deleteFile(_path);
        } else if (this.isRename()) {
            String renamePath = this.getRenamedPath(_path);
            _cleanupAction.renameFile(_path, renamePath);
        } else if (this.isMove() && null != (movePath = this.getDestination()) && movePath.length() > 0) {
            movePath = CleanupInfo.getMovedPath(_path, movePath);
            _cleanupAction.renameFile(_path, movePath);
        }
    }

    private String getRenamedPath(String _path) throws XQServiceException {
        this.initRenameFileCreator();
        String renameFilename = "";
        int var = _path.lastIndexOf("/");
        if (var > 0) {
            String filename = _path.substring(var + 1);
            renameFilename = this.renameFileCreator_.createFileName(filename);
        }
        return _path.substring(0, var) + "/" + renameFilename;
    }

    private static String getMovedPath(String _oldPath, String _newPath) {
        int var = _oldPath.lastIndexOf("/");
        return _newPath + "/" + _oldPath.substring(var + 1);
    }

    private void initRenameFileCreator() throws XQServiceException {
        if (null == this.renameFileCreator_) {
            String ftpFileCreatorClass = this.getClassName();
            if (ftpFileCreatorClass == null) {
                throw new XQServiceException("Rename File Creator Class not found in instance definition");
            }
            String ftpFileCreatorPrefix = this.getPrefix();
            if (ftpFileCreatorPrefix == null) {
                throw new XQServiceException("Rename File Prefix not found in instance definition");
            }
            String ftpFileCreatorSuffix = this.getSuffix();
            if (ftpFileCreatorSuffix == null) {
                throw new XQServiceException("Rename File Suffix not found in instance definition");
            }
            this.renameFileCreator_ = CleanupInfo.loadFileCreator(ftpFileCreatorClass, ftpFileCreatorSuffix, ftpFileCreatorPrefix);
        }
    }

    public static FilenameCreator loadFileCreator(String _className, String _suffix, String _prefix) throws XQServiceException {
        Class[] conArgs = new Class[]{String.class, String.class};
        try {
            Class<?> fileCreatorClass = Class.forName(_className);
            Constructor<?> constructor = fileCreatorClass.getConstructor(conArgs);
            Object[] creatorArgs = new Object[]{_prefix, _suffix};
            return (FilenameCreator)constructor.newInstance(creatorArgs);
        }
        catch (Exception e) {
            throw new XQServiceException("Could not load  file creator.", (Throwable)e);
        }
    }
}

