/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.service.common.ramps.pools;

import com.sonicsw.esb.service.common.SFCInitializationContext;
import com.sonicsw.esb.service.common.ramps.IConnectionContext;
import com.sonicsw.esb.service.common.ramps.IConnectionFactory;
import com.sonicsw.esb.service.common.ramps.pools.IPoolableConnectionFactory;
import com.sonicsw.esb.service.common.ramps.pools.PooledConnectionContext;
import com.sonicsw.esb.service.common.ramps.utils.Utils;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQServiceException;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractKeyedPoolConnectionFactory
implements IPoolableConnectionFactory {
    private static final Logger LOGGER = LogManager.getLogger(AbstractKeyedPoolConnectionFactory.class);
    private static final Object DEFAULT_KEY = new Object();
    private KeyedObjectPool sharedPool_;
    private IConnectionFactory underlying_;

    protected AbstractKeyedPoolConnectionFactory(KeyedObjectPool _sharedPool) {
        this.sharedPool_ = _sharedPool;
    }

    public final void init(SFCInitializationContext _context) throws XQServiceException {
        Utils.delegateCall(this.underlying_, "init", new Class[]{SFCInitializationContext.class}, new Object[]{_context});
        this.getConnectionKey();
    }

    private Object getConnectionKey() {
        Object key = null;
        if (this.underlying_ instanceof IPoolableConnectionFactory) {
            key = ((IPoolableConnectionFactory)this.underlying_).getPoolingKey();
        }
        if (null == key) {
            key = DEFAULT_KEY;
        }
        return key;
    }

    public final void setSharedPool(GenericKeyedObjectPool _sharedPool) {
        this.sharedPool_ = _sharedPool;
    }

    protected final void setUnderlying(IConnectionFactory _underlying) {
        this.underlying_ = _underlying;
    }

    @Override
    public final IConnectionContext createConnection(SFCInitializationContext _ctx) throws XQMessageException, XQServiceException {
        Object poolKey = this.getConnectionKey();
        LOGGER.debug("Attempting to borrow connection from pool. Key: {}, Pool: {}", poolKey, (Object)this.sharedPool_);
        if (this.sharedPool_ instanceof GenericKeyedObjectPool) {
            GenericKeyedObjectPool pool = (GenericKeyedObjectPool)this.sharedPool_;
            LOGGER.debug("Pool statistics - NumActive: {}, NumIdle: {}, MaxTotal: {}, MaxIdlePerKey: {}", (Object)pool.getNumActive(), (Object)pool.getNumIdle(), (Object)pool.getMaxTotal(), (Object)pool.getMaxIdlePerKey());
        }
        try {
            IConnectionContext underlying = (IConnectionContext)this.sharedPool_.borrowObject((Object)new PoolKey(poolKey, this.underlying_, _ctx));
            LOGGER.debug("Successfully borrowed connection from pool: {}", (Object)underlying);
            return new PooledConnectionContext(underlying);
        }
        catch (XQServiceException e) {
            LOGGER.error("XQServiceException while borrowing from pool. Key: {}", poolKey, (Object)e);
            throw e;
        }
        catch (XQMessageException e) {
            LOGGER.error("XQMessageException while borrowing from pool. Key: {}", poolKey, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Unrecognized exception while borrowing from pool. Exception type: {}, Message: {}, Key: {}", (Object)e.getClass().getName(), (Object)e.getMessage(), poolKey, (Object)e);
            if (this.sharedPool_ instanceof GenericKeyedObjectPool) {
                GenericKeyedObjectPool pool = (GenericKeyedObjectPool)this.sharedPool_;
                LOGGER.error("Pool state after failure - NumActive: {}, NumIdle: {}, NumWaiters: {}", (Object)pool.getNumActive(), (Object)pool.getNumIdle(), (Object)pool.getNumWaiters());
            }
            throw new XQServiceException("Pool borrowObject did not return an object and threw an unrecognized exception type.", (Throwable)e);
        }
    }

    @Override
    public final void destroyConnection(IConnectionContext _connection, boolean _success) {
        block5: {
            if (_connection instanceof PooledConnectionContext) {
                PooledConnectionContext connection = (PooledConnectionContext)_connection;
                IConnectionContext underlying = connection.getUnderlying();
                PoolKey key = new PoolKey(this.getConnectionKey(), this.underlying_, null);
                try {
                    if (_success) {
                        this.sharedPool_.returnObject((Object)key, (Object)underlying);
                        break block5;
                    }
                    this.sharedPool_.invalidateObject((Object)key, (Object)underlying);
                }
                catch (Exception exception) {}
            } else {
                throw new IllegalArgumentException("AbstractPooledConnectionFactory expects an PooledConnectionContext as connection argument.");
            }
        }
    }

    @Override
    public final Object getPoolingKey() {
        if (this.underlying_ instanceof IPoolableConnectionFactory) {
            IPoolableConnectionFactory poolable = (IPoolableConnectionFactory)this.underlying_;
            poolable.getPoolingKey();
        }
        return null;
    }

    public final void start() throws XQServiceException {
        Utils.delegateCall(this.underlying_, "start");
    }

    public final void stop() throws XQServiceException {
        Utils.delegateCall(this.underlying_, "stop");
    }

    public final void destroy() {
        try {
            Utils.delegateCall(this.underlying_, "destroy");
        }
        catch (XQServiceException xQServiceException) {
            // empty catch block
        }
    }

    final class PoolKey {
        private final IConnectionFactory factory_;
        private final SFCInitializationContext context_;
        private final Object key_;

        public PoolKey(Object _key, IConnectionFactory _factory, SFCInitializationContext _context) {
            this.factory_ = _factory;
            this.context_ = _context;
            this.key_ = _key;
        }

        public IConnectionFactory getFactory() {
            return this.factory_;
        }

        public SFCInitializationContext getContext() {
            return this.context_;
        }

        public boolean equals(Object _other) {
            if (_other instanceof PoolKey) {
                PoolKey other = (PoolKey)_other;
                return this.key_.equals(other.key_);
            }
            return false;
        }

        public int hashCode() {
            return this.key_.hashCode();
        }
    }
}

