// =====================================================================================================================
// Copyright (c) 2016. Aurea Software, Inc. All Rights Reserved.
//
// You are hereby placed on notice that the software, its related technology and services may be covered by one or
// more United States ("US") and non-US patents. A listing that associates patented and patent-pending products
// included in the software, software updates, their related technology and services with one or more patent numbers
// is available for you and the general public's access at www.aurea.com/legal/ (the "Patent Notice") without charge.
// The association of products-to-patent numbers at the Patent Notice may not be an exclusive listing of associations,
// and other unlisted patents or pending patents may also be associated with the products. Likewise, the patents or
// pending patents may also be associated with unlisted products. You agree to regularly review the products-to-patent
// number(s) association at the Patent Notice to check for updates.
// =====================================================================================================================

package com.aurea.sonic.esb.pojo.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * The {@linkplain InitParameter} annotation specifies an attribute of {@linkplain SonicPOJO} ESB Service. Indicates that the annotated
 * field is configured by a service instance initialization parameter. Service initialization parameters
 * permit specialization of each POJO service instance and associated fields are set on service startup, Annotation attributes
 * describe UI rendering, validation and initialization characteristics of the service configuration initialization parameter.
 *
 * @since 10.0.7
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.CLASS)
public @interface InitParameter {

    /**
     * Init parameter name(default: the field name)
     * <p>
     * @return init parameter name, used by programming APIs
     *
     */
    String name() default "";

    /**
     * Init parameter display name(default: the field name)
     * <p>
     * @return label used by UIs to display the parameter
     *
     */
    String displayName() default "";

    /**
     * Init parameter description
     * @return descriptive text about the parameter usage and values
     */
    String description() default "";

    /**
     * Init parameter required(default false)
     * @return indicates whether the UI requires a parameter to be entered
     */
    boolean required() default false;

    /**
     * Init parameter hidden(default false)
     * @return indicates whether the UI hides the parameter from the user
     *
     */
    boolean hidden() default false;

    /**
     * Init parameter for password(default false)
     * @return indicates whether it is password or not.
     *
     */
    boolean password() default false;

    /**
     * Init parameter read only(default false)
     * @return indicates whether the UI disables changing the parameter from the defaulted value
     */
    boolean readOnly() default false;

    /**
     * Init parameter enable substution(default false)
     * @return indicates if the UI entry supports a entering of a variable that is evaluated at service startime
     * to a real value, for example, variables can specify a container deployment parameter, JVM or property file
     * property.
     *
     */
    boolean enableSubstitution() default false;

    /**
     * Init parameter default value
     * @return default value of init parameter
     *
     */
    String defaultValue() default "";

}