/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.sonic.esb.pojo.processor.model;

import com.aurea.sonic.esb.annotation.util.ProcessorContext;
import com.aurea.sonic.esb.pojo.annotation.SonicPOJO;
import com.aurea.sonic.esb.pojo.processor.model.AttributeModel;
import com.aurea.sonic.esb.pojo.processor.model.OperationModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

public class ServiceModel {
    private final Element type;
    private String name;
    private String displayName;
    private String instanceName;
    private String description;
    private final List<OperationModel> operations = new ArrayList<OperationModel>();
    private final List<AttributeModel> attributes = new ArrayList<AttributeModel>();
    private final String className;

    public ServiceModel(ProcessorContext context, Element element) {
        this.type = element;
        SonicPOJO serviceAnnotation = element.getAnnotation(SonicPOJO.class);
        this.name = "".equals(serviceAnnotation.name()) ? element.getSimpleName().toString() : serviceAnnotation.name();
        this.displayName = "".equals(serviceAnnotation.displayName()) ? this.name : serviceAnnotation.displayName();
        this.instanceName = "".equals(serviceAnnotation.instanceName()) ? this.name + "Instance" : serviceAnnotation.instanceName();
        this.description = serviceAnnotation.description();
        TypeElement classElement = (TypeElement)element;
        this.className = classElement.getQualifiedName().toString();
    }

    public Element getType() {
        return this.type;
    }

    public List<OperationModel> getOperations() {
        return Collections.unmodifiableList(this.operations);
    }

    public List<AttributeModel> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public void addOperation(OperationModel operation) {
        this.operations.add(operation);
    }

    public void addAttribute(AttributeModel attribute) {
        this.attributes.add(attribute);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getClassName() {
        return this.className;
    }

    public String toString() {
        return "ServiceType [type=" + this.type + ", name=" + this.name + ", displayName=" + this.displayName + ", instanceName=" + this.instanceName + ", description=" + this.description + ", operations=" + this.operations + ", attributes=" + this.attributes + ", className=" + this.className + "]";
    }
}

