/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.action;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.IArtifactTraverser;
import com.sonicsw.deploy.action.AbstractAction;
import com.sonicsw.deploy.traversal.TraverserContext;
import com.sonicsw.xqimpl.util.ClassUtils;

public class SearchAction
extends AbstractAction {
    private IArtifact[] m_ignore;
    private IArtifactTraverser[] m_traverser;
    private IArtifact[] m_result;
    private IArtifact[] m_errors;
    private boolean m_traverseCompressed;

    public SearchAction(IArtifact[] ignore, IArtifactTraverser traverser) {
        this(ignore, new IArtifactTraverser[]{traverser}, false);
    }

    public SearchAction(IArtifact[] ignore, IArtifactTraverser[] traverser, boolean compressed) {
        this.m_ignore = (IArtifact[])ClassUtils.arrayCopy((Object[])ignore);
        this.m_traverser = (IArtifactTraverser[])ClassUtils.arrayCopy((Object[])traverser);
        this.m_traverseCompressed = false;
        this.m_traverseCompressed = compressed;
    }

    @Override
    public String getDescription() {
        return "Search";
    }

    public IArtifact[] getResult() {
        return this.m_result;
    }

    public IArtifact[] getErrors() {
        return this.m_errors;
    }

    @Override
    public void run(IArtifactStorage source) throws Exception {
        TraverserContext context = new TraverserContext(source, this.m_ignore);
        context.setTraverseCompressed(this.m_traverseCompressed);
        for (int i = 0; i < this.m_traverser.length; ++i) {
            this.m_traverser[i].traverse(context);
        }
        this.m_result = context.completeTraversal();
        this.m_errors = context.getErrored();
    }

    public static IArtifact[] search(IArtifactStorage source, IArtifact[] ignore, IArtifactTraverser traverser) throws Exception {
        return SearchAction.search(source, ignore, traverser, false);
    }

    public static IArtifact[] search(IArtifactStorage source, IArtifact[] ignore, IArtifactTraverser traverser, boolean compressed) throws Exception {
        SearchAction action = new SearchAction(ignore, traverser);
        action.m_traverseCompressed = compressed;
        source.performAction(action);
        return action.getResult();
    }

    public static IArtifact[] search(IArtifactStorage source, IArtifact[] ignore, IArtifactTraverser[] traversers) throws Exception {
        return SearchAction.search(source, ignore, traversers, false);
    }

    public static IArtifact[] search(IArtifactStorage source, IArtifact[] ignore, IArtifactTraverser[] traversers, boolean compressed) throws Exception {
        SearchAction action = new SearchAction(ignore, traversers, compressed);
        source.performAction(action);
        return action.getResult();
    }
}

