/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.compare;

import com.sonicsw.deploy.compare.MQDependencyBase;
import com.sonicsw.sonicxq.ConnectionDocument;
import com.sonicsw.sonicxq.ConnectionRevDependencyType;
import com.sonicsw.sonicxq.ESBRevDependencyDocument;
import com.sonicsw.sonicxq.EndpointDocument;
import com.sonicsw.sonicxq.EndpointRevDependencyType;
import com.sonicsw.sonicxq.ParamsType;
import com.sonicsw.sonicxq.RevDependencyListType;
import java.io.File;
import java.io.IOException;
import org.apache.xmlbeans.XmlOptions;

public class MQRevDependency
extends MQDependencyBase {
    private ESBRevDependencyDocument m_dependencyDoc = ESBRevDependencyDocument.Factory.newInstance();

    public MQRevDependency() {
        RevDependencyListType dependencyList = RevDependencyListType.Factory.newInstance();
        this.m_dependencyDoc.setESBRevDependency(dependencyList);
    }

    @Override
    public void generateReport(File file, String storeName) throws IOException {
        XmlOptions opts = new XmlOptions();
        opts.setSavePrettyPrint();
        opts.setSavePrettyPrintIndent(4);
        this.m_dependencyDoc.getESBRevDependency().setSource(storeName);
        this.m_dependencyDoc.getESBRevDependency().setDate(this.m_reportDate);
        this.m_dependencyDoc.save(file, opts);
    }

    @Override
    protected void handleEndpoint(EndpointDocument endpoint) {
        EndpointRevDependencyType ep = null;
        ParamsType params = endpoint.getEndpoint().getParams();
        if (params != null) {
            boolean dependencyFound = false;
            ep = EndpointRevDependencyType.Factory.newInstance();
            ep.setEndpointName(endpoint.getEndpoint().getName());
            ParamsType.StringParam[] stringParams = params.getStringParamArray();
            for (int i = 0; i < stringParams.length; ++i) {
                if (stringParams[i].getName().compareTo("destination") == 0) {
                    ep.setDestinationName(stringParams[i].getStringValue());
                    dependencyFound = true;
                }
                if (stringParams[i].getName().compareTo("type") == 0) {
                    ep.setDestinationType(stringParams[i].getStringValue());
                    dependencyFound = true;
                }
                if (stringParams[i].getName().compareTo("durableSubscriber") != 0) continue;
                ep.setDestinationIsDurable(stringParams[i].getStringValue());
                dependencyFound = true;
            }
            if (dependencyFound) {
                this.m_mqDestinationList.add(ep);
            }
        }
    }

    @Override
    protected void completeEndpointAnalysis() {
        EndpointRevDependencyType[] endpointDependencies = this.m_mqDestinationList.toArray(new EndpointRevDependencyType[0]);
        this.m_dependencyDoc.getESBRevDependency().setEndpointRevDependencyArray(endpointDependencies);
    }

    @Override
    protected void handleConnection(ConnectionDocument connection) {
        ConnectionRevDependencyType conn = null;
        ParamsType params = connection.getConnection().getParams();
        if (params != null) {
            boolean dependencyFound = false;
            conn = ConnectionRevDependencyType.Factory.newInstance();
            conn.setConnectionName(connection.getConnection().getName());
            ParamsType.StringParam[] stringParams = params.getStringParamArray();
            for (int i = 0; i < stringParams.length; ++i) {
                if (stringParams[i].getName().compareTo("url") != 0) continue;
                conn.setUrl(stringParams[i].getStringValue());
                dependencyFound = true;
            }
            if (dependencyFound) {
                this.m_mqConnectionList.add(conn);
            }
        }
    }

    @Override
    protected void completeConnectionAnalysis() {
        ConnectionRevDependencyType[] connectionDependencies = this.m_mqConnectionList.toArray(new ConnectionRevDependencyType[0]);
        this.m_dependencyDoc.getESBRevDependency().setConnectionRevDependencyArray(connectionDependencies);
    }
}

