/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.util;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.artifact.ArtifactFactory;
import com.sonicsw.deploy.artifact.ConfigBeanArtifact;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.artifact.ZipContentArtifact;
import com.sonicsw.deploy.artifact.ZipFileArtifact;
import com.sonicsw.deploy.compare.AbstractFileComparator;
import com.sonicsw.deploy.storage.FileArtifactStorage;
import com.sonicsw.deploy.traversal.ExtnPropertiesTraverser;
import com.sonicsw.deploy.util.ELExpressionUtils;
import com.sonicsw.deploy.util.FileUtils;
import com.sonicsw.deploy.util.MapCreator;
import com.sonicsw.deploy.util.MapLog;
import com.sonicsw.deploy.util.XmlBeanValidator;
import com.sonicsw.sonicxq.ArtifactWarningType;
import com.sonicsw.sonicxq.BasicClassLoading;
import com.sonicsw.sonicxq.ClassLoading;
import com.sonicsw.sonicxq.ClassPathReplaceMappingType;
import com.sonicsw.sonicxq.ClassPathReplaceMapsType;
import com.sonicsw.sonicxq.ConnectionDocument;
import com.sonicsw.sonicxq.ConnectionMapType;
import com.sonicsw.sonicxq.ConnectionMapsType;
import com.sonicsw.sonicxq.DecisionType;
import com.sonicsw.sonicxq.DevMappingType;
import com.sonicsw.sonicxq.EndpointDocument;
import com.sonicsw.sonicxq.EndpointMapType;
import com.sonicsw.sonicxq.EndpointMapsType;
import com.sonicsw.sonicxq.EndpointRefMapType;
import com.sonicsw.sonicxq.EndpointRefType;
import com.sonicsw.sonicxq.EndpointRefTypeEnumeration;
import com.sonicsw.sonicxq.EndpointSchemaType;
import com.sonicsw.sonicxq.ExitEndpointMapType;
import com.sonicsw.sonicxq.ExitEndpointsMapType;
import com.sonicsw.sonicxq.FanoutType;
import com.sonicsw.sonicxq.ItineraryStepMapType;
import com.sonicsw.sonicxq.ItineraryStepsMapType;
import com.sonicsw.sonicxq.ItineraryType;
import com.sonicsw.sonicxq.ParamsMapType;
import com.sonicsw.sonicxq.ParamsType;
import com.sonicsw.sonicxq.ProcessDocument;
import com.sonicsw.sonicxq.ProcessMapType;
import com.sonicsw.sonicxq.ProcessMapsType;
import com.sonicsw.sonicxq.PropertyReplaceMappingType;
import com.sonicsw.sonicxq.PropertyReplaceMapsType;
import com.sonicsw.sonicxq.ServiceDocument;
import com.sonicsw.sonicxq.ServiceMapType;
import com.sonicsw.sonicxq.ServiceMapsType;
import com.sonicsw.sonicxq.StepType;
import com.sonicsw.sonicxq.StringReplaceMapsType;
import com.sonicsw.sonicxq.TailoringMapsDocument;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;

public class MapApplicator {
    private IArtifactStorage m_store;
    private TailoringMapsDocument m_map = null;
    private MapLog m_logFile = null;
    private ProcessMapType[] m_mapProcesses = null;
    private ServiceMapType[] m_mapServices = null;
    private EndpointMapType[] m_mapEndpoints = null;
    private ConnectionMapType[] m_mapConnections = null;
    private List<ArtifactWarningType> m_warnings = new ArrayList<ArtifactWarningType>();
    private StringReplacements[] m_stringReplacements = null;
    private Map<String, HashMap<String, String>> m_propertyReplacements = new HashMap<String, HashMap<String, String>>();
    private Map<String, HashMap<String, String>> m_classPathReplacements = new HashMap<String, HashMap<String, String>>();
    private Map<String, UrlPathUpdate> m_urlPathUpdates = new HashMap<String, UrlPathUpdate>();
    public String processId = "Process";
    public String serviceId = "Service";
    public String endpointId = "Endpoint";
    public String connectionId = "Connection";
    public String propertiesId = "Properties";
    public String classpathId = "Classpath";
    public static String SonicFSURL = "sonicfs:///";
    public static String mapVersionXSLT = "style/MapUpgradeTo70.xsl";
    public static final String GENERIC_ARTIFACT_NAME = "*";

    public MapApplicator(IArtifactStorage source) {
        this.m_store = source;
    }

    public void ApplyMapFile(File mapFile, File logFile, IArtifactStorage target, IArtifact[] artifacts) throws Exception, IOException, XmlException {
        this.m_logFile = new MapLog(logFile);
        this.m_map = TailoringMapsDocument.Factory.parse(mapFile);
        HashSet<ZipFileArtifact> zipFiles = new HashSet<ZipFileArtifact>();
        HashMap<IArtifact, String> deferredArtifacts = new HashMap<IArtifact, String>();
        this.convertMap(mapFile);
        if (!XmlBeanValidator.validate(this.m_store, this.m_map)) {
            throw new Exception("Invalid map file provided");
        }
        if (this.m_map != null) {
            ConnectionMapsType connectionList;
            EndpointMapsType endpointList;
            ServiceMapsType serviceList;
            ProcessMapsType processList = this.m_map.getTailoringMaps().getProcessMaps();
            if (processList != null) {
                this.m_mapProcesses = processList.getProcessMapArray();
            }
            if ((serviceList = this.m_map.getTailoringMaps().getServiceMaps()) != null) {
                this.m_mapServices = serviceList.getServiceMapArray();
            }
            if ((endpointList = this.m_map.getTailoringMaps().getEndpointMaps()) != null) {
                this.m_mapEndpoints = endpointList.getEndpointMapArray();
            }
            if ((connectionList = this.m_map.getTailoringMaps().getConnectionMaps()) != null) {
                this.m_mapConnections = connectionList.getConnectionMapArray();
            }
        }
        this.validateMapFile();
        this.initPropertyReplacements();
        this.initClassPathReplacements();
        this.initStringReplacements();
        this.initLogger();
        for (int i = 0; i < artifacts.length; ++i) {
            String stringReplacedData;
            boolean isXMLorTextExtn;
            String extension = null;
            extension = this.m_store instanceof FileArtifactStorage ? ((FileArtifactStorage)this.m_store).getFileExtension(artifacts[i]) : artifacts[i].getExtension();
            IArtifact current = artifacts[i];
            boolean isESBorBean = current instanceof ESBArtifact || current instanceof ConfigBeanArtifact;
            boolean bl = isXMLorTextExtn = AbstractFileComparator.isXMLExtension(extension) || AbstractFileComparator.isTextExtension(extension);
            if (current instanceof ZipFileArtifact) {
                zipFiles.add((ZipFileArtifact)current);
                continue;
            }
            if (!isESBorBean && !isXMLorTextExtn) {
                target.store(this.updateArtifactPath(artifacts[i]), this.m_store.getContentsAsBytes(artifacts[i]));
                continue;
            }
            String data = this.m_store.getContentsAsString(artifacts[i]);
            if (current instanceof ESBArtifact) {
                data = this.processESBArtifact(current, data);
            }
            if (current instanceof SonicFSArtifact && ExtnPropertiesTraverser.isValidExtension(current.getExtension())) {
                data = this.doPropertyReplacements(current, data);
            }
            if ((stringReplacedData = this.doStringReplacements(current, data)) != null) {
                data = stringReplacedData;
            }
            deferredArtifacts.put(current, data);
        }
        for (Map.Entry entry : deferredArtifacts.entrySet()) {
            target.store(this.updateArtifactPath((IArtifact)entry.getKey()), entry.getValue());
        }
        for (ZipFileArtifact zip : zipFiles) {
            zip.getZipStorage().saveArchive();
            byte[] content = FileUtils.readFile(zip.getZipStorage().getArchive());
            IArtifact updatedArtifact = this.updateArtifactPath(zip);
            target.store(updatedArtifact, content);
        }
        if (this.m_warnings.size() > 0) {
            this.m_logFile.addWarnings(this.m_warnings);
        }
        this.m_logFile.write();
    }

    private String processESBArtifact(IArtifact current, String data) throws XmlException, Exception {
        String mappedData = null;
        String path = current.getParentPath();
        if (!path.equals(ESBArtifact.CONTAINER.getPath())) {
            if (path.equals(ESBArtifact.SERVICE.getPath())) {
                mappedData = this.processServiceDoc(data);
            } else if (!path.equals(ESBArtifact.SERVICE_TYPE.getPath())) {
                if (path.equals(ESBArtifact.PROCESS.getPath())) {
                    mappedData = this.processProcessDoc(data);
                } else if (path.equals(ESBArtifact.ENDPOINT.getPath())) {
                    mappedData = this.processEndpointDoc(data);
                } else if (path.equals(ESBArtifact.CONNECTION.getPath())) {
                    mappedData = this.processConnectionDoc(data);
                }
            }
        }
        if (mappedData != null) {
            String xmlHeader = MapApplicator.getXMLHeader(data);
            if (xmlHeader != null) {
                mappedData = xmlHeader + "\n" + mappedData;
            }
            data = mappedData;
        }
        return data;
    }

    private void convertMap(File mapFile) throws Exception {
        String mapVersion;
        if (!(this.m_map == null || this.m_map.getTailoringMaps() == null || (mapVersion = this.m_map.getTailoringMaps().getVersion()) != null && MapCreator.isCompatibleVersion(mapVersion))) {
            StreamSource xmlSource = new StreamSource(mapFile);
            URL xslURL = this.getClass().getClassLoader().getResource(mapVersionXSLT);
            if (xslURL != null) {
                StreamSource xsltSource = new StreamSource(xslURL.openStream());
                DOMResult upgradedMapResult = new DOMResult();
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer(xsltSource);
                transformer.transform(xmlSource, upgradedMapResult);
                this.m_map = TailoringMapsDocument.Factory.parse(upgradedMapResult.getNode());
            } else {
                String errorMessage = "Map conversion stylesheet " + mapVersionXSLT + " not found";
                throw new Exception(errorMessage);
            }
        }
    }

    private String doPropertyReplacements(IArtifact artifact, String data) {
        String extension = artifact.getExtension();
        if (!ExtnPropertiesTraverser.isValidExtension(extension)) {
            return data;
        }
        Map effectivePropertyReplacements = this.m_propertyReplacements.get(artifact.getName());
        Map genericPropertyReplacements = this.m_propertyReplacements.get(GENERIC_ARTIFACT_NAME);
        if (effectivePropertyReplacements == null || effectivePropertyReplacements.isEmpty()) {
            if (genericPropertyReplacements == null || genericPropertyReplacements.isEmpty()) {
                return data;
            }
            effectivePropertyReplacements = genericPropertyReplacements;
        } else if (genericPropertyReplacements != null) {
            for (Map.Entry genericPropertyReplacement : genericPropertyReplacements.entrySet()) {
                if (effectivePropertyReplacements.containsKey(genericPropertyReplacement.getKey())) continue;
                effectivePropertyReplacements.put(genericPropertyReplacement.getKey(), genericPropertyReplacement.getValue());
            }
        }
        byte[] propsAsBytes = data.getBytes();
        ByteArrayInputStream instream = new ByteArrayInputStream(propsAsBytes);
        Properties originalProps = new Properties();
        try {
            originalProps.load(instream);
        }
        catch (IOException e) {
            String warning = "Unable to process property replacements for " + artifact.getName() + " due to IOException " + e.getMessage();
            this.addWarning(artifact.getName(), this.propertiesId, warning);
        }
        Iterator iter = effectivePropertyReplacements.entrySet().iterator();
        ArrayList<PropertyReplacementInfo> modifyList = new ArrayList<PropertyReplacementInfo>(effectivePropertyReplacements.size());
        while (iter.hasNext()) {
            Map.Entry propReplacement = iter.next();
            String propName = (String)propReplacement.getKey();
            int nameIdx = this.getPropKeyIndex(data, propName);
            String oldValue = (String)originalProps.get(propName);
            if (oldValue == null || oldValue.length() == 0) {
                this.addWarning(artifact.getName(), this.propertiesId, "Invalid property " + propName + " in artifact " + artifact.getPath());
                continue;
            }
            int startIdx = nameIdx + propName.length();
            String separator = data.substring(startIdx).replaceAll("(?s)(\\s*=*:*\\s*)(.*$)", "$1");
            int oldValueIdx = startIdx + separator.length();
            oldValue = this.getPropValue(data, oldValueIdx);
            String newValue = (String)propReplacement.getValue();
            modifyList.add(new PropertyReplacementInfo(propName, nameIdx, oldValue, oldValueIdx, newValue));
        }
        Collections.sort(modifyList);
        boolean propertyReplaced = false;
        StringBuilder dataBuffer = new StringBuilder(data.length() + modifyList.size() * 8);
        int currentIdx = 0;
        for (int i = 0; i < modifyList.size(); ++i) {
            propertyReplaced = true;
            PropertyReplacementInfo replaceInfo = (PropertyReplacementInfo)modifyList.get(i);
            this.handleFSReplacement(artifact.getName(), this.propertiesId, replaceInfo.propName, replaceInfo.oldValue, replaceInfo.newValue);
            dataBuffer.append(data.substring(currentIdx, replaceInfo.oldValueIdx));
            dataBuffer.append(replaceInfo.newValue);
            currentIdx = replaceInfo.oldValueIdx + replaceInfo.oldValue.length();
            this.m_logFile.logUpdate(artifact.getDisplayType(), artifact.getName(), "Property Replacement", replaceInfo.propName + "=" + replaceInfo.oldValue, replaceInfo.propName + "=" + replaceInfo.newValue);
        }
        if (propertyReplaced) {
            dataBuffer.append(data.substring(currentIdx));
            if (artifact instanceof ZipContentArtifact) {
                ((ZipContentArtifact)artifact).getZipFileArtifact().markDirty();
            }
            return dataBuffer.toString();
        }
        return data;
    }

    private void handleFSReplacement(String artifactName, String type, String propName, String oldValue, String newValue) {
        String oldFSName = this.toFSName(oldValue);
        String newFSName = this.toFSName(newValue);
        if (oldFSName == null || newFSName == null) {
            return;
        }
        String oldPathAsKey = oldFSName.toLowerCase();
        UrlPathUpdate urlPathUpdate = this.m_urlPathUpdates.get(oldPathAsKey);
        if (urlPathUpdate == null) {
            urlPathUpdate = new UrlPathUpdate(artifactName, propName, oldValue, newValue);
            this.m_urlPathUpdates.put(oldPathAsKey, urlPathUpdate);
        } else if (!urlPathUpdate.newUrlPath.equals(newValue)) {
            String warning = "Inconsistent path update for " + propName + ":\n" + "'" + oldFSName + "' mapped to '" + newFSName + "' but previously mapped to '" + urlPathUpdate.newUrlPath + "' for " + urlPathUpdate.artifact + " - " + urlPathUpdate.propName;
            this.addWarning(artifactName, type, warning);
        }
    }

    private String toFSName(String value) {
        if (value == null || value.startsWith("sonicfs://")) {
            return value;
        }
        return ELExpressionUtils.getFSNameFromELExpression(value);
    }

    private void doClassPathReplacements(String artifactName, ClassLoading classLoading) {
        if (classLoading == null) {
            return;
        }
        Map effectiveReplacements = this.m_classPathReplacements.get(artifactName);
        Map genericReplacements = this.m_classPathReplacements.get(GENERIC_ARTIFACT_NAME);
        if (effectiveReplacements == null || effectiveReplacements.isEmpty()) {
            effectiveReplacements = genericReplacements;
        } else if (genericReplacements != null) {
            for (Map.Entry entry : genericReplacements.entrySet()) {
                if (effectiveReplacements.containsKey(entry.getKey())) continue;
                effectiveReplacements.put(entry.getKey(), entry.getValue());
            }
        }
        if (effectiveReplacements == null || effectiveReplacements.isEmpty()) {
            return;
        }
        if (classLoading.isSetServiceInstance()) {
            this.doClassPathReplacements(effectiveReplacements, classLoading.getServiceInstance(), artifactName, "serviceInstance");
        }
        if (classLoading.isSetServiceType()) {
            this.doClassPathReplacements(effectiveReplacements, classLoading.getServiceType(), artifactName, "serviceType");
        }
        if (classLoading.isSetXqContainer()) {
            this.doClassPathReplacements(effectiveReplacements, classLoading.getXqContainer(), artifactName, "xqContainer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClassPathReplacements(Map<String, String> replacements, BasicClassLoading classLoading, String artifactName, String classpath) {
        if (classLoading == null) {
            return;
        }
        XmlCursor cursor = classLoading.getClasspathList().newCursor();
        try {
            if (cursor.toFirstChild()) {
                do {
                    String entry;
                    String newEntry;
                    if ((newEntry = replacements.get(entry = cursor.getTextValue())) == null) continue;
                    if (newEntry.trim().length() == 0) {
                        cursor.removeXml();
                    } else {
                        cursor.setTextValue(newEntry);
                        this.handleFSReplacement(artifactName, this.classpathId, classpath + " classpath", entry, newEntry);
                    }
                    this.m_logFile.logUpdate(this.serviceId, artifactName, "Classpath Replacement (" + classpath + ")", entry, newEntry);
                } while (cursor.toNextSibling());
            }
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
    }

    private String doStringReplacements(IArtifact artifact, String data) {
        if (artifact instanceof ZipFileArtifact) {
            return null;
        }
        boolean stringReplaced = false;
        if (this.m_stringReplacements != null) {
            for (int i = 0; i < this.m_stringReplacements.length; ++i) {
                String artifactPath;
                boolean sameFilePath;
                String artifactName;
                boolean sameFile;
                if (this.m_stringReplacements[i].artifactName != null && !(sameFile = (artifactName = this.m_stringReplacements[i].artifactName).equalsIgnoreCase(artifact.getName())) && !(sameFilePath = artifactName.equalsIgnoreCase(artifactPath = "SonicFS".equalsIgnoreCase(artifact.getDisplayType()) ? "sonicfs://" + artifact.getPath() : artifact.getPath()))) continue;
                if (this.m_stringReplacements[i].oldValue == null || "".equals(this.m_stringReplacements[i].oldValue)) {
                    throw new IllegalArgumentException("stringReplaceMap name must have content. Found stringReplaceMap with name=\"" + this.m_stringReplacements[i].oldValue + "\" updatedName=\"" + this.m_stringReplacements[i].newValue + "\"");
                }
                StringBuilder result = new StringBuilder();
                int startIdx = 0;
                int idxOld = 0;
                while ((idxOld = data.indexOf(this.m_stringReplacements[i].oldValue, startIdx)) >= 0) {
                    result.append(data.substring(startIdx, idxOld));
                    result.append(this.m_stringReplacements[i].newValue);
                    startIdx = idxOld + this.m_stringReplacements[i].oldValue.length();
                    this.m_logFile.logUpdate(artifact.getDisplayType(), artifact.getName(), "String replacement", this.m_stringReplacements[i].oldValue, this.m_stringReplacements[i].newValue);
                    stringReplaced = true;
                }
                result.append(data.substring(startIdx));
                data = result.toString();
            }
            if (stringReplaced && artifact instanceof ZipContentArtifact) {
                ((ZipContentArtifact)artifact).getZipFileArtifact().markDirty();
            }
        }
        return data;
    }

    private static String getXMLHeader(String data) {
        String xmlHeader = null;
        String processingInstructionString = "<?";
        String versionString = "version=\"";
        String encodingString = "encoding=\"";
        int headerStart = data.indexOf("<");
        int headerEnd = data.indexOf(">") + 1;
        if (headerStart != -1 && headerEnd != -1 && ((xmlHeader = data.substring(headerStart, headerEnd)).indexOf(processingInstructionString) == -1 || xmlHeader.indexOf(encodingString) == -1 || xmlHeader.indexOf(versionString) == -1)) {
            xmlHeader = null;
        }
        return xmlHeader;
    }

    private void initPropertyReplacements() throws Exception {
        PropertyReplaceMapsType[] propertyReplaceMapsArray = this.m_map.getTailoringMaps().getPropertyReplaceMapsArray();
        for (int i = 0; i < propertyReplaceMapsArray.length; ++i) {
            PropertyReplaceMappingType[] propertyReplaceMapArray = propertyReplaceMapsArray[i].getPropertyReplaceMapArray();
            if (propertyReplaceMapArray.length <= 0) continue;
            HashMap<String, String> replacements = null;
            String artifactName = propertyReplaceMapsArray[i].getArtifactName();
            if (artifactName == null) {
                artifactName = GENERIC_ARTIFACT_NAME;
                replacements = this.m_propertyReplacements.get(artifactName);
            } else if (this.m_propertyReplacements.containsKey(artifactName)) {
                if (propertyReplaceMapArray.length > 0) {
                    String errorMessage = "Duplicate property replacement specified for " + artifactName;
                    throw new Exception(errorMessage);
                }
                return;
            }
            if (replacements == null) {
                replacements = new HashMap<String, String>(propertyReplaceMapArray.length);
            }
            if (propertyReplaceMapArray.length <= 0) continue;
            for (int j = 0; j < propertyReplaceMapArray.length; ++j) {
                replacements.put(propertyReplaceMapArray[j].getPropertyName(), propertyReplaceMapArray[j].getUpdatedValue());
            }
            if (this.m_propertyReplacements.containsKey(artifactName)) continue;
            this.m_propertyReplacements.put(artifactName, replacements);
        }
    }

    private void initClassPathReplacements() throws Exception {
        for (ClassPathReplaceMapsType replaceMapsType : this.m_map.getTailoringMaps().getClassPathReplaceMapsArray()) {
            ClassPathReplaceMappingType[] replaceMappings = replaceMapsType.getClassPathReplaceMapArray();
            if (replaceMappings.length == 0) continue;
            String artifactName = replaceMapsType.getArtifactName();
            if (artifactName == null) {
                artifactName = GENERIC_ARTIFACT_NAME;
            } else if (this.m_classPathReplacements.containsKey(artifactName)) {
                throw new Exception("Duplicate classpath replacement specified for " + artifactName);
            }
            HashMap<String, String> replacements = this.m_classPathReplacements.get(artifactName);
            if (replacements == null) {
                replacements = new HashMap<String, String>(replaceMappings.length);
            }
            for (ClassPathReplaceMappingType replaceMapping : replaceMappings) {
                replacements.put(replaceMapping.getEntry(), replaceMapping.getNewEntry());
            }
            this.m_classPathReplacements.put(artifactName, replacements);
        }
    }

    private void initStringReplacements() throws Exception {
        DevMappingType[] stringMapArray;
        StringReplaceMapsType stringReplaceMaps = this.m_map.getTailoringMaps().getStringReplaceMaps();
        ArrayList<StringReplacements> orderedArray = new ArrayList<StringReplacements>();
        ArrayList<StringReplacements> unorderedArray = new ArrayList<StringReplacements>();
        if (stringReplaceMaps != null && (stringMapArray = stringReplaceMaps.getStringReplaceMapArray()) != null) {
            int i;
            block2: for (i = 0; i < stringMapArray.length; ++i) {
                StringReplacements replacement = new StringReplacements();
                replacement.oldValue = stringMapArray[i].getName();
                replacement.newValue = stringMapArray[i].getUpdatedName();
                String string = replacement.artifactName = stringMapArray[i].isSetArtifactName() ? stringMapArray[i].getArtifactName() : null;
                if (stringMapArray[i].isSetOrder()) {
                    try {
                        replacement.orderValue = Integer.parseInt(stringMapArray[i].getOrder());
                    }
                    catch (Exception e) {
                        String errorMessage = "Invalid string replacement order specified: " + stringMapArray[i].getOrder() + "\n";
                        errorMessage = errorMessage + "String replacement indeces must start with 1 and proceed in order\n";
                        throw new Exception(errorMessage);
                    }
                    if (orderedArray.size() == 0) {
                        orderedArray.add(replacement);
                        continue;
                    }
                    for (int j = 0; j < orderedArray.size(); ++j) {
                        StringReplacements fromList = (StringReplacements)orderedArray.get(j);
                        if (fromList.orderValue == replacement.orderValue) {
                            String errorMessage = "Duplicate or non-sequential string replacement order specified: " + stringMapArray[i].getOrder() + "\n";
                            errorMessage = errorMessage + "String replacement indeces must start with 1 and proceed in order\n";
                            throw new Exception(errorMessage);
                        }
                        if (replacement.orderValue < fromList.orderValue) {
                            orderedArray.add(j, replacement);
                            continue block2;
                        }
                        if (j != orderedArray.size() - 1) continue;
                        orderedArray.add(replacement);
                        continue block2;
                    }
                    continue;
                }
                unorderedArray.add(replacement);
            }
            for (i = 0; i < unorderedArray.size(); ++i) {
                orderedArray.add((StringReplacements)unorderedArray.get(i));
            }
            this.m_stringReplacements = orderedArray.toArray(new StringReplacements[0]);
        }
    }

    private IArtifact updateArtifactPath(IArtifact artifact) {
        boolean isSonicFs = artifact instanceof SonicFSArtifact;
        boolean isZipContent = artifact instanceof ZipContentArtifact;
        if (!isSonicFs || isZipContent) {
            return artifact;
        }
        IArtifact updatedArtifact = artifact;
        String artifactPath = artifact.getPath();
        String oldUrlPath = this.pathFormToURLForm(artifact.getPath().toLowerCase());
        UrlPathUpdate pathUpdate = this.m_urlPathUpdates.get(oldUrlPath);
        if (pathUpdate != null) {
            String newPath = this.urlFormToPathForm(pathUpdate.newUrlPath);
            updatedArtifact = ArtifactFactory.createArtifact(artifact, newPath);
            this.m_logFile.logUpdate(artifact.getDisplayType(), artifact.getName(), "Path Update", artifactPath, newPath);
        } else if (this.m_stringReplacements != null && artifact.getPath() != null) {
            for (int i = 0; i < this.m_stringReplacements.length; ++i) {
                String oldPath = this.m_stringReplacements[i].oldValue;
                String newPath = this.m_stringReplacements[i].newValue;
                if (oldPath.toLowerCase().indexOf(SonicFSURL) != 0 || newPath.toLowerCase().indexOf(SonicFSURL) != 0) continue;
                oldPath = this.urlFormToPathForm(this.m_stringReplacements[i].oldValue);
                newPath = this.urlFormToPathForm(this.m_stringReplacements[i].newValue);
                int searchLength = oldPath.length();
                if (artifactPath.length() < searchLength || !oldPath.equalsIgnoreCase(artifactPath.substring(0, searchLength))) continue;
                newPath = newPath + artifactPath.substring(searchLength);
                updatedArtifact = ArtifactFactory.createArtifact(artifact, newPath);
                this.m_logFile.logUpdate(artifact.getDisplayType(), artifact.getName(), "Path Update", this.m_stringReplacements[i].oldValue, this.m_stringReplacements[i].newValue);
                break;
            }
        }
        return updatedArtifact;
    }

    private String pathFormToURLForm(String pathForm) {
        if (pathForm == null) {
            return null;
        }
        if (pathForm.toLowerCase().startsWith(SonicFSURL)) {
            return pathForm;
        }
        String urlForm = pathForm.startsWith("/") ? "sonicfs://" + pathForm : SonicFSURL + pathForm;
        return urlForm;
    }

    private String urlFormToPathForm(String urlForm) {
        if (urlForm == null) {
            return null;
        }
        String pathForm = urlForm;
        if (urlForm.toLowerCase().indexOf(SonicFSURL) >= 0) {
            pathForm = "/" + urlForm.substring(SonicFSURL.length());
        }
        return pathForm;
    }

    private void initLogger() {
        int i;
        if (this.m_mapProcesses != null) {
            for (i = 0; i < this.m_mapProcesses.length; ++i) {
                this.m_logFile.addMapEntry(this.processId, this.m_mapProcesses[i].getName());
            }
        }
        if (this.m_mapServices != null) {
            for (i = 0; i < this.m_mapServices.length; ++i) {
                this.m_logFile.addMapEntry(this.serviceId, this.m_mapServices[i].getName());
            }
        }
        if (this.m_mapEndpoints != null) {
            for (i = 0; i < this.m_mapEndpoints.length; ++i) {
                this.m_logFile.addMapEntry(this.endpointId, this.m_mapEndpoints[i].getName());
            }
        }
        if (this.m_mapConnections != null) {
            for (i = 0; i < this.m_mapConnections.length; ++i) {
                this.m_logFile.addMapEntry(this.connectionId, this.m_mapConnections[i].getName());
            }
        }
    }

    private String processProcessDoc(String data) throws XmlException, Exception {
        ProcessDocument processDoc = ProcessDocument.Factory.parse(data);
        ProcessMapType mapProcess = this.findProcessMapItem(processDoc.getProcess().getName());
        if (mapProcess != null) {
            String warning;
            ItineraryStepMapType[] mapSteps;
            EndpointRefType ep;
            String warning2;
            if (mapProcess.isSetEntryRef()) {
                if (processDoc.getProcess().getEntryRef() != null) {
                    this.m_logFile.logUpdate(this.processId, processDoc.getProcess().getName(), "Entry Endpoint Reference", processDoc.getProcess().getEntryRef(), mapProcess.getEntryRef());
                    processDoc.getProcess().setEntryRef(mapProcess.getEntryRef());
                } else {
                    warning2 = "Entry endpoint set in map but not set in Process";
                    this.addWarning(mapProcess.getName(), this.processId, warning2);
                }
            }
            if (mapProcess.isSetFaultEndpoint()) {
                if (processDoc.getProcess().getFaultEndpoint() != null) {
                    this.m_logFile.logUpdate(this.processId, processDoc.getProcess().getName(), "Fault Endpoint Reference", processDoc.getProcess().getFaultEndpoint().getEndpointRef(), mapProcess.getFaultEndpoint().getEndpointRef());
                    ep = this.convertToEndpointRef(mapProcess.getFaultEndpoint());
                    processDoc.getProcess().setFaultEndpoint(ep);
                } else {
                    warning2 = "Fault endpoint set in map but not set in Process";
                    this.addWarning(mapProcess.getName(), this.processId, warning2);
                }
            }
            if (mapProcess.isSetRejectEndpoint()) {
                if (processDoc.getProcess().getRejectEndpoint() != null) {
                    this.m_logFile.logUpdate(this.processId, processDoc.getProcess().getName(), "Reject Endpoint Reference", processDoc.getProcess().getRejectEndpoint().getEndpointRef(), mapProcess.getRejectEndpoint().getEndpointRef());
                    ep = this.convertToEndpointRef(mapProcess.getRejectEndpoint());
                    processDoc.getProcess().setRejectEndpoint(ep);
                } else {
                    warning2 = "Reject endpoint set in map but not set in Process";
                    this.addWarning(mapProcess.getName(), this.processId, warning2);
                }
            }
            if (mapProcess.isSetTrackingDetailsEndpoint()) {
                if (processDoc.getProcess().getTrackingDetails() != null) {
                    if (processDoc.getProcess().getTrackingDetails().getEventEndpoint() != null) {
                        this.m_logFile.logUpdate(this.processId, processDoc.getProcess().getName(), "Tracking Level Endpoint Reference", processDoc.getProcess().getTrackingDetails().getEventEndpoint().getEndpointRef(), mapProcess.getTrackingDetailsEndpoint().getEndpointRef());
                        ep = this.convertToEndpointRef(mapProcess.getTrackingDetailsEndpoint());
                        processDoc.getProcess().getTrackingDetails().setEventEndpoint(ep);
                    } else {
                        warning2 = "Tracking level event endpoint set in map but not set in Process";
                        this.addWarning(mapProcess.getName(), this.processId, warning2);
                    }
                } else {
                    warning2 = "Tracking level event endpoint set in map but tracking level is not set in Process";
                    this.addWarning(mapProcess.getName(), this.processId, warning2);
                }
            }
            if (mapProcess.isSetExitEndpoints()) {
                ProcessDocument.Process.ExitEndpointList endpointList = processDoc.getProcess().getExitEndpointList();
                if (endpointList != null) {
                    ExitEndpointsMapType endpointMaps = mapProcess.getExitEndpoints();
                    EndpointRefType[] exitEndpointArray = endpointList.getExitEndpointArray();
                    EndpointRefType[] adjustedExitEndpoints = this.handleExitEndpoints(this.processId, processDoc.getProcess().getName(), exitEndpointArray, endpointMaps);
                    if (adjustedExitEndpoints != null) {
                        processDoc.getProcess().getExitEndpointList().setExitEndpointArray(adjustedExitEndpoints);
                    }
                } else {
                    String warning3 = "Exit endpoint set in map but not set in Process";
                    this.addWarning(mapProcess.getName(), this.processId, warning3);
                }
            }
            ItineraryStepsMapType mapStepsList = mapProcess.getSteps();
            ItineraryType itinerary = processDoc.getProcess().getItinerary();
            if (mapStepsList != null && itinerary != null && (mapSteps = mapStepsList.getStepsArray()) != null) {
                this.processItinerarySteps(itinerary, mapSteps, processDoc.getProcess().getName());
            }
            if (mapProcess.isSetQoS()) {
                this.m_logFile.logUpdate(this.processId, processDoc.getProcess().getName(), "QoS", processDoc.getProcess().getQualityOfService().toString(), mapProcess.getQoS().toString());
                processDoc.getProcess().setQualityOfService(mapProcess.getQoS());
            }
            if (mapProcess.isSetTimeToLive()) {
                this.m_logFile.logUpdate(this.processId, processDoc.getProcess().getName(), "TTL", processDoc.getProcess().getTimeToLive().toString(), mapProcess.getTimeToLive().toString());
                processDoc.getProcess().setTimeToLive(mapProcess.getTimeToLive());
            }
            if (mapProcess.isSetTrackingLevel()) {
                if (processDoc.getProcess().getTrackingDetails() != null) {
                    this.m_logFile.logUpdate(this.processId, processDoc.getProcess().getName(), "Tracking Level", new Integer(processDoc.getProcess().getTrackingDetails().getTrackingLevel()).toString(), new Integer(mapProcess.getTrackingLevel()).toString());
                    processDoc.getProcess().getTrackingDetails().setTrackingLevel(mapProcess.getTrackingLevel());
                } else {
                    warning = "Tracking level set in map but not in Process";
                    this.addWarning(mapProcess.getName(), this.processId, warning);
                }
            }
            if (mapProcess.isSetOnRampReference()) {
                if (processDoc.getProcess().getOnRampReference() != null) {
                    this.m_logFile.logUpdate(this.processId, processDoc.getProcess().getName(), "On Ramp Reference", processDoc.getProcess().getOnRampReference(), mapProcess.getOnRampReference());
                    processDoc.getProcess().setOnRampReference(mapProcess.getOnRampReference());
                } else {
                    warning = "On Ramp Reference set in map but not set in Process";
                    this.addWarning(mapProcess.getName(), this.processId, warning);
                }
            }
        }
        return processDoc.toString();
    }

    private void processItinerarySteps(ItineraryType itinerary, ItineraryStepMapType[] mapSteps, String processName) throws XmlException, Exception {
        FanoutType[] fanouts;
        DecisionType[] decisions;
        StepType[] steps = itinerary.getStepArray();
        if (steps != null) {
            for (int i = 0; i < steps.length; ++i) {
                EndpointRefMapType mapEndPoint = this.getMapStepEndpoint(mapSteps, steps[i]);
                if (mapEndPoint == null) continue;
                String logDescription = "Itinerary Endpoint Reference";
                if (steps[i].getName() != null) {
                    logDescription = logDescription + ", Step: " + steps[i].getName();
                }
                this.m_logFile.logUpdate(this.processId, processName, logDescription, steps[i].getEndpointRef(), mapEndPoint.getEndpointRef());
                EndpointRefType ep = this.convertToEndpointRef(mapEndPoint);
                steps[i].setEndpointRef(ep.getEndpointRef());
                steps[i].setType(ep.getType());
            }
        }
        if ((decisions = itinerary.getDecisionArray()) != null) {
            for (int i = 0; i < decisions.length; ++i) {
                DecisionType.Option[] options = decisions[i].getOptionArray();
                if (options == null) continue;
                for (int j = 0; j < options.length; ++j) {
                    this.processItinerarySteps(options[j], mapSteps, processName);
                }
            }
        }
        if ((fanouts = itinerary.getFanoutArray()) != null) {
            for (int i = 0; i < fanouts.length; ++i) {
                FanoutType.Path[] paths = fanouts[i].getPathArray();
                if (paths == null) continue;
                for (int j = 0; j < paths.length; ++j) {
                    this.processItinerarySteps(paths[j], mapSteps, processName);
                }
            }
        }
    }

    private EndpointRefType convertToEndpointRef(EndpointRefMapType mapEndpointRef) throws Exception {
        EndpointRefType endpointRef = EndpointRefType.Factory.newInstance();
        endpointRef.setEndpointRef(mapEndpointRef.getEndpointRef());
        if (mapEndpointRef.isSetType()) {
            EndpointRefTypeEnumeration.Enum type = this.endpointMapToEnum(mapEndpointRef.getType());
            endpointRef.setType(type);
        }
        return endpointRef;
    }

    private EndpointRefTypeEnumeration.Enum endpointMapToEnum(String mapType) throws Exception {
        if (mapType.equalsIgnoreCase(EndpointRefTypeEnumeration.PROCESS.toString())) {
            return EndpointRefTypeEnumeration.PROCESS;
        }
        if (mapType.equalsIgnoreCase(EndpointRefTypeEnumeration.SERVICE.toString())) {
            return EndpointRefTypeEnumeration.SERVICE;
        }
        if (mapType.equalsIgnoreCase(EndpointRefTypeEnumeration.ENDPOINT.toString())) {
            return EndpointRefTypeEnumeration.ENDPOINT;
        }
        if (mapType.equalsIgnoreCase(EndpointRefTypeEnumeration.REPLY_TO.toString())) {
            return EndpointRefTypeEnumeration.REPLY_TO;
        }
        if (mapType.equalsIgnoreCase(EndpointRefTypeEnumeration.EXPRESSION.toString())) {
            return EndpointRefTypeEnumeration.EXPRESSION;
        }
        throw new Exception("Invalid endpoint type found: " + mapType);
    }

    private EndpointRefType[] handleExitEndpoints(String artifactType, String artifactName, EndpointRefType[] exitEndpointArray, ExitEndpointsMapType endpointMaps) throws Exception {
        boolean changed = false;
        ExitEndpointMapType[] endpointMapArray = endpointMaps.getExitEndpointMapArray();
        for (int i = 0; i < exitEndpointArray.length; ++i) {
            EndpointRefMapType updated = this.findExitEndpointMatch(exitEndpointArray[i], endpointMapArray);
            if (updated == null) continue;
            this.m_logFile.logUpdate(artifactType, artifactName, "Exit Endpoint Reference", exitEndpointArray[i].getEndpointRef(), updated.getEndpointRef());
            exitEndpointArray[i].setEndpointRef(updated.getEndpointRef());
            exitEndpointArray[i].setType(this.endpointMapToEnum(updated.getType()));
            changed = true;
        }
        if (changed) {
            return exitEndpointArray;
        }
        return null;
    }

    private EndpointRefMapType findExitEndpointMatch(EndpointRefType endpoint, ExitEndpointMapType[] endpointMapArray) {
        String endpointRefTypeEnum = null;
        if (endpoint.isSetType()) {
            endpointRefTypeEnum = endpoint.getType().toString();
        }
        for (int i = 0; i < endpointMapArray.length; ++i) {
            EndpointRefMapType key = endpointMapArray[i].getOriginalValue();
            EndpointRefMapType value = endpointMapArray[i].getValue();
            if (this.isEndpointRefEqual(key.getEndpointRef(), key.getType(), value.getEndpointRef(), value.getType()) || !this.isEndpointRefEqual(key.getEndpointRef(), key.getType(), endpoint.getEndpointRef(), endpointRefTypeEnum)) continue;
            return endpointMapArray[i].getValue();
        }
        return null;
    }

    private boolean isEndpointRefEqual(String ref1, String type1, String ref2, String type2) {
        if (!ref1.equalsIgnoreCase(ref2)) {
            return false;
        }
        if (type1 == null && type2 == null) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        return type1.equalsIgnoreCase(type2);
    }

    private EndpointRefMapType getMapStepEndpoint(ItineraryStepMapType[] mapSteps, StepType step) {
        for (int i = 0; i < mapSteps.length; ++i) {
            if (!step.isSetName() || !mapSteps[i].getStep().equalsIgnoreCase(step.getName())) continue;
            return mapSteps[i].getStepEndpoint();
        }
        return null;
    }

    private ProcessMapType findProcessMapItem(String name) throws Exception {
        if (this.m_mapProcesses != null) {
            for (int i = 0; i < this.m_mapProcesses.length; ++i) {
                if (!this.m_mapProcesses[i].getName().equals(name)) continue;
                this.m_logFile.foundXarArtifact(this.processId, name);
                return this.m_mapProcesses[i];
            }
        }
        this.m_logFile.missingFromMap(this.processId, name);
        return null;
    }

    private String processServiceDoc(String data) throws XmlException, Exception {
        ServiceDocument serviceDoc = ServiceDocument.Factory.parse(data);
        if (MapCreator.ignoreInstance(MapCreator.serviceIgnoreList, serviceDoc.getService().getTypeRef())) {
            return null;
        }
        ServiceMapType mapService = this.findServiceMapItem(serviceDoc.getService().getName());
        if (mapService != null) {
            ParamsMapType mapParams;
            EndpointRefType ep;
            String warning;
            if (mapService.isSetEntryRef()) {
                if (serviceDoc.getService().getEntryRef() != null) {
                    this.m_logFile.logUpdate(this.serviceId, serviceDoc.getService().getName(), "Entry Endpoint Reference", serviceDoc.getService().getEntryRef(), mapService.getEntryRef());
                    serviceDoc.getService().setEntryRef(mapService.getEntryRef());
                } else {
                    warning = "Entry endpoint set in map but not set in Service";
                    this.addWarning(mapService.getName(), this.serviceId, warning);
                }
            }
            if (mapService.isSetFaultEndpoint()) {
                if (serviceDoc.getService().getFaultEndpoint() != null) {
                    this.m_logFile.logUpdate(this.serviceId, serviceDoc.getService().getName(), "Fault Endpoint Reference", serviceDoc.getService().getFaultEndpoint().getEndpointRef(), mapService.getFaultEndpoint().getEndpointRef());
                    ep = this.convertToEndpointRef(mapService.getFaultEndpoint());
                    serviceDoc.getService().setFaultEndpoint(ep);
                } else {
                    warning = "Fault endpoint set in map but not set in Service";
                    this.addWarning(mapService.getName(), this.serviceId, warning);
                }
            }
            if (mapService.isSetRejectEndpoint()) {
                if (serviceDoc.getService().getRejectEndpoint() != null) {
                    this.m_logFile.logUpdate(this.serviceId, serviceDoc.getService().getName(), "Reject Endpoint Reference", serviceDoc.getService().getRejectEndpoint().getEndpointRef(), mapService.getRejectEndpoint().getEndpointRef());
                    ep = this.convertToEndpointRef(mapService.getRejectEndpoint());
                    serviceDoc.getService().setRejectEndpoint(ep);
                } else {
                    warning = "Reject endpoint set in map but not set in Service";
                    this.addWarning(mapService.getName(), this.serviceId, warning);
                }
            }
            if (mapService.isSetExitEndpoints()) {
                ServiceDocument.Service.ExitEndpointList endpointList = serviceDoc.getService().getExitEndpointList();
                if (endpointList != null) {
                    ExitEndpointsMapType endpointMaps = mapService.getExitEndpoints();
                    EndpointRefType[] exitEndpointArray = endpointList.getExitEndpointArray();
                    EndpointRefType[] adjustedExitEndpoints = this.handleExitEndpoints(this.serviceId, serviceDoc.getService().getName(), exitEndpointArray, endpointMaps);
                    if (adjustedExitEndpoints != null) {
                        serviceDoc.getService().getExitEndpointList().setExitEndpointArray(adjustedExitEndpoints);
                    }
                } else {
                    String warning2 = "Exit endpoint set in map but not set in Service";
                    this.addWarning(mapService.getName(), this.serviceId, warning2);
                }
            }
            if ((mapParams = mapService.getParamMap()) != null) {
                this.processParams(this.serviceId, mapService.getName(), mapParams, serviceDoc.getService().getParams());
            }
        }
        if (serviceDoc.getService().isSetClassLoading()) {
            this.doClassPathReplacements(serviceDoc.getService().getName(), serviceDoc.getService().getClassLoading());
            this.normalizeClassLoading(serviceDoc.getService());
        }
        return serviceDoc.toString();
    }

    private void normalizeClassLoading(ServiceDocument.Service service) {
        ClassLoading root = service.getClassLoading();
        if (root.isSetServiceInstance() && root.getServiceInstance().getClasspathList().sizeOfClasspathArray() == 0) {
            root.unsetServiceInstance();
        }
        if (root.isSetServiceType() && root.getServiceType().getClasspathList().sizeOfClasspathArray() == 0) {
            root.unsetServiceType();
        }
        if (root.isSetXqContainer() && root.getXqContainer().getClasspathList().sizeOfClasspathArray() == 0) {
            root.unsetXqContainer();
        }
        if (!(root.isSetServiceInstance() || root.isSetServiceType() || root.isSetXqContainer())) {
            service.unsetClassLoading();
        }
    }

    private ServiceMapType findServiceMapItem(String name) throws Exception {
        if (this.m_mapServices != null) {
            for (int i = 0; i < this.m_mapServices.length; ++i) {
                if (!this.m_mapServices[i].getName().equals(name)) continue;
                this.m_logFile.foundXarArtifact(this.serviceId, name);
                return this.m_mapServices[i];
            }
        }
        this.m_logFile.missingFromMap(this.serviceId, name);
        return null;
    }

    private String processEndpointDoc(String data) throws XmlException, Exception {
        EndpointDocument endpointDoc = EndpointDocument.Factory.parse(data);
        EndpointSchemaType endpoint = endpointDoc.getEndpoint();
        EndpointMapType mapEndpoint = this.findEndpointMapItem(endpointDoc.getEndpoint().getName());
        if (mapEndpoint != null) {
            ParamsMapType mapParams;
            if (mapEndpoint.isSetQoS()) {
                this.m_logFile.logUpdate(this.endpointId, endpointDoc.getEndpoint().getName(), "QoS", endpointDoc.getEndpoint().getQualityOfService().toString(), mapEndpoint.getQoS().toString());
                endpoint.setQualityOfService(mapEndpoint.getQoS());
            }
            if ((mapParams = mapEndpoint.getParamMap()) != null) {
                this.processParams(this.endpointId, mapEndpoint.getName(), mapParams, endpointDoc.getEndpoint().getParams());
            }
        }
        return endpointDoc.toString();
    }

    private EndpointMapType findEndpointMapItem(String name) throws Exception {
        if (this.m_mapEndpoints != null) {
            for (int i = 0; i < this.m_mapEndpoints.length; ++i) {
                if (!this.m_mapEndpoints[i].getName().equals(name)) continue;
                this.m_logFile.foundXarArtifact(this.endpointId, name);
                return this.m_mapEndpoints[i];
            }
        }
        this.m_logFile.missingFromMap(this.endpointId, name);
        return null;
    }

    private String processConnectionDoc(String data) throws XmlException, Exception {
        ParamsMapType mapParams;
        ConnectionDocument connectionDoc = ConnectionDocument.Factory.parse(data);
        ConnectionMapType mapConnection = this.findConnectionMapItem(connectionDoc.getConnection().getName());
        if (mapConnection != null && (mapParams = mapConnection.getParamMap()) != null) {
            this.processParams(this.connectionId, mapConnection.getName(), mapParams, connectionDoc.getConnection().getParams());
        }
        return connectionDoc.toString();
    }

    private ConnectionMapType findConnectionMapItem(String name) throws Exception {
        if (this.m_mapConnections != null) {
            for (int i = 0; i < this.m_mapConnections.length; ++i) {
                if (!this.m_mapConnections[i].getName().equals(name)) continue;
                this.m_logFile.foundXarArtifact(this.connectionId, name);
                return this.m_mapConnections[i];
            }
        }
        this.m_logFile.missingFromMap(this.connectionId, name);
        return null;
    }

    private void processParams(String objectType, String objectName, ParamsMapType source, ParamsType target) {
        if (source == null || target == null) {
            return;
        }
        ParamsMapType.StringParam[] sourceStringParams = source.getStringParamArray();
        ParamsType.StringParam[] targetStringParams = target.getStringParamArray();
        this.processStringParams(objectType, objectName, sourceStringParams, targetStringParams);
        ParamsType.StringParam[] updatedStringParams = this.processAdditionalStringParams(objectType, objectName, sourceStringParams, targetStringParams);
        if (updatedStringParams != null) {
            target.setStringParamArray(updatedStringParams);
        }
        ParamsMapType.XmlParam[] sourceXmlParams = source.getXmlParamArray();
        ParamsType.XmlParam[] targetXmlParams = target.getXmlParamArray();
        this.processXmlParams(objectType, objectName, sourceXmlParams, targetXmlParams);
        ParamsType.XmlParam[] updatedXmlParams = this.processAdditionalXmlParams(objectType, objectName, sourceXmlParams, targetXmlParams);
        if (updatedXmlParams != null) {
            target.setXmlParamArray(updatedXmlParams);
        }
    }

    private void processStringParams(String objectType, String objectName, ParamsMapType.StringParam[] sourceStringParams, ParamsType.StringParam[] targetStringParams) {
        if (sourceStringParams == null || targetStringParams == null) {
            return;
        }
        block0: for (int i = 0; i < targetStringParams.length; ++i) {
            for (int j = 0; j < sourceStringParams.length; ++j) {
                if (!targetStringParams[i].getName().equals(sourceStringParams[j].getName())) continue;
                if (sourceStringParams[j].getStringValue() != null) {
                    this.m_logFile.logUpdate(objectType, objectName, targetStringParams[i].getName(), targetStringParams[i].getStringValue(), sourceStringParams[j].getStringValue());
                    targetStringParams[i].setStringValue(sourceStringParams[j].getStringValue());
                }
                if (!sourceStringParams[j].isSetUrl()) continue block0;
                this.m_logFile.logUpdate(objectType, objectName, targetStringParams[i].getName(), targetStringParams[i].getUrl(), sourceStringParams[j].getUrl());
                targetStringParams[i].setUrl(sourceStringParams[j].getUrl());
                continue block0;
            }
        }
    }

    private ParamsType.StringParam[] processAdditionalStringParams(String objectType, String objectName, ParamsMapType.StringParam[] sourceStringParams, ParamsType.StringParam[] targetStringParams) {
        ParamsType.StringParam[] newStringArray = null;
        if (sourceStringParams == null || targetStringParams == null) {
            return null;
        }
        Vector<ParamsMapType.StringParam> additionalStringParams = new Vector<ParamsMapType.StringParam>();
        for (int i = 0; i < sourceStringParams.length; ++i) {
            String value;
            boolean found = false;
            String lookingFor = sourceStringParams[i].getName();
            for (int j = 0; j < targetStringParams.length; ++j) {
                if (!lookingFor.equals(targetStringParams[j].getName())) continue;
                found = true;
                break;
            }
            if (found || ((value = sourceStringParams[i].getStringValue()) == null || value.length() <= 0) && !sourceStringParams[i].isSetUrl()) continue;
            additionalStringParams.add(sourceStringParams[i]);
        }
        if (additionalStringParams.size() > 0) {
            int i;
            int newSize = targetStringParams.length + additionalStringParams.size();
            newStringArray = new ParamsType.StringParam[newSize];
            for (i = 0; i < targetStringParams.length; ++i) {
                newStringArray[i] = targetStringParams[i];
            }
            for (i = 0; i < additionalStringParams.size(); ++i) {
                ParamsMapType.StringParam mapParam = (ParamsMapType.StringParam)additionalStringParams.elementAt(i);
                ParamsType.StringParam newParam = ParamsType.StringParam.Factory.newInstance();
                newParam.setName(mapParam.getName());
                String value = mapParam.getStringValue();
                if (value != null) {
                    newParam.setStringValue(value);
                    this.m_logFile.logAdditional(objectType, objectName, mapParam.getName(), value);
                }
                if (mapParam.isSetUrl()) {
                    newParam.setUrl(mapParam.getUrl());
                    this.m_logFile.logAdditional(objectType, objectName, mapParam.getName(), mapParam.getUrl());
                }
                int arrayPos = targetStringParams.length + i;
                newStringArray[arrayPos] = newParam;
            }
        }
        return newStringArray;
    }

    private void processXmlParams(String objectType, String objectName, ParamsMapType.XmlParam[] sourceXmlParams, ParamsType.XmlParam[] targetXmlParams) {
        if (sourceXmlParams == null || targetXmlParams == null) {
            return;
        }
        block0: for (int i = 0; i < targetXmlParams.length; ++i) {
            for (int j = 0; j < sourceXmlParams.length; ++j) {
                if (!targetXmlParams[i].getName().equals(sourceXmlParams[j].getName())) continue;
                if (sourceXmlParams[j].isSetUrl()) {
                    this.m_logFile.logUpdate(objectType, objectName, targetXmlParams[i].getName(), targetXmlParams[i].getUrl(), sourceXmlParams[j].getUrl());
                    targetXmlParams[i].setUrl(sourceXmlParams[j].getUrl());
                    continue block0;
                }
                XmlCursor sourceParamCursor = sourceXmlParams[j].newCursor();
                XmlCursor targetParamCursor = targetXmlParams[i].newCursor();
                List<String> sourceAttrVec = this.getAttrVector(sourceParamCursor);
                List<String> targetAttrVec = this.getAttrVector(targetParamCursor);
                boolean isXmlIdentical = true;
                if (sourceAttrVec.size() == targetAttrVec.size()) {
                    for (int k = 0; k < sourceAttrVec.size(); ++k) {
                        String targetAttr;
                        String sourceAttr = (String)((Vector)sourceAttrVec).elementAt(k);
                        if (sourceAttr.equals(targetAttr = (String)((Vector)targetAttrVec).elementAt(k))) continue;
                        isXmlIdentical = false;
                        break;
                    }
                } else {
                    isXmlIdentical = false;
                }
                if (isXmlIdentical) continue block0;
                sourceParamCursor = sourceXmlParams[j].newCursor();
                sourceParamCursor.toFirstChild();
                targetParamCursor = targetXmlParams[i].newCursor();
                targetParamCursor.toFirstChild();
                this.m_logFile.logUpdate(objectType, objectName, targetXmlParams[i].getName(), targetXmlParams[i], sourceXmlParams[j]);
                targetParamCursor.removeXml();
                sourceParamCursor.copyXml(targetParamCursor);
                continue block0;
            }
        }
    }

    private List<String> getAttrVector(XmlCursor cursor) {
        XmlCursor.TokenType tokenType;
        int starts = 0;
        int ends = 0;
        Vector<String> attrVec = new Vector<String>();
        do {
            String val;
            if ((tokenType = cursor.currentTokenType()) == XmlCursor.TokenType.START) {
                ++starts;
            }
            if (tokenType == XmlCursor.TokenType.END) {
                ++ends;
            }
            if (starts > 0 && starts == ends) {
                return attrVec;
            }
            if (tokenType != XmlCursor.TokenType.ATTR || (val = cursor.getTextValue()) == null) continue;
            attrVec.add(val);
        } while ((tokenType = cursor.toNextToken()) != XmlCursor.TokenType.ENDDOC);
        return attrVec;
    }

    private ParamsType.XmlParam[] processAdditionalXmlParams(String objectType, String objectName, ParamsMapType.XmlParam[] sourceXmlParams, ParamsType.XmlParam[] targetXmlParams) {
        ParamsType.XmlParam[] newXmlArray = null;
        if (sourceXmlParams == null || targetXmlParams == null) {
            return null;
        }
        Vector<ParamsMapType.XmlParam> additionalXmlParams = new Vector<ParamsMapType.XmlParam>();
        for (int i = 0; i < sourceXmlParams.length; ++i) {
            boolean found = false;
            for (int j = 0; j < targetXmlParams.length; ++j) {
                if (!sourceXmlParams[i].getName().equals(targetXmlParams[j].getName())) continue;
                found = true;
                break;
            }
            if (found || (sourceXmlParams[i].newCursor() == null || !sourceXmlParams[i].newCursor().toFirstChild()) && sourceXmlParams[i].getUrl() == null) continue;
            additionalXmlParams.add(sourceXmlParams[i]);
        }
        if (additionalXmlParams.size() > 0) {
            int i;
            int newSize = targetXmlParams.length + additionalXmlParams.size();
            newXmlArray = new ParamsType.XmlParam[newSize];
            for (i = 0; i < targetXmlParams.length; ++i) {
                newXmlArray[i] = targetXmlParams[i];
            }
            for (i = 0; i < additionalXmlParams.size(); ++i) {
                XmlCursor sourceParamCursor;
                ParamsMapType.XmlParam mapParam = (ParamsMapType.XmlParam)additionalXmlParams.elementAt(i);
                ParamsType.XmlParam newParam = ParamsType.XmlParam.Factory.newInstance();
                String url = mapParam.getUrl();
                if (url != null) {
                    newParam.setUrl(url);
                    this.m_logFile.logAdditional(objectType, objectName, mapParam.getName(), url);
                }
                if ((sourceParamCursor = mapParam.newCursor()).toFirstChild()) {
                    XmlCursor targetParamCursor = newParam.newCursor();
                    targetParamCursor.toFirstContentToken();
                    sourceParamCursor.copyXml(targetParamCursor);
                    this.m_logFile.logAdditional(objectType, objectName, mapParam.getName(), mapParam);
                }
                newParam.setName(mapParam.getName());
                int arrayPos = targetXmlParams.length + i;
                newXmlArray[arrayPos] = newParam;
            }
        }
        return newXmlArray;
    }

    public void validateMapFile() throws Exception {
        int j;
        int i;
        if (this.m_map == null) {
            String errorMessage = new String("Validation detected an empty map file");
            throw new Exception(errorMessage);
        }
        if (this.m_mapProcesses != null) {
            for (i = 0; i < this.m_mapProcesses.length; ++i) {
                for (j = 0; j < this.m_mapProcesses.length; ++j) {
                    if (i == j || !this.m_mapProcesses[i].getName().equals(this.m_mapProcesses[j].getName())) continue;
                    String errorMessage = new String("Duplicate process found in map file: ");
                    errorMessage = errorMessage + this.m_mapProcesses[i].getName();
                    throw new Exception(errorMessage);
                }
            }
        }
        if (this.m_mapServices != null) {
            for (i = 0; i < this.m_mapServices.length; ++i) {
                for (j = 0; j < this.m_mapServices.length; ++j) {
                    if (i == j || !this.m_mapServices[i].getName().equals(this.m_mapServices[j].getName())) continue;
                    String errorMessage = new String("Duplicate service found in map file: ");
                    errorMessage = errorMessage + this.m_mapServices[i].getName();
                    throw new Exception(errorMessage);
                }
            }
        }
        if (this.m_mapEndpoints != null) {
            for (i = 0; i < this.m_mapEndpoints.length; ++i) {
                for (j = 0; j < this.m_mapEndpoints.length; ++j) {
                    if (i == j || !this.m_mapEndpoints[i].getName().equals(this.m_mapEndpoints[j].getName())) continue;
                    String errorMessage = new String("Duplicate endpoint found in map file: ");
                    errorMessage = errorMessage + this.m_mapEndpoints[i].getName();
                    throw new Exception(errorMessage);
                }
            }
        }
        if (this.m_mapConnections != null) {
            for (i = 0; i < this.m_mapConnections.length; ++i) {
                for (j = 0; j < this.m_mapConnections.length; ++j) {
                    if (i == j || !this.m_mapConnections[i].getName().equals(this.m_mapConnections[j].getName())) continue;
                    String errorMessage = new String("Duplicate connection found in map file: ");
                    errorMessage = errorMessage + this.m_mapConnections[i].getName();
                    throw new Exception(errorMessage);
                }
            }
        }
    }

    private void addWarning(String name, String type, String warning) {
        ArtifactWarningType artifactWarning = ArtifactWarningType.Factory.newInstance();
        artifactWarning.setName(name);
        artifactWarning.setType(type);
        artifactWarning.setWarning(warning);
        this.m_warnings.add(artifactWarning);
    }

    private int getPropKeyIndex(String data, String propName) {
        boolean isValuePropKey = false;
        int index = data.indexOf(propName);
        while (index != -1 && !isValuePropKey) {
            if (index == 0) {
                isValuePropKey = true;
                break;
            }
            int backslashCount = 0;
            boolean foundLineBreak = false;
            for (int i = index - 1; i >= 0; --i) {
                if (data.charAt(i) == '\r' || data.charAt(i) == '\n') {
                    foundLineBreak = true;
                    continue;
                }
                if (Character.isWhitespace(data.charAt(i))) continue;
                if (!foundLineBreak || data.charAt(i) != '\\') break;
                ++backslashCount;
            }
            if (foundLineBreak && backslashCount % 2 == 0) {
                isValuePropKey = true;
            }
            if (isValuePropKey) continue;
            String newDataSegment = data.substring(index += propName.length());
            int newIdx = newDataSegment.indexOf(propName);
            index += newIdx;
        }
        return index;
    }

    private String getPropValue(String data, int oldValueIdx) {
        String temp = data.substring(oldValueIdx).replaceAll("(?s)([^\\n\\r]*[\\n\\r]+)(.*$)", "$1");
        boolean isOldValueCorrect = false;
        int tempIdx = oldValueIdx;
        String nextSegment = null;
        while (!isOldValueCorrect) {
            if (this.endsWithEscapedLineBreak(temp)) {
                tempIdx = nextSegment == null ? (tempIdx += temp.length()) : (tempIdx += nextSegment.length());
                nextSegment = data.substring(tempIdx).replaceAll("(?s)([\\n\\r]*[\\n\\r]+)(.*)$", "$1");
                temp = temp + nextSegment;
                isOldValueCorrect = false;
                continue;
            }
            isOldValueCorrect = true;
            isOldValueCorrect = true;
        }
        return temp.trim();
    }

    private boolean endsWithEscapedLineBreak(String temp) {
        boolean lineBreak = false;
        int backslashCount = 0;
        for (int i = temp.length() - 1; i >= 0; --i) {
            if (temp.charAt(i) == '\r' || temp.charAt(i) == '\n') {
                lineBreak = true;
                continue;
            }
            if (Character.isWhitespace(temp.charAt(i))) continue;
            if (!lineBreak || temp.charAt(i) != '\\') break;
            ++backslashCount;
        }
        return backslashCount % 2 > 0;
    }

    private class PropertyReplacementInfo
    implements Comparable<PropertyReplacementInfo> {
        private final String propName;
        private final String oldValue;
        private final String newValue;
        private final int propNameIdx;
        private final int oldValueIdx;

        private PropertyReplacementInfo(String propName, int propNameIdx, String oldValue, int oldValueIdx, String newValue) {
            this.propNameIdx = propNameIdx;
            this.oldValueIdx = oldValueIdx;
            this.propName = propName;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public int compareTo(PropertyReplacementInfo that) {
            return this.propNameIdx - that.propNameIdx;
        }
    }

    public class PropertyReplacement {
        public String propertyName;
        public String newValue;
    }

    public class UrlPathUpdate {
        private final String artifact;
        private final String propName;
        private final String oldUrlPath;
        private final String newUrlPath;

        UrlPathUpdate(String artifact, String propName, String oldUrlPath, String newUrlPath) {
            this.artifact = artifact;
            this.propName = propName;
            this.oldUrlPath = oldUrlPath;
            this.newUrlPath = newUrlPath;
        }
    }

    public class StringReplacements {
        public String artifactName;
        public String oldValue;
        public String newValue;
        public int orderValue;
    }
}

