/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.admin;

import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerIdentity;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IState;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mf.mgmtapi.config.IContainerBean;
import com.sonicsw.mf.mgmtapi.config.MFMgmtBeanFactory;
import com.sonicsw.mf.mgmtapi.runtime.IAgentManagerProxy;
import com.sonicsw.mf.mgmtapi.runtime.IAgentProxy;
import com.sonicsw.mf.mgmtapi.runtime.MFProxyFactory;
import com.sonicsw.mf.mgmtapi.runtime.ProxyRuntimeException;
import com.sonicsw.xqimpl.tools.common.Utils;
import java.util.Hashtable;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class MFContainerUtility {
    private static final String AGENT_MANAGER = "AGENT MANAGER";
    private static final String AGENT = "AGENT";
    private static final String DIRECTORY_SERVICE = "DIRECTORY SERVICE";
    protected JMSConnectorClient m_client;
    protected IAgentManagerProxy m_agentManager;
    String m_domain;
    protected MFMgmtBeanFactory m_beanFactory;

    public MFContainerUtility(String domain, JMSConnectorClient client) throws MalformedObjectNameException, MgmtException {
        this.m_domain = domain;
        this.m_client = client;
        this.m_agentManager = MFProxyFactory.createAgentManagerProxy((JMSConnectorClient)this.m_client, (ObjectName)Utils.createObjectName(this.m_domain, AGENT_MANAGER, AGENT_MANAGER));
        this.m_beanFactory = new MFMgmtBeanFactory();
        this.m_beanFactory.connect((IDirectoryFileSystemService)new DirectoryServiceProxy((IRemoteMBeanServer)client, Utils.createObjectName(this.m_domain, DIRECTORY_SERVICE, DIRECTORY_SERVICE)));
    }

    public void shutdown(String container) {
        System.out.println("Shutting down container:" + container);
        try {
            IAgentProxy agent = this.getAgentProxy(container);
            if (agent == null) {
                System.out.println("Shutdown failed.  Container " + container + " is not accessible.");
                return;
            }
            agent.shutdown();
            System.out.println("Container shutdown successful.");
        }
        catch (ProxyRuntimeException pre) {
            System.out.println("Resume failed due to unexpected exception:");
            Exception target = pre.getTargetException();
            if (target != null) {
                target.printStackTrace();
            } else {
                pre.printStackTrace();
            }
        }
        catch (Exception e) {
            System.out.println("Shutdown failed due to unexpected exception:");
            e.printStackTrace();
        }
    }

    public String getBootfile(String containerViewPath) throws MgmtException {
        IContainerBean bean = this.m_beanFactory.getContainerBean(containerViewPath);
        return bean.generateBootFile();
    }

    public void suspend(String container, String component) {
        System.out.println("Suspending Component Name = " + component + ", Container = " + container);
        try {
            if (!this.isComponentAvailable(container, component)) {
                System.out.println("Suspend failed.  Component " + component + " is not accessible.");
                return;
            }
            this.invokeNoArgMethod("stop", Utils.createObjectName(this.m_domain, container, component));
            System.out.println("Component suspend successful.");
        }
        catch (ProxyRuntimeException pre) {
            System.out.println("Resume failed due to unexpected exception:");
            Exception target = pre.getTargetException();
            if (target != null) {
                target.printStackTrace();
            } else {
                pre.printStackTrace();
            }
        }
        catch (InvokeTimeoutException e) {
            System.out.println("Suspend failed due to " + ((Object)((Object)e)).getClass().getName() + ":" + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("Suspend failed due to : ");
            e.printStackTrace();
        }
    }

    public void resume(String container, String component) {
        System.out.println("Resuming Component Name = " + component + ", Container = " + container);
        try {
            if (!this.isComponentAvailable(container, component)) {
                System.out.println("Resume failed.  Component " + component + " is not accessible.");
                return;
            }
            this.invokeNoArgMethod("start", Utils.createObjectName(this.m_domain, container, component));
            System.out.println("Component resume successful.");
        }
        catch (ProxyRuntimeException pre) {
            System.out.println("Resume failed due to unexpected exception:");
            Exception target = pre.getTargetException();
            if (target != null) {
                target.printStackTrace();
            } else {
                pre.printStackTrace();
            }
        }
        catch (Exception e) {
            System.out.println("Resume failed due to unexpected exception:");
            e.printStackTrace();
        }
    }

    public void reload(String container, String component) {
        String componentName = component;
        System.out.println("Reloading Component Name = " + component + ", Container = " + container);
        try {
            IAgentProxy agent = this.getAgentProxy(container, component);
            if (agent == null) {
                System.out.println("Reload failed.  Component " + component + " is not accessible.");
                return;
            }
            agent.reloadComponent(component);
            while (!this.isComponentOnline(component, agent)) {
                Thread.sleep(5000L);
            }
            System.out.println("Component reload successful.");
        }
        catch (ProxyRuntimeException pre) {
            System.out.println("Resume failed due to unexpected exception:");
            Exception target = pre.getTargetException();
            if (target != null) {
                target.printStackTrace();
            } else {
                pre.printStackTrace();
            }
        }
        catch (Exception e) {
            System.out.println("Reload failed due to unexpected exception:");
            e.printStackTrace();
        }
    }

    public boolean isComponentOnline(String theComponentName, IAgentProxy agent) {
        boolean retStatus;
        block3: {
            retStatus = false;
            try {
                IContainerState containerState = agent.getContainerState();
                if (containerState == null) break block3;
                IComponentState[] componentStates = containerState.getComponentStates();
                for (int stateIdx = 0; stateIdx < componentStates.length; ++stateIdx) {
                    IComponentIdentity ci = (IComponentIdentity)componentStates[stateIdx].getRuntimeIdentity();
                    String componentName = ci.getComponentName();
                    short cs = componentStates[stateIdx].getState();
                    System.out.println(componentName + " state = " + MFContainerUtility.getComponentState(cs));
                    if (!componentName.equals(theComponentName) || cs != 3) continue;
                    retStatus = true;
                    break;
                }
            }
            catch (InvokeTimeoutException ite) {
                ite.printStackTrace();
            }
        }
        return retStatus;
    }

    private static String getComponentState(short state) {
        switch (state) {
            case 1: {
                return "STATE_OFFLINE";
            }
            case 3: {
                return "STATE_ONLINE";
            }
            case 2: {
                return "STATE_STARTING";
            }
            case 4: {
                return "STATE_STOPPING";
            }
            case 0: {
                return "STATE_UNKNOWN";
            }
        }
        return "STATUS_UNKNOWN(" + state + ")";
    }

    public void printDomainState() {
        System.out.println("Listing management domain state...");
        IState[] states = this.getDomainState();
        for (int i = 0; i < states.length; ++i) {
            System.out.println();
            IContainerState containerState = (IContainerState)states[i];
            this.printContainerState(containerState);
        }
    }

    public IState[] getDomainState() {
        return this.m_agentManager.getCollectiveState();
    }

    public void printContainerState(String container) {
        IContainerState containerState = this.getContainerState(container);
        if (containerState == null) {
            System.out.println("Container " + container + " is not accessible.");
            return;
        }
        this.printContainerState(containerState);
    }

    private void invokeNoArgMethod(String method, ObjectName obj) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.m_client.invoke(obj, method, new Object[0], new String[0]);
    }

    public Object invokeAnyMethod(String component, String container, String method, Object[] argVals, String[] argTypes) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Object obj = null;
        System.out.println("Invoking Component Name = " + component + ", Container = " + container + ", Method= " + method);
        System.out.println("m_domain=" + this.m_domain);
        try {
            if (!this.isComponentAvailable(container, component)) {
                System.out.println("Invoke method " + method + " failed." + "Component " + component + " is not accessible.");
                return null;
            }
            obj = this.m_client.invoke(Utils.createObjectName(this.m_domain, container, component), method, argVals, argTypes);
            System.out.println("Component Invoke method " + method + " successful.");
        }
        catch (ProxyRuntimeException pre) {
            System.out.println("Component Invoke method " + method + " failed due to unexpected exception:");
            Exception target = pre.getTargetException();
            if (target != null) {
                target.printStackTrace();
            } else {
                pre.printStackTrace();
            }
        }
        catch (InvokeTimeoutException e) {
            System.out.println("Component Invoke method " + method + " failed due to " + ((Object)((Object)e)).getClass().getName() + ":" + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("Component Invoke method " + method + " failed due to : " + e.getMessage());
            e.printStackTrace();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printContainerState(IContainerState containerState) {
        IContainerIdentity containerIdentity = (IContainerIdentity)containerState.getRuntimeIdentity();
        StringBuilder buffer = new StringBuilder("Container Name = ");
        buffer.append(containerIdentity.getContainerName());
        buffer.append(", State = ");
        buffer.append(containerState.getStateString());
        try {
            buffer.append(", Container Config Name = ");
            String configName = this.m_beanFactory.getConfigServer().storageToLogical(containerIdentity.getConfigIdentity().getName());
            buffer.append(configName);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            short state = containerState.getState();
            if (state != 3) {
                return;
            }
            buffer.append(", Host = ");
            buffer.append(containerState.getContainerHost());
        }
        finally {
            System.out.println(buffer.toString());
        }
        IComponentState[] states = containerState.getComponentStates();
        for (int i = 0; i < states.length; ++i) {
            IComponentState componentState = states[i];
            this.printComponentState(componentState);
        }
    }

    private void printComponentState(IComponentState componentState) {
        IComponentIdentity componentIdentity = (IComponentIdentity)componentState.getRuntimeIdentity();
        String componentName = componentIdentity.getComponentName();
        if (componentName.equals(AGENT) || componentName.equals(AGENT_MANAGER) || componentName.equals(DIRECTORY_SERVICE)) {
            return;
        }
        StringBuilder buffer = new StringBuilder("     Component Name = ");
        buffer.append(componentName);
        buffer.append(", State = ");
        buffer.append(componentState.getStateString());
        System.out.println(buffer.toString());
    }

    public boolean isContainerAvailable(String container) {
        IContainerState containerState = this.getContainerState(container);
        return containerState != null && containerState.getState() == 3;
    }

    public IContainerState getContainerState(String container) {
        IState[] states = this.m_agentManager.getCollectiveState();
        if (states == null) {
            return null;
        }
        for (int i = 0; i < states.length; ++i) {
            IContainerState containerState = (IContainerState)states[i];
            IContainerIdentity containerIdentity = (IContainerIdentity)containerState.getRuntimeIdentity();
            if (!containerIdentity.getContainerName().equals(container)) continue;
            return containerState;
        }
        return null;
    }

    public IComponentState getComponentState(String container, String component) {
        IContainerState containerState = this.getContainerState(container);
        if (containerState == null || containerState.getState() != 3) {
            return null;
        }
        IComponentState[] states = containerState.getComponentStates();
        for (int i = 0; i < states.length; ++i) {
            IComponentState componentState = states[i];
            IComponentIdentity componentIdentity = (IComponentIdentity)componentState.getRuntimeIdentity();
            if (!componentIdentity.getComponentName().equals(component)) continue;
            return componentState;
        }
        return null;
    }

    public Map getSubComponentStates(String container, String component) {
        Map subComponentStates = null;
        IComponentState componentState = this.getComponentState(container, component);
        if (componentState != null) {
            subComponentStates = componentState.getSubComponentStates();
        }
        return subComponentStates;
    }

    public boolean isComponentAvailable(String container, String component) {
        IComponentState state = this.getComponentState(container, component);
        return state != null;
    }

    private IAgentProxy getAgentProxy(String container) throws MalformedObjectNameException {
        if (this.isContainerAvailable(container)) {
            return MFProxyFactory.createAgentProxy((JMSConnectorClient)this.m_client, (ObjectName)Utils.createAgentName(this.m_domain, container));
        }
        return null;
    }

    private IAgentProxy getAgentProxy(String container, String component) throws MalformedObjectNameException {
        if (this.isComponentAvailable(container, component)) {
            return MFProxyFactory.createAgentProxy((JMSConnectorClient)this.m_client, (ObjectName)Utils.createAgentName(this.m_domain, container));
        }
        return null;
    }

    static boolean parseContainerArgs(String command, String container, String component) {
        boolean isComponentSpecified;
        boolean isContainerSpecified;
        if (command == null || command.trim().length() == 0) {
            return false;
        }
        if ("list".equalsIgnoreCase(command)) {
            return true;
        }
        boolean bl = isContainerSpecified = container != null && container.trim().length() > 0;
        if ("shutdown".equalsIgnoreCase(command) || "status".equalsIgnoreCase(command)) {
            return isContainerSpecified;
        }
        boolean bl2 = isComponentSpecified = container != null && container.trim().length() > 0;
        if ("suspend".equalsIgnoreCase(command) || "resume".equalsIgnoreCase(command) || "reload".equalsIgnoreCase(command)) {
            return isComponentSpecified;
        }
        return false;
    }

    static void printContainerUsage() {
        System.out.println("Error: command is 'container [suspend|resume|reload] <container-name> <component-name>'");
        System.out.println("or 'container list'");
        System.out.println("or 'container [shutdown|status] <container-name>'");
    }

    public static void main(String[] args) throws Exception {
        Hashtable map = Utils.createConnectorMap("tcp://nbjmeritt:2506", "Administrator", "Administrator");
        JMSConnectorClient client = new JMSConnectorClient();
        client.connect(new JMSConnectorAddress(map));
        MFContainerUtility utility = new MFContainerUtility("Domain1", client);
        utility.printContainerState("Container1");
        client.disconnect();
    }
}

