/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.install.config;

import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.mq.mgmtapi.config.IAcceptorDirectBean;
import com.sonicsw.mq.mgmtapi.config.IAcceptorsBean;
import com.sonicsw.mq.mgmtapi.config.IBrokerBean;
import com.sonicsw.mq.mgmtapi.config.IWSProtocolBean;
import com.sonicsw.mq.mgmtapi.config.IWSProtocolUrlEndpointBean;
import com.sonicsw.mq.mgmtapi.config.MQMgmtBeanFactory;
import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.ConfigServiceException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class WSProtocolConfig {
    public static boolean m_debug;
    private static final int INSTALL_MODE = 1;
    private static final int UNINSTALL_MODE = 2;
    private static int m_mode;
    private MQMgmtBeanFactory m_domainFactory;
    private String m_url;
    private String m_domain;
    private String m_user;
    private String m_password;
    private String m_wsprotocol;
    private String m_deliveryMode;
    private String m_destination;
    private String m_destinationType;
    private String m_urlExtension;
    private String m_httpUser;
    private String m_wsdlURL;
    private String m_httpDirectHost;
    private int m_httpDirectPort;
    private String m_acceptorName;
    private String m_broker;

    public final void debug(String s) {
        if (m_debug) {
            System.out.println(s);
        }
    }

    public WSProtocolConfig(String[] args) throws Exception {
        m_mode = 1;
        ConfigServerUtility csu = new ConfigServerUtility();
        try {
            this.parseArgs(args);
            this.m_domainFactory = new MQMgmtBeanFactory();
            this.debug("connecting to domain " + this.m_domain + " @ " + this.m_url);
            csu.connect(this.m_domain, this.m_url, this.m_user, this.m_password, true);
            this.debug("successfully connected");
            this.m_domainFactory.connect(csu.getDirectoryService());
            this.configureDevWSConfiguration();
            System.out.println("*success*");
        }
        catch (MgmtException e) {
            e.printStackTrace();
            System.out.println("*error*");
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("*error*");
            throw e;
        }
        finally {
            try {
                csu.disconnect();
            }
            catch (ConfigServiceException e) {}
        }
    }

    private IWSProtocolBean configureWSProtocolConfiguration() throws Exception {
        if (m_mode == 1) {
            IWSProtocolBean wsProtocolBean = null;
            boolean beanCreated = false;
            try {
                wsProtocolBean = this.m_domainFactory.getWSProtocolBean(this.m_wsprotocol);
            }
            catch (MgmtException e) {
                wsProtocolBean = this.m_domainFactory.createWSProtocolBean(this.m_wsprotocol);
                beanCreated = true;
            }
            IWSProtocolUrlEndpointBean urlEndpointBean = wsProtocolBean.createWSProtocolUrlEndpointBean();
            try {
                urlEndpointBean.setUrl(this.m_urlExtension);
            }
            catch (MgmtException e) {
                if (beanCreated) {
                    this.m_domainFactory.saveBean((IMgmtBeanBase)wsProtocolBean);
                }
                this.m_domainFactory.commit();
                return wsProtocolBean;
            }
            urlEndpointBean.setDeliveryMode(this.m_deliveryMode);
            urlEndpointBean.setDestinationName(this.m_destination);
            urlEndpointBean.setDestinationType(this.m_destinationType);
            urlEndpointBean.setUser(this.m_httpUser);
            urlEndpointBean.setWsdlLocation(this.m_wsdlURL);
            IWSProtocolBean.IWsProtocolURLMapType urlmap = wsProtocolBean.getDirectUrlMap();
            urlmap.addItem(ConfigFactory.createGUID(), (IMgmtBeanBase)urlEndpointBean);
            this.m_domainFactory.saveBean((IMgmtBeanBase)wsProtocolBean);
            this.m_domainFactory.commit();
            return wsProtocolBean;
        }
        IWSProtocolBean wsProtocolBean = null;
        try {
            wsProtocolBean = this.m_domainFactory.getWSProtocolBean(this.m_wsprotocol);
        }
        catch (MgmtException mgmtException) {
            // empty catch block
        }
        if (wsProtocolBean != null) {
            this.m_domainFactory.deleteWSProtocolBean(wsProtocolBean);
            this.m_domainFactory.saveBean((IMgmtBeanBase)wsProtocolBean);
        }
        this.m_domainFactory.commit();
        return wsProtocolBean;
    }

    private void configureDevWSConfiguration() throws Exception {
        IBrokerBean broker = this.lookupBroker();
        if (broker == null) {
            throw new Exception("failed to locate broker " + this.m_broker);
        }
        IWSProtocolBean bean = this.configureWSProtocolConfiguration();
        if (m_mode == 1) {
            this.addDevInboundConfig(broker, bean);
        } else {
            this.removeDevInboundConfig(broker);
        }
    }

    private IBrokerBean lookupBroker() throws MgmtException {
        IBrokerBean broker = null;
        List brokerNames = this.m_domainFactory.getBrokerBeanNames();
        for (String beanName : brokerNames) {
            if (!this.m_broker.equals(beanName)) continue;
            broker = this.m_domainFactory.getBrokerBean(this.m_broker);
        }
        return broker;
    }

    public IAcceptorDirectBean lookupDirectAcceptor(IBrokerBean broker, boolean createIfNotFound) throws MgmtException {
        IAcceptorDirectBean directAcceptor = null;
        IAcceptorsBean acceptorsBean = broker.getAcceptorsBean();
        IAcceptorsBean.IAcceptorMapType acceptors_map = acceptorsBean.getAcceptors();
        Iterator names = acceptors_map.getKeyNames().iterator();
        while (names.hasNext()) {
            IMgmtBeanBase bean = acceptors_map.getItem((String)names.next());
            if (!(bean instanceof IAcceptorDirectBean)) continue;
            IAcceptorDirectBean acceptor = (IAcceptorDirectBean)bean;
            this.debug("  Http Direct Acceptor info: ");
            this.debug("    name: " + acceptor.getAcceptorName());
            this.debug("    type: " + acceptor.getAcceptorType());
            this.debug("     url: " + acceptor.getAcceptorUrl());
            if (this.getHttpPort(acceptor.getAcceptorUrl()) != this.m_httpDirectPort) continue;
            directAcceptor = acceptor;
        }
        if (directAcceptor == null) {
            this.debug("acceptor not found");
            if (createIfNotFound) {
                this.debug("  creating acceptor " + this.m_acceptorName + " on port " + this.m_httpDirectPort);
                directAcceptor = acceptorsBean.createAcceptorDirectBean();
                directAcceptor.setAcceptorName(this.m_acceptorName);
                directAcceptor.setAcceptorUrl("http://" + this.m_httpDirectHost + ":" + this.m_httpDirectPort);
                acceptors_map.addItem(this.m_domainFactory.createUniqueName(), (IMgmtBeanBase)directAcceptor);
            }
        } else {
            this.debug("acceptor found");
        }
        return directAcceptor;
    }

    private void removeDevInboundConfig(IBrokerBean broker) throws MgmtException {
        IAcceptorDirectBean acceptor = this.lookupDirectAcceptor(broker, false);
        if (acceptor == null) {
            return;
        }
        IAcceptorsBean acceptorsBean = broker.getAcceptorsBean();
        IAcceptorsBean.IAcceptorMapType acceptors_map = acceptorsBean.getAcceptors();
        for (String name : acceptors_map.getKeyNames()) {
            IAcceptorDirectBean directBean;
            IMgmtBeanBase bean = acceptors_map.getItem(name);
            if (!(bean instanceof IAcceptorDirectBean) || (directBean = (IAcceptorDirectBean)bean).getAcceptorName() == null || !directBean.getAcceptorName().equals(this.m_acceptorName)) continue;
            try {
                URL url = new URL(directBean.getAcceptorUrl());
                int port = url.getPort();
                if (this.m_httpDirectPort != port) continue;
                acceptors_map.deleteItem(name);
            }
            catch (MalformedURLException e) {}
        }
    }

    private void addDevInboundConfig(IBrokerBean broker, IWSProtocolBean wsProtocolBean) throws MgmtException {
        IAcceptorDirectBean acceptor = this.lookupDirectAcceptor(broker, true);
        try {
            acceptor.addWSProtocolBean((IMgmtBeanBase)wsProtocolBean);
        }
        catch (MgmtException e) {
            // empty catch block
        }
        this.m_domainFactory.saveBean((IMgmtBeanBase)acceptor);
        this.m_domainFactory.commit();
    }

    private void parseArgs(String[] args) throws Exception {
        String debug = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-url".equals(args[i])) {
                this.m_url = args[++i];
                continue;
            }
            if ("-domain".equals(args[i])) {
                this.m_domain = args[++i];
                continue;
            }
            if ("-user".equals(args[i])) {
                this.m_user = args[++i];
                continue;
            }
            if ("-password".equals(args[i])) {
                this.m_password = args[++i];
                continue;
            }
            if ("-broker".equals(args[i])) {
                this.m_broker = args[++i];
                continue;
            }
            if ("-wsprotocol".equals(args[i])) {
                this.m_wsprotocol = args[++i];
                continue;
            }
            if ("-deliveryMode".equals(args[i])) {
                this.m_deliveryMode = args[++i];
                continue;
            }
            if ("-destination".equals(args[i])) {
                this.m_destination = args[++i];
                continue;
            }
            if ("-destinationType".equals(args[i])) {
                this.m_destinationType = args[++i];
                continue;
            }
            if ("-urlExtension".equals(args[i])) {
                this.m_urlExtension = args[++i];
                continue;
            }
            if ("-httpUser".equals(args[i])) {
                this.m_httpUser = args[++i];
                continue;
            }
            if ("-wsdlURL".equals(args[i])) {
                this.m_wsdlURL = args[++i];
                continue;
            }
            if ("-httpDirectPort".equals(args[i])) {
                this.m_httpDirectPort = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-httpDirectHost".equals(args[i])) {
                this.m_httpDirectHost = args[++i];
                continue;
            }
            if ("-acceptorName".equals(args[i])) {
                this.m_acceptorName = args[++i];
                continue;
            }
            if ("-mode".equals(args[i])) {
                String mode;
                if (!"uninstall".equalsIgnoreCase(mode = args[++i])) continue;
                m_mode = 2;
                continue;
            }
            if (!"-debug".equals(args[i])) continue;
            debug = args[++i];
        }
        if (debug != null) {
            boolean bl = m_debug = "true".equals(debug.toLowerCase());
        }
        if (this.m_url == null || this.m_domain == null) {
            throw new Exception("missing -url or -domain");
        }
        if (this.m_broker == null) {
            throw new Exception("missing -broker");
        }
    }

    private int getHttpPort(String url) {
        this.debug("url: " + url);
        int index = url.lastIndexOf(":");
        String portSubstring = url.substring(index);
        StringTokenizer st = new StringTokenizer(portSubstring, "?/;:");
        String port = st.nextToken();
        return Integer.parseInt(port);
    }

    public static void main(String[] args) throws Exception {
        new WSProtocolConfig(args);
        System.exit(0);
    }

    static {
        m_mode = 1;
    }
}

