/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.action;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactComparator;
import com.sonicsw.deploy.IArtifactComparison;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.action.AbstractAction;
import com.sonicsw.deploy.compare.ComparatorFactory;
import com.sonicsw.xqimpl.util.ClassUtils;
import java.util.ArrayList;

public class CompareAction
extends AbstractAction {
    protected IArtifact[] m_artifact;
    protected IArtifactComparison[] m_result;

    public CompareAction(IArtifact artifact) {
        this(new IArtifact[]{artifact});
    }

    public CompareAction(IArtifact[] artifacts) {
        this.m_artifact = (IArtifact[])ClassUtils.arrayCopy((Object[])artifacts);
    }

    @Override
    public String getDescription() {
        return "Compare";
    }

    public IArtifactComparison[] getResult() {
        return this.m_result;
    }

    @Override
    public void run(IArtifactStorage source, IArtifactStorage destination) throws Exception {
        ArrayList<IArtifactComparison> result = new ArrayList<IArtifactComparison>();
        for (int i = 0; i < this.m_artifact.length; ++i) {
            IArtifactComparator comparator = ComparatorFactory.createComparator(this.m_artifact[i]);
            result.add(comparator.compare(source, destination));
        }
        this.m_result = result.toArray(new IArtifactComparison[0]);
    }

    public static IArtifactComparison[] compareTo(IArtifactStorage source, IArtifactStorage dest, IArtifact[] artifacts) throws Exception {
        CompareAction action = new CompareAction(artifacts);
        source.performActionTo(dest, action);
        return action.getResult();
    }
}

