/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.artifact;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.storage.FileArtifactStorage;
import com.sonicsw.deploy.storage.ZipArtifactStorage;
import com.sonicsw.deploy.util.FileUtils;
import com.sonicsw.deploy.util.PropertyUtils;
import java.io.File;
import java.util.List;

public class ZipFileArtifact
extends SonicFSArtifact {
    public static final String TYPE = "ZipFile";
    private IArtifact parent_;
    private boolean dirty_;
    private String tempDirPath_;
    private ZipArtifactStorage zipStorage;
    private static final String ZIP_EXTENSIONS = "zip.extensions";
    private static final String DEFAULT_ZIP_EXTENSIONS = "bpar,csar";
    private static List s_zipExtensions;

    public ZipFileArtifact(String path) {
        super(path);
        this.init();
    }

    public ZipFileArtifact(IArtifact base, String name, String tempDirPath) {
        this((base.getPath().endsWith("/") ? base.getPath() : base.getPath() + "/") + name);
        this.parent_ = base;
        this.tempDirPath_ = tempDirPath;
        this.init();
    }

    public ZipFileArtifact(String newPath, ZipFileArtifact oldZipArtifact) {
        super(newPath);
        this.tempDirPath_ = oldZipArtifact.tempDirPath_;
        this.zipStorage = oldZipArtifact.getZipStorage();
        this.m_type = TYPE;
        this.init();
    }

    final void init() {
        this.m_type = TYPE;
        if (this.m_path == null || this.m_path.length() == 0) {
            throw new UnsupportedOperationException("Invalid artifact path");
        }
        this.dirty_ = false;
    }

    @Override
    public boolean isRootPath() {
        return super.isRootPath();
    }

    public IArtifact getParent() {
        return this.parent_;
    }

    public void markDirty() {
        this.dirty_ = true;
    }

    public boolean isDirty() {
        return this.dirty_;
    }

    public String getTempDirPath() {
        return this.tempDirPath_;
    }

    public static boolean isArchiveFile(String name) {
        int idx = name.lastIndexOf(46);
        if (idx <= 0) {
            return false;
        }
        return ZipFileArtifact.isArchiveExtension(name.substring(idx + 1));
    }

    public static boolean isArchiveExtension(String extension) {
        return s_zipExtensions.contains(extension);
    }

    public void prepare(IArtifactTraversalContext context) throws Exception {
        File extractLocation;
        String archiveLocation;
        IArtifactStorage backingStore = context.getStorage();
        if (this.zipStorage != null) {
            return;
        }
        this.zipStorage = new ZipArtifactStorage();
        this.zipStorage.setZipTempDirectory(null);
        File tempdir = this.zipStorage.getRoot();
        if (backingStore instanceof FileArtifactStorage && !(backingStore instanceof ZipArtifactStorage)) {
            FileArtifactStorage fileStorage = (FileArtifactStorage)backingStore;
            archiveLocation = FileArtifactStorage.getFilename(this);
            archiveLocation = new File(fileStorage.getRoot(), archiveLocation).toString();
            extractLocation = new File(tempdir, this.getName());
        } else {
            File localArchive = File.createTempFile(this.getName() + "_temp_", "", tempdir);
            localArchive.delete();
            extractLocation = new File(tempdir, this.getName());
            byte[] zipContents = backingStore.getContentsAsBytes(this);
            FileUtils.writeFile(localArchive, zipContents);
            localArchive.deleteOnExit();
            archiveLocation = localArchive.getAbsolutePath();
        }
        this.zipStorage.openArchive(archiveLocation, false, extractLocation.getAbsolutePath());
    }

    public File getLocalArchive() {
        return this.zipStorage.getRoot();
    }

    public ZipArtifactStorage getZipStorage() {
        return this.zipStorage;
    }

    @Override
    public String getArchivePath() {
        return "/SonicFS" + this.m_path;
    }

    @Override
    public String getArchiveParentPath() {
        return this._getParentPath(this.getArchivePath());
    }

    static {
        PropertyUtils prop = PropertyUtils.getInstance();
        s_zipExtensions = prop.tokenizeToLower(prop.getProperty(ZIP_EXTENSIONS, DEFAULT_ZIP_EXTENSIONS));
    }
}

