/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.compare;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactComparator;
import com.sonicsw.deploy.IArtifactComparison;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.compare.CompareHelper;
import com.sonicsw.deploy.compare.ComparisonResult;
import java.util.List;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;

public abstract class AbstractComparator
implements IArtifactComparator {
    private final IArtifact m_artifact;

    public AbstractComparator(IArtifact artifact) {
        this.m_artifact = artifact;
    }

    public IArtifact getArtifact() {
        return this.m_artifact;
    }

    @Override
    public abstract IArtifactComparison compare(IArtifactStorage var1, IArtifactStorage var2);

    public String getContentAsString(IArtifactStorage store) {
        try {
            return store.getContentsAsString(this.m_artifact);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public byte[] getContentAsBytes(IArtifactStorage store) {
        try {
            return store.getContentsAsBytes(this.m_artifact);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected IArtifactComparison compareAsBytes(byte[] source, byte[] destination) {
        ComparisonResult result = new ComparisonResult(this.m_artifact);
        if (source == null || destination == null) {
            result.setMessage("Artifact is not present in " + (source == null ? "source" : "destination"));
        } else {
            result.setEquivalent(false);
            int mismatchOffset = -1;
            for (int i = 0; i < source.length && i < destination.length; ++i) {
                if (source[i] == destination[i]) continue;
                mismatchOffset = i;
                break;
            }
            if (mismatchOffset == -1) {
                if (source.length == destination.length) {
                    result.setEqual(true);
                    result.setMessage("Artifact contents are equal");
                } else {
                    int n = mismatchOffset = source.length < destination.length ? source.length : destination.length;
                }
            }
            if (mismatchOffset != -1) {
                result.setEqual(false);
                result.setMessage("Artifact contents compare unequal at offset " + mismatchOffset);
            }
        }
        return result;
    }

    protected IArtifactComparison compareAsString(String source, String destination) {
        ComparisonResult result = new ComparisonResult(this.m_artifact);
        if (source == null || destination == null) {
            result.setMessage("Artifact is not present in " + source == null ? "source" : "destination");
        } else if (source.equals(destination)) {
            result.setEqual(true);
            result.setMessage("Artifact contents are equal");
        } else if (source.equalsIgnoreCase(destination)) {
            result.setEquivalent(true);
            result.setMessage("Artifact contents are equivalent");
        } else {
            int startOffset = 0;
            int testLen = source.length() / 2;
            int untestedLen = source.length() - testLen;
            while (testLen != 0 && untestedLen != 0) {
                boolean matches = source.regionMatches(true, startOffset, destination, startOffset, testLen);
                if (matches) {
                    startOffset += testLen;
                    testLen = untestedLen / 2;
                    untestedLen -= testLen;
                    continue;
                }
                untestedLen = testLen / 2;
                testLen -= untestedLen;
            }
            result.setMessage("Artifact contents compare unequal at offset " + startOffset);
        }
        return result;
    }

    protected IArtifactComparison compareAsXML(String source, String destination) {
        ComparisonResult result = new ComparisonResult(this.m_artifact);
        try {
            if (source == null || destination == null) {
                result.setMessage("Artifact is not present in " + (source == null ? "source" : "destination"));
            } else {
                Diff myDiff = CompareHelper.createDiff(source, destination);
                result.setEqual(myDiff.identical());
                result.setEquivalent(myDiff.similar());
                StringBuilder sb = new StringBuilder("Artifact contents are ");
                if (result.isEqual()) {
                    sb.append("equal");
                } else if (result.isEquivalent()) {
                    sb.append("equivalent");
                } else {
                    sb.append("different in the following ways:");
                    DetailedDiff detailedDiff = CompareHelper.createDetailedDiff(source, destination);
                    List diffs = detailedDiff.getAllDifferences();
                    for (int i = 0; i < diffs.size(); ++i) {
                        sb.append("\n").append(diffs.get(i).toString());
                    }
                }
                result.setMessage(sb.toString());
            }
        }
        catch (Exception e) {
            result.setMessage("Exception " + e.getClass().getName() + "occurred during comparison of " + this.m_artifact.toString() + " with message: " + e.getMessage());
        }
        return result;
    }
}

