/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.compare;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.compare.Diff;
import com.sonicsw.sonicxq.DiffBinaryArtifactType;

public class BinaryDiff
extends Diff {
    private int m_mismatchLocation = -1;

    public BinaryDiff(IArtifactStorage srcStore, IArtifactStorage trgStore) {
        super(srcStore, trgStore);
    }

    @Override
    public Object diffArtifact(IArtifact src, IArtifact trg) throws Exception {
        byte[] srcAsBytes = this.m_sourceStore.getContentsAsBytes(src);
        byte[] trgAsBytes = this.m_targetStore.getContentsAsBytes(trg);
        if (srcAsBytes == null && trgAsBytes == null) {
            return null;
        }
        if (srcAsBytes == null || trgAsBytes == null) {
            this.m_mismatchLocation = 1;
        }
        if (this.m_mismatchLocation == -1) {
            this.m_mismatchLocation = this.compareByteArrays(srcAsBytes, trgAsBytes);
        }
        if (this.m_mismatchLocation == -1 && srcAsBytes.length != trgAsBytes.length) {
            this.m_mismatchLocation = srcAsBytes.length < trgAsBytes.length ? srcAsBytes.length : trgAsBytes.length;
        }
        return this.formDiffRecord(src.getName(), src.getArchivePath());
    }

    private DiffBinaryArtifactType formDiffRecord(String name, String path) {
        if (this.m_mismatchLocation == -1) {
            return null;
        }
        DiffBinaryArtifactType diffRecord = DiffBinaryArtifactType.Factory.newInstance();
        diffRecord.setPath(path);
        diffRecord.setByteoffset(new Integer(this.m_mismatchLocation).toString());
        return diffRecord;
    }

    private int compareByteArrays(byte[] srcAsBytes, byte[] trgAsBytes) {
        int mismatchOffset = -1;
        for (int i = 0; i < srcAsBytes.length && i < trgAsBytes.length; ++i) {
            if (srcAsBytes[i] == trgAsBytes[i]) continue;
            mismatchOffset = i;
            break;
        }
        return mismatchOffset;
    }
}

