/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.storage;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.artifact.ConfigBeanArtifact;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.artifact.SystemArtifact;
import com.sonicsw.deploy.artifact.ZipContentArtifact;
import com.sonicsw.deploy.artifact.ZipFileArtifact;
import com.sonicsw.deploy.storage.AbstractArtifactStorage;
import com.sonicsw.deploy.traversal.ZipContentTraverser;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.util.SonicFSFileSystem;
import com.sonicsw.xqimpl.config.IConfiguration;
import com.sonicsw.xqimpl.config.XQConfigHelper;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConfiguration;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;

public class DSArtifactStorage
extends AbstractArtifactStorage {
    private SonicFSFileSystem m_sfs;
    private XQConfigManager m_cfgMgr;
    private ConfigServerUtility m_cfgUtil;
    private String m_domain;
    private String m_url;
    private String m_username;
    private static final String[][] S_TYPE_MAP = new String[][]{{"XQ_CONTAINER", ESBArtifact.CONTAINER.getRootDirectory()}, {"process", ESBArtifact.PROCESS.getRootDirectory()}, {"service", ESBArtifact.SERVICE.getRootDirectory()}, {"serviceType", ESBArtifact.SERVICE_TYPE.getRootDirectory()}, {"endpoint", ESBArtifact.ENDPOINT.getRootDirectory()}, {"endpointType", ESBArtifact.ENDPOINT_TYPE.getRootDirectory()}, {"connection", ESBArtifact.CONNECTION.getRootDirectory()}, {"connectionType", ESBArtifact.CONNECTION_TYPE.getRootDirectory()}};

    public DSArtifactStorage() throws Exception {
        this.setStoreName("Storage[DS]");
    }

    public String getDomain() {
        return this.m_domain;
    }

    public String getURL() {
        return this.m_url;
    }

    public String getUsername() {
        return this.m_username;
    }

    public String toString() {
        return this.getStoreName() + (this.m_domain != null ? " for domain \"" + this.m_domain + "\"" : "") + (this.m_url != null ? ", url \"" + this.m_url + "\"" : "") + (this.m_username != null ? "\", user \"" + this.m_username + "\"" : "");
    }

    public void connect(String domain, String url, String user, String password) throws Exception {
        this._notifyMessage(2, "Connecting to " + domain + " @ " + url);
        if (domain == null || domain.length() == 0) {
            throw new Exception("Domain is not specified");
        }
        if (url == null || url.length() == 0) {
            throw new Exception("URL is not specified");
        }
        this.m_domain = domain;
        this.m_url = url;
        this.m_username = user;
        Hashtable<String, String> hash = new Hashtable<String, String>();
        hash.put("java.naming.provider.url", url);
        hash.put("DOMAIN_NAME", domain);
        this.m_cfgMgr = XQConfigManager.getInstance(hash);
        this.m_cfgMgr.setDirectoryProxy(url, password, user, domain);
        this.m_sfs = new SonicFSFileSystem((IDirectoryFileSystemService)this.m_cfgMgr.getDirectoryService(), user);
        this.m_cfgUtil = new ConfigServerUtility();
        this.m_cfgUtil.connect((IDirectoryFileSystemService)this.m_cfgMgr.getDirectoryService(), true);
    }

    public void connect(IDirectoryAdminService dsProxy, String domain, String user) throws Exception {
        this.m_domain = domain;
        this.m_username = user;
        this._notifyMessage(2, "Connecting to " + this.m_domain + " using DirectoryServiceProxy");
        this.m_cfgMgr = new XQConfigManager(dsProxy, user);
        this.m_sfs = new SonicFSFileSystem((IDirectoryFileSystemService)this.m_cfgMgr.getDirectoryService(), user);
        this.m_cfgUtil = new ConfigServerUtility();
        this.m_cfgUtil.connect((IDirectoryFileSystemService)this.m_cfgMgr.getDirectoryService(), true);
    }

    public void disconnectIfLocal() throws Exception {
        if (this.m_cfgUtil != null && this.m_cfgUtil.isLocal()) {
            this.disconnect();
        }
    }

    public void disconnect() throws Exception {
        this._notifyMessage(2, "Disconnecting from " + this.m_domain + " @ " + this.m_url);
        this.m_sfs = null;
        try {
            if (this.m_cfgUtil != null) {
                this.m_cfgUtil.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_cfgMgr != null) {
            this.m_cfgMgr.close();
        }
        this.m_cfgUtil = null;
        this.m_cfgMgr = null;
        this.m_domain = null;
        this.m_url = null;
        this.m_username = null;
    }

    @Override
    public boolean exists(IArtifact artifact) throws Exception {
        try {
            if (artifact instanceof ESBArtifact) {
                return this.m_cfgMgr.lookupSafe(artifact.getName(), this.getESBConfigType(artifact)) != null;
            }
            if (artifact instanceof SonicFSArtifact) {
                return this.m_sfs.exists(artifact.getPath()) && this.m_sfs.isFile(artifact.getPath());
            }
            if (artifact instanceof ConfigBeanArtifact) {
                return this.m_cfgUtil.getConfigServer().pathExists(artifact.getPath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void deleteAll() throws Exception {
        throw new Exception("Delete All not supported by DSArtifactStorage");
    }

    @Override
    public String getContentsAsString(IArtifact artifact) throws Exception {
        String ret = null;
        if (artifact instanceof ESBArtifact) {
            String type = this.getESBConfigType(artifact);
            XQConfiguration config = (XQConfiguration)this.m_cfgMgr.lookup(artifact.getName(), type);
            ret = config.serializeToXML();
        } else if (artifact instanceof ZipContentArtifact) {
            ZipContentArtifact zipContentArtifact = (ZipContentArtifact)artifact;
            ZipFileArtifact zipFile = zipContentArtifact.getZipFileArtifact();
            ret = zipFile.getZipStorage().getContentsAsString(zipContentArtifact);
        } else if (artifact instanceof SonicFSArtifact) {
            ret = this.m_sfs.getContent(artifact.getPath());
        } else if (artifact instanceof ConfigBeanArtifact) {
            ret = this.m_cfgUtil.exportBean(artifact.getPath());
        } else {
            throw new Exception("Failed to get String content of '" + artifact + "' - not supported");
        }
        return ret;
    }

    @Override
    public Document getContentsAsDom(IArtifact artifact) throws Exception {
        Document ret = null;
        if (artifact instanceof ESBArtifact) {
            String type = this.getESBConfigType(artifact);
            XQConfiguration config = (XQConfiguration)this.m_cfgMgr.lookup(artifact.getName(), type);
            ret = config.serializeToXMLDocument();
        } else if (artifact instanceof SonicFSArtifact || artifact instanceof ConfigBeanArtifact) {
            ret = DOMUtils.getDocument((byte[])this.getContentsAsBytes(artifact));
        } else {
            throw new Exception("Failed to get DOM content of '" + artifact + "' - not supported");
        }
        return ret;
    }

    @Override
    public byte[] getContentsAsBytes(IArtifact artifact) throws Exception {
        byte[] ret = null;
        if (artifact instanceof ESBArtifact || artifact instanceof ConfigBeanArtifact) {
            ret = this.getContentsAsString(artifact).getBytes();
        } else if (artifact instanceof ZipContentArtifact) {
            ZipContentArtifact zipContentArtifact = (ZipContentArtifact)artifact;
            ZipFileArtifact zipFile = zipContentArtifact.getZipFileArtifact();
            ret = zipFile.getZipStorage().getContentsAsBytes(zipContentArtifact);
        } else if (artifact instanceof SonicFSArtifact) {
            ret = this.m_sfs.getContentBytes(artifact.getPath());
        } else {
            throw new Exception("Failed to get byte[] content of '" + artifact + "' - not supported");
        }
        return ret;
    }

    @Override
    public void store(IArtifact artifact, Object content) throws Exception {
        if (artifact instanceof ESBArtifact) {
            if (!(content instanceof String)) {
                throw new Exception("Failed to store '" + artifact + "' - only supports String content");
            }
            String type = this.getESBConfigType(artifact);
            if (type == null) {
                throw new Exception("Failed to store '" + artifact + "' - config type not found");
            }
            IConfiguration component = XQConfigHelper.createConfigObject((XQConfigManager)this.m_cfgMgr, (String)type);
            try {
                component.initFromXMLString(null, (String)content, true, false);
                component.initFromDS(component.getElement());
            }
            catch (Exception e) {
                throw new RuntimeException("while storing " + artifact + " due to " + e, e);
            }
            if (component.getName() == null || "".equals(component.getName())) {
                this._notifyMessage(3, "Skipping storage of '" + artifact + "' - no name in configuration.");
                return;
            }
            component.writeToDS();
            this.m_cfgMgr.writeComponentToDS(component, component.getName(), type);
        } else if (artifact instanceof ZipContentArtifact) {
            super.store(artifact, content, null);
        } else if (artifact instanceof ZipFileArtifact) {
            this.copyFileToDS(artifact, content);
        } else if (artifact instanceof SonicFSArtifact) {
            this.copyFileToDS(artifact, content);
        } else {
            if (artifact instanceof ConfigBeanArtifact) {
                throw new UnsupportedOperationException("Not yet implemented");
            }
            if (artifact instanceof SystemArtifact) {
                throw new UnsupportedOperationException("Not yet implemented");
            }
        }
    }

    protected void copyFileToDS(IArtifact artifact, Object content) throws Exception {
        String parent = artifact.getParentPath();
        if (!this.m_sfs.exists(parent)) {
            this.m_sfs.createDirectoryPath(parent);
        }
        if (content instanceof String) {
            this.m_sfs.updateFile(artifact.getPath(), (String)content, true);
        } else if (content instanceof byte[]) {
            this.m_sfs.updateFile(artifact.getPath(), (byte[])content, true);
        } else {
            throw new Exception("Failed to store '" + artifact + "' - only supports String and byte[] content");
        }
    }

    @Override
    protected void _listESBArtifacts(IArtifact parent, IArtifactTraversalContext context) throws Exception {
        String type = this.getESBConfigType(parent);
        if (type == null) {
            throw new Exception("Failed to list '" + parent + "' - config type not found");
        }
        Map names = this.m_cfgMgr.listElementsName(type);
        if (type == "service") {
            Map processNames = this.m_cfgMgr.listElementsName("process");
            for (String key : processNames.keySet()) {
                if (!names.containsKey(key)) continue;
                names.remove(key);
            }
        }
        Iterator iter = names.keySet().iterator();
        while (iter.hasNext()) {
            context.addTraversed(new ESBArtifact(parent, (String)iter.next()));
        }
    }

    @Override
    protected void _listSonicFSArtifacts(IArtifact parent, IArtifactTraversalContext context) throws Exception {
        String[] list = this.m_sfs.list(parent.getPath());
        for (int i = 0; i < list.length; ++i) {
            String current = list[i];
            if (current.endsWith("/")) {
                this._list(new SonicFSArtifact(parent, current), context);
                continue;
            }
            if (ZipFileArtifact.isArchiveFile(current)) {
                ZipFileArtifact zipArtifact = new ZipFileArtifact(parent, current, null);
                ZipContentTraverser traverser = new ZipContentTraverser(zipArtifact);
                traverser.traverse(context);
                continue;
            }
            context.addTraversed(new SonicFSArtifact(parent, current));
        }
    }

    @Override
    protected void _listConfigBeanArtifacts(IArtifact parent, IArtifactTraversalContext context) throws Exception {
        Set list = this.m_cfgUtil.getConfigServer().list(parent.getPath());
        for (Map map : list) {
            String name = (String)map.get("_FOLDER_NAME");
            String type = (String)map.get("TYPE");
            if (name != null) {
                this._list(new ConfigBeanArtifact(name + "/"), context);
                continue;
            }
            if (type != null && "MF_FILE".equals(type)) continue;
            name = ((IElementIdentity)map.get("_ELEMENT_IDENTITY")).getName();
            context.addTraversed(new ConfigBeanArtifact(name));
        }
    }

    @Override
    protected void _listSystemArtifacts(IArtifactTraversalContext context) throws Exception {
    }

    private String getESBConfigType(IArtifact artifact) {
        String directory = artifact.getRootDirectory();
        for (int i = 0; i < S_TYPE_MAP.length; ++i) {
            if (!S_TYPE_MAP[i][1].equals(directory)) continue;
            return S_TYPE_MAP[i][0];
        }
        return null;
    }
}

