/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.tools.common;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.IArtifactTraverser;
import com.sonicsw.deploy.action.CopyAction;
import com.sonicsw.deploy.action.SearchAction;
import com.sonicsw.deploy.storage.DSArtifactStorage;
import com.sonicsw.deploy.storage.FileArtifactStorage;
import com.sonicsw.deploy.tools.common.AbstractHandler;
import com.sonicsw.deploy.tools.common.ExportPropertiesArtifact;
import com.sonicsw.deploy.traversal.TraverserFactory;
import java.io.File;
import java.util.ArrayList;

public class DSToFSExportHandler
extends AbstractHandler {
    protected ExportPropertiesArtifact m_properties;
    private boolean buildErrors = false;

    public IArtifactStorage open(String path, boolean create) throws Exception {
        this.makeDirs(path, create);
        FileArtifactStorage fs = new FileArtifactStorage();
        fs.setRoot(path);
        this.setDestinationStorage(fs);
        this.m_properties = new ExportPropertiesArtifact();
        try {
            this.m_properties.init(fs.getContentsAsBytes(this.m_properties));
        }
        catch (Exception e) {
            // empty catch block
        }
        return fs;
    }

    public void save() throws Exception {
        if (this.getDestinationStorage() == null) {
            throw new Exception("File storage is not defined");
        }
        this.getDestinationStorage().store(this.m_properties, this.m_properties.getContent());
    }

    public void close() throws Exception {
        this.setDestinationStorage(null);
    }

    public IArtifactStorage connectToDS() throws Exception {
        DSArtifactStorage ds = new DSArtifactStorage();
        try {
            this.setSourceStorage(ds);
            ds.connect(this.m_properties.getDomain(), this.m_properties.getURL(), this.m_properties.getUser(), this.m_properties.getPassword());
        }
        catch (Exception e) {
            this.setSourceStorage(null);
            throw e;
        }
        return ds;
    }

    public void disconnectFromDS() throws Exception {
        if (this.getSourceStorage() != null) {
            ((DSArtifactStorage)this.getSourceStorage()).disconnect();
            this.setSourceStorage(null);
        }
    }

    public ExportPropertiesArtifact getExportProperties() {
        return this.m_properties;
    }

    public IArtifact[] getArtifacts() throws Exception {
        IArtifactStorage source = this.getSourceStorage();
        if (source == null) {
            source = this.connectToDS();
        }
        IArtifact[] allArtifacts = this.searchDS(this.m_properties.getRootList());
        return this.addSystemArtifacts(allArtifacts);
    }

    public void writeArtifacts(IArtifactStorage dest, IArtifact[] artifacts, boolean clean) throws Exception {
        IArtifactStorage source = this.getSourceStorage();
        if (clean) {
            dest.deleteAll();
        }
        CopyAction.copyTo(source, dest, artifacts);
    }

    public void rebuild() throws Exception {
        this.writeArtifacts(this.getDestinationStorage(), this.getArtifacts(), true);
    }

    public IArtifact[] searchDS(IArtifact[] roots) throws Exception {
        IArtifactTraverser[] traversers = new IArtifactTraverser[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            traversers[i] = TraverserFactory.createTraverser(roots[i]);
        }
        this.buildErrors = false;
        SearchAction action = new SearchAction(this.getExportProperties().getIgnoreList(), traversers, true);
        this.getSourceStorage().performAction(action);
        if (action.getErrors() != null && action.getErrors().length > 0) {
            this.buildErrors = true;
        }
        return action.getResult();
    }

    public boolean hasBuildErrors() {
        return this.buildErrors;
    }

    public IArtifact[] listAll() throws Exception {
        return SearchAction.search(this.getDestinationStorage(), null, TraverserFactory.createListAllTraverser());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void makeDirs(String path, boolean create) throws Exception {
        File dirs = new File(path);
        if (!dirs.exists()) {
            if (!create) throw new Exception("Directory does not exist and create is false");
            dirs.mkdirs();
            return;
        } else {
            if (dirs.isDirectory()) return;
            throw new Exception("Specified path is not a directory");
        }
    }

    protected IArtifact[] addSystemArtifacts(IArtifact[] artifacts) {
        ArrayList<IArtifact> list = new ArrayList<IArtifact>();
        for (int i = 0; i < artifacts.length; ++i) {
            list.add(artifacts[i]);
        }
        list.add(this.m_properties);
        return list.toArray(new IArtifact[list.size()]);
    }
}

