/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.tools.common;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.artifact.ArtifactFactory;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.artifact.SystemArtifact;
import com.sonicsw.deploy.util.FileUtils;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExportPropertiesArtifact
extends SystemArtifact {
    public static final String FILE_NAME = "ExportProperties.xml";
    public static final String DEFAULT_DOMAIN = "Domain1";
    public static final String DEFAULT_URL = "tcp://localhost:2506";
    public static final String DEFAULT_USER = "Administrator";
    public static final String DEFAULT_PASSWORD = "Administrator";
    public static final IArtifact[] NO_IGNORES = new IArtifact[0];
    public static final IArtifact[] DEFAULT_IGNORE = new IArtifact[]{new ESBArtifact(ESBArtifact.CONNECTION_TYPE, "JMSType"), new ESBArtifact(ESBArtifact.CONNECTION, "http_defaultConnection"), new ESBArtifact(ESBArtifact.CONNECTION, "jms_defaultConnection"), new ESBArtifact(ESBArtifact.ENDPOINT_TYPE, "JMSType"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.Exit"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.Fault"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.RME"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.Tracking"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.MessageListener"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.Run.Entry"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.ClientProxy.Entry"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.Prototype.Entry"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.CacheService.Entry"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.Dispatch.Entry"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.CBR.Entry"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.Transform.Entry"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.DBService.Entry"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.XMLServer.Entry"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.SplitJoinForEach.Entry"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.SplitJoinParallel.Entry"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.Pickup.Entry"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.Drop.Entry"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.Splitter.Entry"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.WMQJMSSender.Entry"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.WMQJMSSender.Fault"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.WMQJMSSender.Exit"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.WMQJMSSender.RME"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.WMQJMSListener.Entry"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.WMQJMSListener.Fault"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.WMQJMSListener.Exit"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.WMQJMSListener.RME"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.MqttSubscriberService.Exit"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.MqttPublisherService.Entry"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "BPEType"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "CBRType"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "XFORMType"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "DispatchServiceType"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "DatabaseServiceType"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "WSInvocationComponentType"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "ESBRunServiceType"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "DebugServiceInterceptorType"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "DebugInternalStepInterceptorType"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "PickupService"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "DropService"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "SonicConnect"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "SplitterService"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "SplitJoinForEach"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "SplitJoinParallel"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "XMLServiceType"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "BPELServiceType"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "AsynchServiceType"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "PrototypeService"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "SOAPUnwrapComponentType"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "TerminateStepServiceType"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "WMQJMSSender"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "WMQJMSListener"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "MqttPublisherServiceType"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "MqttSubscriberServiceType"), new ESBArtifact(ESBArtifact.PROCESS, "dev.nullProcess"), new ESBArtifact(ESBArtifact.SERVICE, "TerminateStepService"), new ESBArtifact(ESBArtifact.SERVICE, "AsynchService"), new ESBArtifact(ESBArtifact.SERVICE, "SOAPUnwrapComponent"), new ESBArtifact(ESBArtifact.SERVICE, "WSInvocationComponent"), new ESBArtifact(ESBArtifact.SERVICE, "DebugServiceInterceptor"), new ESBArtifact(ESBArtifact.SERVICE, "DebugInternalStepInterceptor"), new ESBArtifact(ESBArtifact.SERVICE, "dev.CBR"), new ESBArtifact(ESBArtifact.SERVICE, "dev.CacheService"), new ESBArtifact(ESBArtifact.SERVICE, "dev.DBService"), new ESBArtifact(ESBArtifact.SERVICE, "dev.Run"), new ESBArtifact(ESBArtifact.SERVICE, "dev.ClientProxy"), new ESBArtifact(ESBArtifact.SERVICE, "dev.Prototype"), new ESBArtifact(ESBArtifact.SERVICE, "dev.Transform"), new ESBArtifact(ESBArtifact.SERVICE, "dev.Dispatch"), new ESBArtifact(ESBArtifact.SERVICE, "dev.XMLServer"), new ESBArtifact(ESBArtifact.SERVICE, "dev.FilePickup"), new ESBArtifact(ESBArtifact.SERVICE, "dev.FileDrop"), new ESBArtifact(ESBArtifact.SERVICE, "dev.Splitter"), new ESBArtifact(ESBArtifact.SERVICE, "dev.SJForEach"), new ESBArtifact(ESBArtifact.SERVICE, "dev.SJParallel"), new ESBArtifact(ESBArtifact.SERVICE, "dev.WMQJMSSender"), new ESBArtifact(ESBArtifact.SERVICE, "dev.WMQJMSListener"), new ESBArtifact(ESBArtifact.SERVICE, "dev.MqttSubscriberService"), new ESBArtifact(ESBArtifact.SERVICE, "dev.MqttPublisherService"), new ESBArtifact(ESBArtifact.SERVICE_TYPE, "OpenEdgeSrvType2"), new ESBArtifact(ESBArtifact.SERVICE, "dev.OpenEdge"), new ESBArtifact(ESBArtifact.ENDPOINT, "dev.OpenEdge.Entry"), new SonicFSArtifact("/Archives/"), new SonicFSArtifact("/System/"), new SonicFSArtifact("/Security/DefaultAuditDestinations.xml")};
    private String m_domain = "Domain1";
    private String m_url = "tcp://localhost:2506";
    private String m_user = "Administrator";
    private String m_password = "Administrator";
    private String m_notes = null;
    private boolean m_readOnly = false;
    private ArrayList<IArtifact> m_ignore = new ArrayList();
    private ArrayList<IArtifact> m_roots = new ArrayList();

    public static IArtifact[] getDefaultIgnore() {
        return (IArtifact[])DEFAULT_IGNORE.clone();
    }

    public ExportPropertiesArtifact() {
        this(false);
    }

    public ExportPropertiesArtifact(boolean readOnly) {
        super(FILE_NAME);
        this.defaultIgnoreList();
        this.m_readOnly = readOnly;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public void setDomain(String domain) {
        this.m_domain = domain;
    }

    public String getURL() {
        return this.m_url;
    }

    public void setURL(String url) {
        this.m_url = url;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public String getNotes() {
        return this.m_notes;
    }

    public void setNotes(String notes) {
        this.m_notes = notes;
    }

    public IArtifact[] getIgnoreList() {
        return this.m_ignore.toArray(new IArtifact[0]);
    }

    public final void defaultIgnoreList() {
        this.clearIgnoreList();
        this.addIgnore(DEFAULT_IGNORE);
    }

    public void clearIgnoreList() {
        this.m_ignore.clear();
    }

    public void addIgnore(IArtifact artifact) {
        if (!this.m_ignore.contains(artifact)) {
            this.m_ignore.add(artifact);
        }
    }

    public void addIgnore(IArtifact[] artifact) {
        for (int i = 0; i < artifact.length; ++i) {
            this.addIgnore(artifact[i]);
        }
    }

    public IArtifact[] getRootList() {
        return this.m_roots.toArray(new IArtifact[0]);
    }

    public void clearRootList() {
        this.m_roots.clear();
    }

    public void defaultRootList() {
        this.clearRootList();
    }

    public void addRoot(IArtifact artifact) {
        if (!this.m_roots.contains(artifact)) {
            this.m_roots.add(artifact);
        }
    }

    public void addRoot(IArtifact[] artifact) {
        for (int i = 0; i < artifact.length; ++i) {
            this.addRoot(artifact[i]);
        }
    }

    public void deleteRoot(IArtifact artifact) {
        this.m_roots.remove(artifact);
    }

    public void deleteRoot(IArtifact[] artifact) {
        for (int i = 0; i < artifact.length; ++i) {
            this.deleteRoot(artifact[i]);
        }
    }

    public void init(byte[] content) throws Exception {
        String notes;
        Document document = DOMUtils.getDocument((byte[])content);
        this.defaultIgnoreList();
        this.defaultRootList();
        Element element = document.getDocumentElement();
        Element source = DOMUtils.getElementByTagName((Element)element, (String)"source");
        if (source != null) {
            this.setDomain(DOMUtils.getFirstTextValueOfChild((Element)source, (String)"domain"));
            this.setURL(DOMUtils.getFirstTextValueOfChild((Element)source, (String)"url"));
            this.setUser(DOMUtils.getFirstTextValueOfChild((Element)source, (String)"user"));
        }
        if ((notes = DOMUtils.getFirstTextChildOfChildElementByName((Element)element, (String)"notes")) != null) {
            this.setNotes(notes);
        }
        this.elementToArtifact(DOMUtils.getElementByTagName((Element)element, (String)"ignore"), this.m_ignore);
        this.elementToArtifact(DOMUtils.getElementByTagName((Element)element, (String)"roots"), this.m_roots);
    }

    public void init(File file) throws Exception {
        this.init(FileUtils.readFile(file));
    }

    @Override
    public byte[] getContent() {
        try {
            return this.toXML().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String toXML() {
        IArtifact artifact;
        int i;
        StringBuilder buffer = new StringBuilder();
        buffer.append("<?xml version=\"1.0\" ?>\r\n");
        buffer.append("<export>\r\n");
        buffer.append("    <source>\r\n");
        buffer.append("        <domain>" + this.m_domain + "</domain>\r\n");
        buffer.append("        <url>" + this.m_url + "</url>\r\n");
        buffer.append("        <user>" + this.m_user + "</user>\r\n");
        buffer.append("    </source>\r\n");
        buffer.append("    <ignore>\r\n");
        for (i = 0; i < this.m_ignore.size(); ++i) {
            artifact = this.m_ignore.get(i);
            buffer.append("        <artifact type=\"");
            buffer.append(artifact.getDisplayType());
            buffer.append("\" path=\"");
            buffer.append(artifact.getPath());
            buffer.append("\"/>\r\n");
        }
        buffer.append("    </ignore>\r\n");
        buffer.append("    <roots>\r\n");
        for (i = 0; i < this.m_roots.size(); ++i) {
            artifact = this.m_roots.get(i);
            buffer.append("        <artifact type=\"");
            buffer.append(artifact.getDisplayType());
            buffer.append("\" path=\"");
            buffer.append(artifact.getPath());
            buffer.append("\"/>\r\n");
        }
        buffer.append("    </roots>\r\n");
        buffer.append("    <notes>");
        if (this.m_notes != null && this.m_notes.length() > 0) {
            buffer.append(this.m_notes);
        }
        buffer.append("</notes>\r\n");
        buffer.append("</export>\r\n");
        return buffer.toString();
    }

    private void elementToArtifact(Element element, ArrayList<IArtifact> list) {
        if (element == null) {
            return;
        }
        list.clear();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"artifact".equals(node.getLocalName())) continue;
            String type = ((Element)node).getAttribute("type");
            String path = ((Element)node).getAttribute("path");
            if (type == null || path == null) continue;
            list.add(ArtifactFactory.createArtifact(type, path));
        }
    }

    public void debugDump() {
        int i;
        System.out.println("Source");
        System.out.println("    Domain = " + this.m_domain);
        System.out.println("    URL    = " + this.m_url);
        System.out.println("    User   = " + this.m_user);
        System.out.println("Ignore List");
        for (i = 0; i < this.m_ignore.size(); ++i) {
            System.out.println("    " + this.m_ignore.get(i));
        }
        System.out.println("Root Element List");
        for (i = 0; i < this.m_roots.size(); ++i) {
            System.out.println("    " + this.m_roots.get(i));
        }
    }
}

