/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.artifact.ArtifactFactory;
import com.sonicsw.deploy.traversal.AbstractESBTraverser;
import com.sonicsw.deploy.traversal.ESBTraverserFactory;
import com.sonicsw.xqimpl.util.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ESBContainerTraverser
extends AbstractESBTraverser {
    public static String containerAnnotationTypePath = "/Resources/SonicESB/Annotations/container/";

    public ESBContainerTraverser(IArtifact artifact) {
        super(artifact);
    }

    @Override
    public void doTraversal(IArtifactTraversalContext context) throws Exception {
        String log4jConfig;
        String springConfig;
        String classpath;
        Document doc = context.getStorage().getContentsAsDom(this.m_artifact);
        Element element = doc.getDocumentElement();
        Element services = DOMUtils.getImmediateChildElementByName((Element)element, (String)"services");
        NodeList nl = services.getElementsByTagNameNS("http://www.sonicsw.com/sonicxq", "serviceApplication");
        for (int i = 0; i < nl.getLength(); ++i) {
            String name = ((Element)nl.item(i)).getAttribute("name");
            ESBTraverserFactory.createServiceTraverser(name).traverse(context);
        }
        String connection = element.getAttribute("RoutingHttpConnection");
        if (connection != null && connection.length() > 0) {
            ESBTraverserFactory.createConnectionTraverser(connection).traverse(context);
        }
        if ((connection = element.getAttribute("BusConnection")) != null && connection.length() > 0) {
            ESBTraverserFactory.createConnectionTraverser(connection).traverse(context);
        }
        if ((classpath = element.getAttribute("CLASSPATH")) != null && classpath.length() > 0) {
            this.traverseURLRefs(classpath, context);
        }
        if ((springConfig = element.getAttribute("springConfiguration")) != null && springConfig.length() > 0) {
            this.traverseURLRefs(springConfig, context);
        }
        if ((log4jConfig = element.getAttribute("log4jConfiguration")) != null && log4jConfig.length() > 0) {
            this.traverseURLRefs(log4jConfig, context);
        }
        String annotatioFilePath = containerAnnotationTypePath + this.m_artifact.getName() + "." + "annotation";
        IArtifact annotationArtifact = ArtifactFactory.createArtifact("SonicFS", annotatioFilePath);
        if (context.getStorage().exists(annotationArtifact)) {
            context.addTraversed(annotationArtifact, false);
        }
    }
}

