/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.traversal.AbstractESBTraverser;
import com.sonicsw.deploy.traversal.ESBTraverserFactory;
import com.sonicsw.xqimpl.util.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ESBEndpointTraverser
extends AbstractESBTraverser {
    public ESBEndpointTraverser(IArtifact artifact) {
        super(artifact);
    }

    @Override
    public void doTraversal(IArtifactTraversalContext context) throws Exception {
        Document doc = context.getStorage().getContentsAsDom(this.m_artifact);
        Element element = doc.getDocumentElement();
        String endpointType = element.getAttribute("type_ref");
        ESBTraverserFactory.createEndpointTypeTraverser(endpointType).traverse(context);
        String connectionType = element.getAttribute("connection_ref");
        ESBTraverserFactory.createConnectionTraverser(connectionType).traverse(context);
        String wsdl = DOMUtils.getFirstTextChildOfChildElementByName((Element)element, (String)"wsdlUrl");
        if (wsdl != null && wsdl.length() > 0) {
            this.traverseURLRefs(wsdl, context);
        }
    }
}

