/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.artifact.ArtifactFactory;
import com.sonicsw.deploy.traversal.AbstractESBTraverser;
import com.sonicsw.xqimpl.util.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ESBServiceTypeTraverser
extends AbstractESBTraverser {
    public static String serviceTypesSystemPath = "/System/SonicESB/properties/serviceTypes/";

    public ESBServiceTypeTraverser(IArtifact artifact) {
        super(artifact);
    }

    @Override
    public void doTraversal(IArtifactTraversalContext context) throws Exception {
        Document doc = context.getStorage().getContentsAsDom(this.m_artifact);
        Element element = doc.getDocumentElement();
        Element clsLoading = DOMUtils.getImmediateChildElementByName((Element)element, (String)"classLoading");
        this.traverseClassLoading(context, clsLoading, "serviceInstance");
        this.traverseClassLoading(context, clsLoading, "serviceType");
        this.traverseClassLoading(context, clsLoading, "xqContainer");
        IArtifactStorage store = context.getStorage();
        String sysPath = serviceTypesSystemPath + this.m_artifact.getName();
        IArtifact extraArtifact = ArtifactFactory.createArtifact("SonicFS", sysPath + ".gif");
        if (store.exists(extraArtifact)) {
            context.addTraversed(extraArtifact, false);
        }
        if (store.exists(extraArtifact = ArtifactFactory.createArtifact("SonicFS", sysPath + "24x24.gif"))) {
            context.addTraversed(extraArtifact, false);
        }
        if (store.exists(extraArtifact = ArtifactFactory.createArtifact("SonicFS", sysPath + ".properties"))) {
            context.addTraversed(extraArtifact, false);
        }
        if (store.exists(extraArtifact = ArtifactFactory.createArtifact("SonicFS", sysPath + "Interface.xml"))) {
            context.addTraversed(extraArtifact, false);
        }
    }
}

