/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.traversal.AbstractExtnTraverser;
import com.sonicsw.deploy.traversal.ESBEndpointTraverser;
import com.sonicsw.deploy.traversal.ESBProcessTraverser;
import com.sonicsw.deploy.traversal.ESBServiceTraverser;
import com.sonicsw.xqimpl.util.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExtnXPRJBPTraverser
extends AbstractExtnTraverser {
    public static final String EXTN_BP = "bp";

    public ExtnXPRJBPTraverser(IArtifact artifact) {
        super(artifact);
    }

    public static boolean isValidExtension(String extension) {
        return EXTN_BP.equalsIgnoreCase(extension);
    }

    @Override
    public void doTraversal(IArtifactTraversalContext context) throws Exception {
        Document doc = context.getStorage().getContentsAsDom(this.m_artifact);
        Element element = doc.getDocumentElement();
        this.handleESBNodes(context, element.getElementsByTagName("initiated-collaboration"));
        this.handleESBNodes(context, element.getElementsByTagName("provided-collaboration"));
    }

    private void handleESBNodes(IArtifactTraversalContext context, NodeList children) throws Exception {
        for (int i = 0; i < children.getLength(); ++i) {
            int index;
            String attrib;
            Element esbStatic;
            Element esb = DOMUtils.getImmediateChildElementByName((Element)((Element)children.item(i)), (String)"esb");
            if (esb == null || (esbStatic = DOMUtils.getImmediateChildElementByName((Element)esb, (String)"esb-static-binding")) == null || (attrib = esbStatic.getAttribute("esb-address")) == null || attrib.length() <= 0 || (index = attrib.lastIndexOf(58)) == -1) continue;
            String type = attrib.substring(index + 1);
            String name = attrib.substring(0, index);
            if ("service".equalsIgnoreCase(type)) {
                new ESBServiceTraverser(new ESBArtifact(ESBArtifact.SERVICE, name)).traverse(context);
                continue;
            }
            if ("process".equalsIgnoreCase(type)) {
                new ESBProcessTraverser(new ESBArtifact(ESBArtifact.PROCESS, name)).traverse(context);
                continue;
            }
            if ("endpoint".equalsIgnoreCase(type)) {
                new ESBEndpointTraverser(new ESBArtifact(ESBArtifact.ENDPOINT, name)).traverse(context);
                continue;
            }
            throw new Exception("Failed to create ESB traverser for " + attrib);
        }
    }
}

