/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraverser;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.artifact.ZipFileArtifact;
import com.sonicsw.deploy.traversal.SonicFSListTraverser;
import com.sonicsw.deploy.traversal.SonicFSTraverser;
import com.sonicsw.deploy.traversal.ZipContentTraverser;

public class SonicFSTraverserFactory {
    public static IArtifactTraverser createTraverser(IArtifact artifact) throws Exception {
        if (!(artifact instanceof SonicFSArtifact)) {
            throw new Exception("Invalid artifact type for traverser");
        }
        if (ZipFileArtifact.isArchiveFile(artifact.getName())) {
            return new ZipContentTraverser(artifact);
        }
        if (artifact.isRootPath() || artifact.isDirectory()) {
            return new SonicFSListTraverser(artifact);
        }
        return new SonicFSTraverser(artifact);
    }

    public static IArtifactTraverser createTraverser(String path) throws Exception {
        return new SonicFSTraverser(new SonicFSArtifact(path));
    }
}

