/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.traversal;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactTraverser;
import com.sonicsw.deploy.artifact.ConfigBeanArtifact;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.artifact.RootArtifact;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.artifact.ZipFileArtifact;
import com.sonicsw.deploy.traversal.ConfigBeanTraverserFactory;
import com.sonicsw.deploy.traversal.ESBTraverserFactory;
import com.sonicsw.deploy.traversal.ListAllTraverser;
import com.sonicsw.deploy.traversal.SonicFSTraverserFactory;
import com.sonicsw.deploy.traversal.ZipTraverserFactory;

public final class TraverserFactory {
    public static IArtifactTraverser createListAllTraverser() {
        return new ListAllTraverser(RootArtifact.ROOT, true);
    }

    public static IArtifactTraverser createTraverser(IArtifact artifact) throws Exception {
        if (artifact == null) {
            throw new Exception("createTraverser(null) is not valid");
        }
        if (artifact instanceof RootArtifact) {
            return new ListAllTraverser(RootArtifact.ROOT, false);
        }
        if (artifact instanceof ESBArtifact) {
            return TraverserFactory.createESBTraverser(artifact);
        }
        if (artifact instanceof ZipFileArtifact) {
            return TraverserFactory.createZipTraverser(artifact);
        }
        if (artifact instanceof SonicFSArtifact) {
            return TraverserFactory.createSonicFSTraverser(artifact);
        }
        if (artifact instanceof ConfigBeanArtifact) {
            return TraverserFactory.createConfigBeanTraverser(artifact);
        }
        throw new UnsupportedOperationException("Not yet implemeneted");
    }

    public static IArtifactTraverser createESBTraverser(IArtifact artifact) throws Exception {
        return ESBTraverserFactory.createTraverser(artifact);
    }

    public static IArtifactTraverser createSonicFSTraverser(IArtifact artifact) throws Exception {
        return SonicFSTraverserFactory.createTraverser(artifact);
    }

    public static IArtifactTraverser createConfigBeanTraverser(IArtifact artifact) throws Exception {
        return ConfigBeanTraverserFactory.createTraverser(artifact);
    }

    private static IArtifactTraverser createZipTraverser(IArtifact artifact) {
        return ZipTraverserFactory.createTraverser(artifact);
    }
}

