/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertyUtils {
    private static final String S_FILENAME = "deploy.properties";
    private static PropertyUtils m_instance;
    private Properties m_properties = new Properties();

    public static final synchronized PropertyUtils getInstance() {
        if (m_instance == null) {
            m_instance = new PropertyUtils();
        }
        return m_instance;
    }

    private PropertyUtils() {
        this.readProperties();
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defVal) {
        return this.m_properties.getProperty(key, defVal);
    }

    public void setProperty(String key, String value) {
        this.m_properties.setProperty(key, value);
    }

    public boolean getBooleanProperty(String key, boolean defVal) {
        String val = this.m_properties.getProperty(key, null);
        if (val != null) {
            return Boolean.valueOf(val);
        }
        return defVal;
    }

    public List<String> tokenizeToLower(String value) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken().trim().toLowerCase());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProperties() {
        InputStream is = null;
        try {
            File file;
            String xqHome = System.getProperty("sonicsw.home", null);
            if (xqHome == null) {
                xqHome = System.getProperty("com.sonicsw.xq.home", null);
            }
            if (xqHome != null && (file = new File(xqHome, S_FILENAME)).exists()) {
                is = new FileInputStream(file);
            }
            if (is == null) {
                is = ClassLoader.getSystemResourceAsStream(S_FILENAME);
            }
            if (is != null) {
                this.m_properties.load(is);
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

