/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.util;

import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExIterator {
    private final String content;
    private final Matcher matcher;
    private final boolean includeLiterals;
    private int ix;
    private String lastToken;
    private boolean wasVariable;

    public RegExIterator(Pattern pattern, String content) {
        this(pattern, content, true);
    }

    public RegExIterator(Pattern pattern, String content, boolean includeLiterals) {
        this.content = content != null ? content : "";
        this.matcher = pattern.matcher(this.content);
        this.includeLiterals = includeLiterals;
    }

    public boolean hasNext() {
        if (this.includeLiterals) {
            return this.ix < this.content.length();
        }
        return this.matcher.find(this.ix);
    }

    public Object next() {
        if (this.matcher.find(this.ix)) {
            if (this.ix == this.matcher.start()) {
                this.ix = this.matcher.end();
                this.lastToken = this.matcher.group();
                this.wasVariable = true;
            } else {
                int start = this.ix;
                this.ix = this.matcher.start();
                this.lastToken = this.content.substring(start, this.ix);
                this.wasVariable = false;
            }
        } else if (this.ix < this.content.length()) {
            String result = this.content.substring(this.ix);
            this.ix = this.content.length();
            this.lastToken = result;
            this.wasVariable = false;
        } else {
            throw new NoSuchElementException();
        }
        if (this.includeLiterals || this.wasVariable) {
            return this.lastToken;
        }
        return this.next();
    }

    public boolean wasLastTokenVariable() {
        return this.wasVariable;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

