/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.envelope;

import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressFactory;
import com.sonicsw.xq.XQCloneable;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQEnvelopeFactory;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xqimpl.envelope.Envelope;

public class EnvelopeFactory
implements XQEnvelopeFactory,
XQCloneable {
    private XQEnvelope m_defaultEnvelope = new Envelope();
    private XQEnvelope m_faultEnvelope = null;
    private XQEnvelope m_selfEnvelope = null;
    private XQAddress m_faultAddress = null;
    private XQAddress m_selfAddress = null;
    private XQAddressFactory m_addressFactory = null;

    public void init(XQAddressFactory addressFactory) {
        this.m_addressFactory = addressFactory;
    }

    public void setFaultAddress(XQAddress address) {
        this.m_faultAddress = address;
        if (this.m_faultEnvelope == null) {
            this.m_faultEnvelope = new Envelope();
        }
        this.m_faultEnvelope.clearAddresses();
        this.m_faultEnvelope.addAddress(address);
    }

    public XQAddress getFaultAddress() {
        return this.m_faultAddress;
    }

    public XQEnvelope getDefaultEnvelope() {
        return this.m_defaultEnvelope;
    }

    public void clearOutputAddresses() {
        this.m_defaultEnvelope.clearAddresses();
    }

    public void addOutputAddress(XQAddress address) {
        this.m_defaultEnvelope.addAddress(address);
    }

    public XQEnvelope createDefaultEnvelope() {
        return (XQEnvelope)this.m_defaultEnvelope.clone();
    }

    public XQEnvelope createDefaultEnvelope(XQMessage message) {
        XQEnvelope ret = (XQEnvelope)this.m_defaultEnvelope.clone();
        ret.setMessage(message);
        return ret;
    }

    public XQEnvelope createFaultEnvelope() {
        if (this.m_faultEnvelope == null) {
            this.m_faultEnvelope = new Envelope();
        }
        return (XQEnvelope)this.m_faultEnvelope.clone();
    }

    public XQEnvelope createFaultEnvelope(XQMessage message) {
        XQEnvelope ret = this.createFaultEnvelope();
        ret.setMessage(message);
        return ret;
    }

    public XQEnvelope createTargetedEnvelope(XQAddress address) {
        Envelope envelope = new Envelope();
        envelope.addAddress(address);
        return envelope;
    }

    public XQEnvelope createTargetedEnvelope(XQAddress address, XQMessage message) {
        XQEnvelope envelope = this.createTargetedEnvelope(address);
        envelope.setMessage(message);
        return envelope;
    }

    public XQEnvelope createSelfAddressedEnvelope() {
        if (this.m_addressFactory == null) {
            return null;
        }
        this.setSelfAddressOnEnvelope();
        return this.m_selfEnvelope;
    }

    public XQEnvelope createSelfAddressedEnvelope(XQMessage message) {
        if (this.m_addressFactory == null) {
            return null;
        }
        this.setSelfAddressOnEnvelope();
        this.m_selfEnvelope.setMessage(message);
        return this.m_selfEnvelope;
    }

    public Object clone() {
        try {
            EnvelopeFactory newFactory = (EnvelopeFactory)super.clone();
            newFactory.m_defaultEnvelope = (Envelope)this.m_defaultEnvelope.clone();
            if (newFactory.m_faultEnvelope != null) {
                newFactory.m_faultEnvelope = (Envelope)this.m_faultEnvelope.clone();
            }
            return newFactory;
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
    }

    private void setSelfAddressOnEnvelope() {
        this.m_selfAddress = this.m_addressFactory.getSelfAddress();
        if (this.m_selfEnvelope == null) {
            this.m_selfEnvelope = new Envelope();
        }
        this.m_selfEnvelope.clearAddresses();
        this.m_selfEnvelope.addAddress(this.m_selfAddress);
    }
}

