/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.envelope;

import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressNotFoundException;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.envelope.AbstractAddressImpl;
import java.util.Iterator;
import java.util.Set;

public class ProcessAddressImpl
extends AbstractAddressImpl {
    public ProcessAddressImpl(String processName) throws XQAddressNotFoundException {
        this(processName, XQQualityofService.BEST_EFFORT);
    }

    public ProcessAddressImpl(String processName, XQQualityofService qos) throws XQAddressNotFoundException {
        super(processName, qos, null);
    }

    @Override
    protected void init(String processName) throws XQAddressNotFoundException {
        try {
            XQConfigManager configManager = XQConfigManager.getInstance(null);
            XQProcessConfig pCfg = configManager.lookupProcessConfig(processName);
            this.m_process = (XQProcessConfig)pCfg.clone();
            this.m_config = this.m_process;
            this.m_trackingDetails = this.m_process.getTrackingDetails();
        }
        catch (Exception e) {
            throw new XQAddressNotFoundException("Cannot create Process Address for " + processName, e);
        }
    }

    @Override
    protected String getStepType() {
        return "PROCESS";
    }

    @Override
    protected String getSingleStepName() {
        return null;
    }

    @Override
    protected XQAddress getStepFaultEndpoint() {
        return this.m_process.getFaultEndpoint();
    }

    @Override
    protected Set<XQAddress> getStepExitEndpoints() {
        return this.m_process.getExitEndpoints();
    }

    @Override
    protected XQAddress getStepRejectedMessageEndpoint() {
        return this.m_process.getRejectedMessageEndpoint();
    }

    @Override
    public Iterator<XQAddress> getExitEndpoints() {
        if (this.m_exitEndpoints == null) {
            return null;
        }
        return this.m_exitEndpoints.iterator();
    }
}

