/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.envelope;

import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressNotFoundException;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQServiceConfig;
import com.sonicsw.xqimpl.envelope.AbstractAddressImpl;
import java.util.Set;

public class ServiceAddressImpl
extends AbstractAddressImpl {
    private XQServiceConfig m_serviceConfig;

    public ServiceAddressImpl(String serviceName) throws XQAddressNotFoundException {
        this(serviceName, XQQualityofService.BEST_EFFORT);
    }

    public ServiceAddressImpl(String serviceName, XQQualityofService qos) throws XQAddressNotFoundException {
        super(serviceName, qos);
    }

    @Override
    protected void init(String serviceName) throws XQAddressNotFoundException {
        try {
            XQConfigManager configManager = XQConfigManager.getInstance(null);
            this.m_serviceConfig = configManager.lookupServiceConfig(serviceName);
        }
        catch (Exception e) {
            throw new XQAddressNotFoundException("Cannot create Service Address for " + serviceName, e);
        }
    }

    @Override
    protected String getSingleStepName() {
        return null;
    }

    @Override
    protected String getStepType() {
        return "SERVICE";
    }

    @Override
    protected XQAddress getStepFaultEndpoint() {
        return this.m_serviceConfig.getFaultEndpoint();
    }

    @Override
    protected Set<XQAddress> getStepExitEndpoints() {
        return this.m_serviceConfig.getExitEndpoints();
    }

    @Override
    protected XQAddress getStepRejectedMessageEndpoint() {
        return this.m_serviceConfig.getRejectedMessageEndpoint();
    }
}

