/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.install.config;

import com.sonicsw.xqimpl.util.ClassUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Vector;

public class ScriptWriter {
    private Process m_process;
    private ScriptListener m_listener;
    private String m_cmd;
    private String[] m_filter;
    private OutputReaderThread m_stdoutReader;
    private OutputStream m_stdinWriter;
    private Vector m_exportCommands = new Vector();
    private Vector m_importCommands = new Vector();
    private boolean m_bExecuting = true;
    private String m_migrationScriptsPath;
    private boolean m_isOverride;

    public ScriptWriter(String cmd, String[] filter, ScriptListener listener, String migrationScriptsPath, boolean override) throws Exception {
        this.m_cmd = cmd;
        this.m_filter = (String[])ClassUtils.arrayCopy((Object[])filter);
        this.m_listener = listener;
        this.m_migrationScriptsPath = migrationScriptsPath;
        this.m_isOverride = override;
    }

    public void launchScript() throws Exception {
        this.m_process = Runtime.getRuntime().exec(new String[]{this.m_cmd});
        this.m_stdoutReader = new OutputReaderThread(this.m_process.getInputStream());
        this.m_stdinWriter = this.m_process.getOutputStream();
        this.m_stdoutReader.start();
    }

    public void waitForExitCode() throws Exception {
        int exitCode = this.m_process.waitFor();
        this.m_bExecuting = false;
        if (exitCode != 0) {
            throw new Exception("Exit status: " + exitCode);
        }
    }

    public void writeToStdin(String[] commands) {
        for (int i = 0; i < commands.length; ++i) {
            this.writeToStdin(commands[i]);
        }
    }

    public void writeToStdin(String input) {
        if (!this.m_bExecuting) {
            return;
        }
        try {
            this.m_stdinWriter.write(input.getBytes());
            this.m_stdinWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean validate(String name) {
        if (this.m_filter == null) {
            return true;
        }
        if (name.startsWith("XQAdmin>")) {
            return false;
        }
        for (int i = 0; i < this.m_filter.length; ++i) {
            if (!name.equals(this.m_filter[i])) continue;
            return false;
        }
        return true;
    }

    public Vector getExportScriptCommands() {
        return this.m_exportCommands;
    }

    public Vector getImportScriptCommands() {
        return this.m_importCommands;
    }

    public void killProcess() {
        this.m_process.destroy();
    }

    public void close() {
        try {
            this.m_stdinWriter.close();
            this.m_stdoutReader.stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_stdoutReader = null;
        this.m_process = null;
    }

    class OutputReaderThread
    extends Thread {
        protected InputStream stream;

        OutputReaderThread(InputStream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.stream));
            boolean result = false;
            String type = null;
            while (ScriptWriter.this.m_bExecuting) {
                try {
                    String input = reader.readLine();
                    if (input == null) continue;
                    if (input.indexOf("*Error*") != -1 || input.indexOf("Error:") != -1 || input.indexOf("Cannot connect") != -1 || input.indexOf("*Failed*") != -1) {
                        ScriptWriter.this.m_listener.onOutput("*Error*: " + input.trim());
                        break;
                    }
                    ScriptWriter.this.m_listener.onOutput(input.trim());
                    int index = input.indexOf(61);
                    if (index != -1) {
                        result = false;
                        type = input.substring(index + 1).trim();
                        continue;
                    }
                    if (input.indexOf("Results...") != -1) {
                        result = true;
                        continue;
                    }
                    if (!result || !ScriptWriter.this.validate(input.trim())) continue;
                    String name = input.trim();
                    String path = ScriptWriter.this.m_migrationScriptsPath + File.separator + type + File.separator;
                    path = "file".equals(type) ? path + name : path + name + ".xml";
                    String command = "export " + type + " " + name + " " + "\"" + path + "\"";
                    ScriptWriter.this.m_exportCommands.add(command);
                    if ("file".equals(type)) {
                        command = "add " + type + " " + name + " " + "\"" + path + "\"";
                    } else if ("container".equals(type)) {
                        path = ScriptWriter.this.m_migrationScriptsPath + File.separator + "xq_container" + File.separator + name + ".xml";
                        command = "importnv xq_container \"" + path + "\"";
                    } else {
                        command = "importnv " + type + " " + "\"" + path + "\"";
                    }
                    if (ScriptWriter.this.m_isOverride) {
                        command = command + " override";
                    }
                    ScriptWriter.this.m_importCommands.add(command);
                }
                catch (Exception e) {
                    break;
                }
            }
        }
    }

    public static interface ScriptListener {
        public void onOutput(String var1);
    }
}

