/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.install.config;

import java.util.Hashtable;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import progress.message.jclient.Queue;

public final class StoreObject
extends InitialContext {
    public StoreObject(String domainName, String providerURL, String principal, String credentials, String idleTimeout) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sonicsw.jndi.mfcontext.MFContextFactory");
        if (domainName == null || domainName.length() == 0) {
            domainName = "Domain1";
        }
        env.put("com.sonicsw.jndi.mfcontext.domain", domainName);
        if (providerURL == null || providerURL.length() == 0) {
            providerURL = "tcp://localhost:2506";
        }
        env.put("java.naming.provider.url", providerURL);
        if (principal == null) {
            principal = "";
        }
        env.put("java.naming.security.principal", principal);
        if (credentials == null) {
            credentials = "";
        }
        env.put("java.naming.security.credentials", credentials);
        if (idleTimeout == null || idleTimeout.length() == 0) {
            idleTimeout = "6000";
        }
        env.put("com.sonicsw.jndi.mfcontext.idleTimeout", idleTimeout);
        this.init(env);
    }

    public StoreObject() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.fscontext.RefFSContextFactory");
        env.put("java.naming.provider.url", "file://localhost/C:/temp/jndi/fileStore/");
        this.init(env);
        System.out.println("I got my JNDI connection !");
    }

    public void store(String key, Object obj) throws NamingException {
        this.rebind(key, obj);
    }

    public String listAll(String contextName) throws NamingException {
        if (contextName == null) {
            contextName = "";
        }
        NamingEnumeration<NameClassPair> bindings = this.list(contextName);
        StringBuilder sb = new StringBuilder();
        while (bindings.hasMore()) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(((Object)bindings.next()).toString());
        }
        return sb.toString();
    }

    public void storeDestination(String qName) throws NamingException, JMSException {
        Queue queue = new Queue(qName);
        this.rebind(qName, (Object)queue);
    }

    public static void main(String[] args) {
        try {
            StoreObject store = new StoreObject(null, null, "Administrator", "Administrator", null);
            System.out.println("[root] \n" + store.listAll(""));
            Object obj = store.lookup("SC.POApprovalRPC");
            System.out.println("obj is " + obj.getClass().getName());
            if (obj instanceof javax.jms.Queue) {
                javax.jms.Queue q = (javax.jms.Queue)obj;
                System.out.println("q name is " + q.getQueueName());
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("Opps, something wrong. And the exception was...");
            e.printStackTrace();
        }
    }
}

