/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.tools.migration;

import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import com.sonicsw.mf.mgmtapi.runtime.ProxyRuntimeException;
import com.sonicsw.xqimpl.tools.migration.MigrationSuite;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Migrate {
    private static final String USAGE = "java com.sonicsw.xs.install.migration.Migrate <migration-suite-dir> <sonicxq-directory> <brokerURL> [<username> <password>]";
    private static final String OBJNAME = "Sonic.DIRECTORY SERVICE:ID=DIRECTORY SERVICE";
    private static boolean DEBUG = false;

    protected static JMSConnectorClient createConnector(String[] args) {
        boolean isSecure = args.length == 5;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("BrokerURL", args[2]);
        if (isSecure) {
            env.put("User", args[3]);
            env.put("Password", args[4]);
        }
        JMSConnectorClient connector = null;
        JMSConnectorAddress address = new JMSConnectorAddress(env);
        try {
            connector = new JMSConnectorClient();
            connector.connect(address);
        }
        catch (Exception e) {
            System.err.println("Failed to connect to Directory Service broker.  Please start the broker and rerun the offline migration script.");
            if (DEBUG) {
                e.printStackTrace();
            }
            System.exit(1);
        }
        try {
            connector.getAttribute(new ObjectName(OBJNAME), "State");
        }
        catch (Exception e) {
            System.err.println("Cannot get the state of the Directory Service.  Please start the directory service and broker, and rerun the offline migration script.");
            if (DEBUG) {
                e.printStackTrace();
            }
            System.exit(1);
        }
        return connector;
    }

    protected static DirectoryServiceProxy createProxy(JMSConnectorClient connector) {
        try {
            return new DirectoryServiceProxy((IRemoteMBeanServer)connector, new ObjectName(OBJNAME));
        }
        catch (MalformedObjectNameException e) {
            System.out.println("DirectoryServiceProxy error: " + e.getMessage());
            if (DEBUG) {
                e.printStackTrace();
            }
            System.exit(1);
            return null;
        }
    }

    public static void main(String[] args) {
        if (!Migrate.validateArgs(args)) {
            Migrate.printUsage();
            System.exit(1);
        }
        try {
            JMSConnectorClient connector = Migrate.createConnector(args);
            DirectoryServiceProxy proxy = Migrate.createProxy(connector);
            MigrationSuite suite = Migrate.createSuite(args);
            suite.migrate(proxy);
            connector.disconnect();
        }
        catch (Exception e) {
            System.err.println("Unexpected exception reported while running migration suite.");
            if (e instanceof ProxyRuntimeException) {
                ProxyRuntimeException pre = (ProxyRuntimeException)((Object)e);
                Exception target = pre.getTargetException();
                if (target != null) {
                    System.out.println("Error: " + target.getMessage());
                    if (DEBUG) {
                        target.printStackTrace();
                    }
                } else {
                    System.out.println("Error: " + pre.getMessage());
                    if (DEBUG) {
                        pre.printStackTrace();
                    }
                }
            } else {
                System.out.println("Error: " + e.getMessage());
                if (DEBUG) {
                    e.printStackTrace();
                }
            }
            System.exit(1);
        }
    }

    private static MigrationSuite createSuite(String[] args) throws ParserConfigurationException, IOException, SAXException {
        StringBuilder buffer = new StringBuilder("com/sonicsw/xqimpl/tools/migration/");
        String suiteDir = args[0];
        buffer.append(suiteDir).append("/");
        String resourcePath = buffer.toString();
        buffer.append("Suite.xml");
        String suiteResourceName = buffer.toString();
        InputStream suiteInput = ClassLoader.getSystemResourceAsStream(suiteResourceName);
        if (suiteInput == null) {
            throw new IllegalArgumentException("Suite " + suiteDir + " not found.");
        }
        String xqHome = args[1];
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return new MigrationSuite(builder.parse(suiteInput), suiteDir, resourcePath, xqHome);
    }

    private static boolean validateArgs(String[] args) {
        return args.length == 5 || args.length == 3;
    }

    private static void printUsage() {
        System.err.println(USAGE);
    }
}

