<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:mf="http://www.sonicsw.com/mf" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output indent="yes" method="xml"/>
	<xsl:param name="schemaLocation"/>
	<xsl:param name="currentTime"/>
	<xsl:param name="migrationName"/>
	<xsl:param name="suiteName"/>
	<xsl:template match="mf:Domain">
		<xsl:copy>
			<xsl:copy-of select="@name"/>
			<xsl:attribute name="xsi:schemaLocation"><xsl:value-of select="$schemaLocation"/></xsl:attribute>
			<xsl:element name="Directory" namespace="http://www.sonicsw.com/mf">
				<xsl:attribute name="name"><xsl:text>/</xsl:text></xsl:attribute>
				<xsl:element name="Directory" namespace="http://www.sonicsw.com/mf">
					<xsl:attribute name="name"><xsl:text>/xqMigrations</xsl:text></xsl:attribute>
					<xsl:element name="Directory" namespace="http://www.sonicsw.com/mf">
						<xsl:attribute name="name">/xqMigrations/<xsl:value-of select="$suiteName"/></xsl:attribute>
						<xsl:element name="ConfigElement" namespace="http://www.sonicsw.com/mf">
							<xsl:element name="ElementID" namespace="http://www.sonicsw.com/mf">
								<xsl:attribute name="version"><xsl:text>1</xsl:text></xsl:attribute>
								<xsl:attribute name="releaseVersion"><xsl:text>1.0</xsl:text></xsl:attribute>
								<xsl:attribute name="name">/xqMigrations/<xsl:value-of select="$suiteName"/>/<xsl:value-of select="$migrationName"/></xsl:attribute>
								<xsl:attribute name="creationTimestamp"><xsl:value-of select="$currentTime"/></xsl:attribute>
								<xsl:attribute name="type"><xsl:text>migration</xsl:text></xsl:attribute>
							</xsl:element>
							<xsl:element name="AttributeSet" namespace="http://www.sonicsw.com/mf">
								<xsl:element name="Attribute" namespace="http://www.sonicsw.com/mf">
									<xsl:attribute name="name"><xsl:text>completion</xsl:text></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="$currentTime"/></xsl:attribute>
									<xsl:attribute name="type"><xsl:text>long</xsl:text></xsl:attribute>
								</xsl:element>
							</xsl:element>
						</xsl:element>
					</xsl:element>
				</xsl:element>
				<xsl:apply-templates/>
			</xsl:element>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="mf:Directory">
		<xsl:call-template name="copy-with-attributes"/>
	</xsl:template>
	<xsl:template match="mf:ConfigElement">
		<xsl:call-template name="copy-with-attributes"/>
	</xsl:template>
	<xsl:template match="mf:ElementID">
		<xsl:call-template name="copy-with-attributes"/>
	</xsl:template>
	<xsl:template match="mf:AttributeSet">
		<xsl:choose>
			<xsl:when test="local-name(..)='ConfigElement'">
				<xsl:call-template name="copy-base-attributeset"/>
			</xsl:when>
			<xsl:when test="mf:AttributeName[@name='operations']">
				<xsl:call-template name="xform-operations"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="copy-with-attributes">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template name="copy-base-attributeset">
		<xsl:copy>
			<xsl:apply-templates select="mf:AttributeSet"/>
			<xsl:copy-of select="mf:Attribute[@name='name'] | mf:Attribute[@name='type']"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template name="xform-operations">
		<xsl:copy>
			<xsl:copy-of select="mf:AttributeName"/>
			<xsl:for-each select="mf:AttributeSet">
				<xsl:call-template name="xform-operation"/>
			</xsl:for-each>
		</xsl:copy>
	</xsl:template>
	<xsl:template name="xform-operation">
		<xsl:copy>
			<xsl:for-each select="mf:AttributeName">
				<xsl:call-template name="xform-attribute-name"/>
			</xsl:for-each>
			<xsl:for-each select="mf:AttributeSet">
				<xsl:call-template name="xform-input-output"/>
			</xsl:for-each>
			<xsl:for-each select="mf:AttributeList">
				<xsl:call-template name="xform-fault"/>
			</xsl:for-each>
			<xsl:for-each select="mf:Attribute[@name='operationType']">
				<xsl:call-template name="xform-operation-type"/>
			</xsl:for-each>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template name="xform-attribute-name">
		<xsl:copy-of select="."/>
		<xsl:element name="Attribute" namespace="http://www.sonicsw.com/mf">
			<xsl:attribute name="name"><xsl:text>name</xsl:text></xsl:attribute>
			<xsl:attribute name="type"><xsl:text>string</xsl:text></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@name"/></xsl:attribute>
		</xsl:element>
	</xsl:template>
	
	<xsl:template name="xform-input-output">
		<xsl:copy>
			<xsl:copy-of select="mf:AttributeName"/>
			<xsl:element name="AttributeList" namespace="http://www.sonicsw.com/mf">
				<xsl:element name="AttributeName" namespace="http://www.sonicsw.com/mf">
					<xsl:attribute name="name"><xsl:text>part_list</xsl:text></xsl:attribute>
				</xsl:element>
				<xsl:call-template name="xform-message"/>
			</xsl:element>
		</xsl:copy>
	</xsl:template>
	<xsl:template name="xform-message">
		<xsl:element name="AttributeSet" namespace="http://www.sonicsw.com/mf">
			<xsl:for-each select="mf:Attribute[@name='configName']">
				<xsl:call-template name="xform-config-name"/>
			</xsl:for-each>
			<xsl:for-each select="mf:Attribute[@name='messageName']">
				<xsl:call-template name="xform-message-name"/>
			</xsl:for-each>
		</xsl:element>
	</xsl:template>
	<xsl:template name="xform-fault">
		<xsl:copy>
			<xsl:copy-of select="mf:AttributeName"/>
			<xsl:for-each select="mf:AttributeSet">
				<xsl:call-template name="xform-message"/>
			</xsl:for-each>
		</xsl:copy>
	</xsl:template>
	<xsl:template name="xform-operation-type">
		<xsl:element name="Attribute" namespace="http://www.sonicsw.com/mf">
			<xsl:attribute name="name"><xsl:text>type</xsl:text></xsl:attribute>
			<xsl:attribute name="type"><xsl:text>string</xsl:text></xsl:attribute>
			<xsl:attribute name="value"><xsl:choose><xsl:when test="@value='2'"><xsl:text>requestResponse</xsl:text></xsl:when><xsl:otherwise><xsl:text>oneway</xsl:text></xsl:otherwise></xsl:choose></xsl:attribute>
		</xsl:element>
	</xsl:template>
	<xsl:template name="xform-config-name">
		<xsl:element name="Attribute" namespace="http://www.sonicsw.com/mf">
			<xsl:attribute name="name"><xsl:text>wsdlTypeName</xsl:text></xsl:attribute>
			<xsl:attribute name="type"><xsl:text>string</xsl:text></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
		</xsl:element>
	</xsl:template>
	<xsl:template name="xform-message-name">
		<xsl:element name="Attribute" namespace="http://www.sonicsw.com/mf">
			<xsl:attribute name="name"><xsl:text>declaredTypeName</xsl:text></xsl:attribute>
			<xsl:attribute name="type"><xsl:text>string</xsl:text></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
