<xsl:stylesheet version="2.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xq="http://www.sonicsw.com/sonicxq">
	<xsl:output method="xml" version="2.0" encoding="UTF-8" indent="yes" />	
	
	<!-- type becomes typeRef -->
	<xsl:template match="xq:ServiceMap/@type">
		<xsl:attribute name="typeRef">
			<xsl:value-of select="." />
		</xsl:attribute>
	</xsl:template>
		
	<xsl:template match="xq:EndpointMap/@type">
		<xsl:attribute name="typeRef">
			<xsl:value-of select="." />
		</xsl:attribute>
	</xsl:template>
		
	<xsl:template match="xq:ConnectionMap/@type">
		<xsl:attribute name="typeRef">
			<xsl:value-of select="." />
		</xsl:attribute>
	</xsl:template>
		
	<!-- Params become paramMap -->
	<xsl:template match="xq:Params">
		<xq:paramMap>
			<xsl:apply-templates />
		</xq:paramMap>
	</xsl:template>

	 
	<!-- Copy everything else -->
	<xsl:template match="node() | @*">
		<xsl:copy>
			<xsl:apply-templates select="@* | node()" />
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
