/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.deploy.tools.common;

import com.sonicsw.deploy.IArtifactNotificationEvent;
import com.sonicsw.deploy.IArtifactNotificationListener;
import com.sonicsw.deploy.IArtifactStorage;
import java.util.ArrayList;

public abstract class AbstractHandler
implements IArtifactNotificationListener {
    private IArtifactStorage m_source;
    private IArtifactStorage m_destination;
    private final ArrayList<IArtifactNotificationListener> m_listeners = new ArrayList();

    public void setSourceStorage(IArtifactStorage store) {
        this.m_source = this.retrieveArtifactStorage(this.m_source, store);
    }

    public IArtifactStorage getSourceStorage() {
        return this.m_source;
    }

    public void setDestinationStorage(IArtifactStorage store) {
        this.m_destination = this.retrieveArtifactStorage(this.m_destination, store);
    }

    private IArtifactStorage retrieveArtifactStorage(IArtifactStorage artifactStorageParam, IArtifactStorage store) {
        IArtifactStorage artifactStorage = artifactStorageParam;
        if (artifactStorage != null) {
            artifactStorage.removeNotificationListener(this);
        }
        if ((artifactStorage = store) != null) {
            artifactStorage.addNotificationListener(this);
        }
        return artifactStorage;
    }

    public IArtifactStorage getDestinationStorage() {
        return this.m_destination;
    }

    public void addNotificationListener(IArtifactNotificationListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeNotificationListener(IArtifactNotificationListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public void notifyMessage(IArtifactNotificationEvent event) {
        for (IArtifactNotificationListener listener : this.m_listeners) {
            listener.notifyMessage(event);
        }
    }
}

