/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.mgmtapi.impl;

import com.sonicsw.esb.mgmtapi.ESBAPI;
import com.sonicsw.esb.mgmtapi.ESBAPIException;
import com.sonicsw.esb.mgmtapi.config.IContainerConfigAPI;
import com.sonicsw.esb.mgmtapi.config.IEndpointConfigAPI;
import com.sonicsw.esb.mgmtapi.config.IMonitoredContainerConfigAPI;
import com.sonicsw.esb.mgmtapi.config.IProcessConfigAPI;
import com.sonicsw.esb.mgmtapi.config.IServiceConfigAPI;
import com.sonicsw.esb.mgmtapi.config.impl.ContainerConfigAPI;
import com.sonicsw.esb.mgmtapi.config.impl.EndpointConfigAPI;
import com.sonicsw.esb.mgmtapi.config.impl.MonitoredContainerConfigAPI;
import com.sonicsw.esb.mgmtapi.config.impl.ProcessConfigAPI;
import com.sonicsw.esb.mgmtapi.config.impl.ServiceConfigAPI;
import com.sonicsw.esb.mgmtapi.runtime.IContainerRuntimeAPI;
import com.sonicsw.esb.mgmtapi.runtime.IMonitoredContainerRuntimeAPI;
import com.sonicsw.esb.mgmtapi.runtime.impl.EsbContainerRuntimeAPI;
import com.sonicsw.esb.mgmtapi.runtime.impl.MonitoredContainerRuntimeAPI;
import com.sonicsw.xqimpl.config.IConfigSPI;

public class ESBAPIImpl
implements ESBAPI {
    protected IConfigSPI m_configbackend;
    protected MonitoredContainerConfigAPI m_mcConfigAPI;
    protected MonitoredContainerRuntimeAPI m_mcRuntimeAPI;
    protected boolean disposed = false;

    ESBAPIImpl() {
    }

    public void dispose() {
        this.disposed = true;
        this.m_configbackend.disconnect();
    }

    void setConfigBack(IConfigSPI configBack) {
        this.m_configbackend = configBack;
    }

    public IContainerConfigAPI getContainerConfigAPI() {
        if (this.disposed) {
            throw new IllegalStateException("API connection disposed");
        }
        return new ContainerConfigAPI(this.m_configbackend);
    }

    public IServiceConfigAPI getServiceConfigAPI() {
        return new ServiceConfigAPI(this.m_configbackend);
    }

    public IProcessConfigAPI getProcessConfigAPI() {
        return new ProcessConfigAPI(this.m_configbackend);
    }

    public IEndpointConfigAPI getEndpointConfigAPI() {
        return new EndpointConfigAPI(this.m_configbackend);
    }

    public IMonitoredContainerConfigAPI getMonitoredContainersConfigAPI() throws ESBAPIException {
        this.assureMonitoredContainers();
        return this.m_mcConfigAPI;
    }

    public IMonitoredContainerRuntimeAPI getMonitoredContainersRuntimeAPI() {
        this.assureMonitoredContainers();
        return this.m_mcRuntimeAPI;
    }

    private void assureMonitoredContainers() {
        if (this.m_mcConfigAPI != null) {
            return;
        }
        this.m_mcConfigAPI = new MonitoredContainerConfigAPI(this.m_configbackend);
        this.m_mcRuntimeAPI = new MonitoredContainerRuntimeAPI(this.m_configbackend);
        this.m_mcConfigAPI.setRuntimeAPI(this.m_mcRuntimeAPI);
    }

    public IContainerRuntimeAPI getContainerRuntimeAPI(String mfContainerName, String esbContainerName) {
        return new EsbContainerRuntimeAPI(this.m_configbackend, mfContainerName, esbContainerName);
    }
}

