/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.el;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.el.ELException;

public class PropertiesFileCache {
    private static final PropertiesFileCache PROPERTIES_CACHE = new PropertiesFileCache();
    private final Map<String, Properties> cache = Collections.synchronizedMap(new HashMap());
    private TestHook testHook;

    public static Map getPropertiesStatic(String url) {
        return PROPERTIES_CACHE.getProperties(url);
    }

    public static Map getPropertiesDynamicStatic(String url) {
        return PROPERTIES_CACHE.getPropertiesDynamic(url);
    }

    public Properties getProperties(String url) {
        Properties properties = this.cache.get(url);
        if (properties == null) {
            properties = this.loadProperties(url);
            this.cache.put(url, properties);
        }
        return properties;
    }

    public Properties getPropertiesDynamic(String url) {
        return this.loadProperties(url);
    }

    private Properties loadProperties(String urlString) {
        Properties properties = this.tryTestHook(urlString);
        if (properties != null) {
            return properties;
        }
        try {
            URL url = new URL(urlString);
            properties = new Properties();
            properties.load(url.openStream());
            return properties;
        }
        catch (Exception excp) {
            throw new ELException("Failed to load properties from: " + urlString, (Throwable)excp);
        }
    }

    public void setTestHook(TestHook hook) {
        this.testHook = hook;
    }

    public Properties tryTestHook(String urlString) {
        if (this.testHook != null) {
            return this.testHook.loadPropertiesHook(urlString);
        }
        return null;
    }

    public void reset() {
        this.testHook = null;
        this.cache.clear();
    }

    public static interface TestHook {
        public Properties loadPropertiesHook(String var1);
    }
}

