/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.model.CompositeToken;
import com.sonicsw.esb.itinerary.model.EsbStepNode;
import com.sonicsw.esb.jeri.esb.ESBPreferredEndpointTracker;
import com.sonicsw.esb.process.model.Action;
import com.sonicsw.esb.process.model.ActivityEdge;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.FinalNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.run.Location;
import com.sonicsw.esb.run.RunContext;
import com.sonicsw.esb.run.RunDisconnectException;
import com.sonicsw.esb.run.handlers.service.AfterProcessLocation;
import com.sonicsw.esb.run.handlers.service.BeforeProcessLocation;
import com.sonicsw.esb.run.handlers.service.BranchEndLocation;
import com.sonicsw.esb.run.handlers.service.ESBServiceLocationFactory;
import com.sonicsw.esb.run.handlers.service.ProcessLocation;
import com.sonicsw.esb.run.impl.LocationContext;
import com.sonicsw.esb.run.impl.util.PreferredExporterFactory;
import com.sonicsw.esb.run.impl.util.RunUtils;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xqimpl.service.ProcessEntryStepServiceContext;
import com.sonicsw.xqimpl.service.ProcessExitStepServiceContext;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.service.debug.ServiceContextProcessor;
import com.sonicsw.xqimpl.util.XQParametersImpl;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.Iterator;
import java.util.Stack;

public class RunDebugAction
implements Action {
    private static XQLog m_log = XQLogImpl.getCategoryLog((int)32768);

    @Override
    public void execute(Token token, Action.Type type, ActivityNode targetNode, ActivityEdge targetEdge) {
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        if (XQContainer.isTestContainer() && !mex.isExchangeImmediate() && targetNode != null) {
            if (type == Action.Type.ON_ENTRY && targetNode instanceof EsbStepNode) {
                EsbStepNode stepNode = (EsbStepNode)targetNode;
                if (stepNode.getEndpointRef(token).getType() == 2) {
                    this.handleProcessEntry(token, mex, targetNode);
                }
            } else if (type == Action.Type.ON_EXIT && targetNode instanceof FinalNode) {
                this.handleProcessExit(token, mex);
            }
        }
    }

    private Location peekLocation(XQMessage msg) {
        Stack currentStack;
        int size;
        XQMessageInternal internalMsg = (XQMessageInternal)msg;
        RunContext runContext = (RunContext)internalMsg.getSidebandProperty("SonicESB.RUN_CONTEXT_PART_CONTENT_ID");
        if (runContext != null && (size = (currentStack = runContext.getStack()).size()) > 0) {
            return runContext.peekCurrentFrame();
        }
        return null;
    }

    private Location popLocation(XQMessage msg) {
        Stack currentStack;
        int size;
        XQMessageInternal internalMsg = (XQMessageInternal)msg;
        RunContext runContext = (RunContext)internalMsg.getSidebandProperty("SonicESB.RUN_CONTEXT_PART_CONTENT_ID");
        if (runContext != null && (size = (currentStack = runContext.getStack()).size()) > 0) {
            return runContext.pop();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProcessEntry(Token token, EsbMessageExchange mex, ActivityNode targetNode) {
        XQMessageInternal internalMsg = (XQMessageInternal)mex.getInputMessage();
        boolean cleanup = RunUtils.setupJERIEnvironment(internalMsg);
        try {
            String jeriUUID = (String)internalMsg.getSidebandProperty("SonicESB.JERI_UUID");
            RunContext runContext = (RunContext)internalMsg.getSidebandProperty("SonicESB.RUN_CONTEXT_PART_CONTENT_ID");
            if (runContext != null && jeriUUID != null) {
                XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
                String currentProcessName = procInst.getProcessDefinition().getProcessName();
                String stepName = targetNode.getDisplayName();
                if (currentProcessName != null && stepName != null) {
                    if (mex.getXQParameters() == null) {
                        mex.setXQParameters((XQParameters)new XQParametersImpl());
                    }
                    mex.getXQParameters().setParameter("SonicXQ.ProcessName", 1, currentProcessName);
                    BeforeProcessLocation processLocation = ESBServiceLocationFactory.createBeforeProcessLocation(currentProcessName, stepName);
                    runContext.push(processLocation);
                    RunDebugAction.runEntryTestPoint(mex, processLocation, runContext);
                }
            }
        }
        finally {
            if (cleanup) {
                RunUtils.cleanupJERIEnvironment(internalMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProcessExit(Token token, EsbMessageExchange mex) {
        boolean cleanup = RunUtils.setupJERIEnvironment(mex.getInputMessage());
        try {
            Location location = this.peekLocation(mex.getInputMessage());
            if (location != null && location instanceof ProcessLocation) {
                boolean result = this.runExitTestPoint(token, (ProcessLocation)location);
                if (!result) {
                    mex.setDestinationAddress(null);
                    token.tagType(Token.Type.NULL);
                }
                this.popLocation(mex.getInputMessage());
            }
            this.runBranchEndTestPoint(token);
        }
        finally {
            if (cleanup) {
                RunUtils.cleanupJERIEnvironment(mex.getInputMessage());
            }
        }
    }

    private static boolean runEntryTestPoint(EsbMessageExchange mex, Location location, RunContext runContext) {
        String entryEndpoint = mex.getEndpointContext() != null ? mex.getEndpointContext().getEntryEndpointName() : "";
        ProcessEntryStepServiceContext serviceContext = new ProcessEntryStepServiceContext(mex.getInputMessage(), mex.getDestinationAddress(), entryEndpoint, mex.getXQParameters());
        boolean result = ServiceContextProcessor.processServiceContext(location, runContext, serviceContext);
        if (!result) {
            return result;
        }
        return true;
    }

    private boolean runExitTestPoint(Token token, ProcessLocation procLocation) {
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        XQMessageInternal internalMsg = (XQMessageInternal)mex.getInputMessage();
        RunContext runContext = (RunContext)internalMsg.getSidebandProperty("SonicESB.RUN_CONTEXT_PART_CONTENT_ID");
        if (runContext != null) {
            AfterProcessLocation location = ESBServiceLocationFactory.createAfterProcessLocation(procLocation.getProcessName(), procLocation.getProcessStep());
            runContext.replaceCurrentFrame(location);
            ProcessExitStepServiceContext sc = new ProcessExitStepServiceContext(mex.getSendBox(), mex.getEnvelopeFactory(), mex.getEndpointContext().getEntryEndpointName(), mex.getXQParameters());
            boolean result = ServiceContextProcessor.processServiceContext(location, runContext, sc);
            if (!result) {
                return result;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runBranchEndTestPoint(Token token) {
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        XQMessageInternal internalMsg = (XQMessageInternal)mex.getInputMessage();
        RunContext runContext = (RunContext)internalMsg.getSidebandProperty("SonicESB.RUN_CONTEXT_PART_CONTENT_ID");
        if (runContext != null) {
            XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
            if (procInst.isSubProcess()) {
                return false;
            }
            String topProcessName = procInst.getProcessInstanceProperties().getRootProcessName();
            BranchEndLocation location = ESBServiceLocationFactory.createBranchEndLocation(topProcessName);
            if (runContext.getStack().size() > 0) {
                runContext.replaceCurrentFrame(location);
            } else {
                runContext.push(location);
            }
            runContext.setRemoteRunContextReadOnly(true);
            try {
                boolean result = this.sendBranchEndEvents(token, runContext, location);
                if (!result) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                runContext.setRemoteRunContextReadOnly(false);
                runContext.pop();
            }
        }
        return true;
    }

    private boolean sendBranchEndEvents(Token token, RunContext runContext, Location location) {
        boolean result;
        if (token instanceof CompositeToken) {
            Iterator<Token> tokens = ((CompositeToken)token).getTokens().iterator();
            while (tokens.hasNext()) {
                this.sendBranchEndEvents(tokens.next(), runContext, location);
            }
        } else if (!token.isTokenOfType(Token.Type.RME, false) && !(result = this.sendBranchEndEvent(runContext, location))) {
            return result;
        }
        return true;
    }

    private boolean sendBranchEndEvent(RunContext runContext, Location location) {
        LocationContext locationContext = new LocationContext(location, null, new PreferredExporterFactory(ESBPreferredEndpointTracker.getInstance(), runContext.getRunID()), runContext);
        try {
            runContext.process(locationContext);
        }
        catch (RunDisconnectException e) {
            m_log.logDebug((Throwable)e);
        }
        catch (Exception e) {
            m_log.logError("Error in processing run/debug requests for Process Location '" + location + "'");
            m_log.logDebug((Throwable)e);
            return false;
        }
        return true;
    }
}

