/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.run.handlers.service.impl;

import com.sonicsw.esb.run.LocationContext;
import com.sonicsw.esb.run.handlers.service.impl.XQAddressReference;
import com.sonicsw.esb.run.handlers.service.impl.XQPartReference;
import com.sonicsw.esb.run.impl.RemoteValue;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jms.Destination;

public class XQMessageReference
extends RemoteValue
implements com.sonicsw.esb.run.handlers.service.XQMessageReference {
    protected final XQMessage m_message;

    public XQMessageReference(LocationContext locationContext, XQMessage message) {
        super(locationContext);
        this.m_message = message;
    }

    @Override
    public boolean containsHeader(String name) throws RemoteException {
        try {
            return this.m_message.containsHeader(name);
        }
        catch (XQMessageException e) {
            throw new RemoteException("Method 'containedHeader' failed", e);
        }
    }

    @Override
    public List getHeaderNames() throws RemoteException {
        try {
            LinkedList<String> names = new LinkedList<String>();
            Iterator it = this.m_message.getHeaderNames();
            while (it.hasNext()) {
                String name = (String)it.next();
                names.add(name);
            }
            return names;
        }
        catch (XQMessageException e) {
            throw new RemoteException("Method 'getHeaderNames' failed", e);
        }
    }

    @Override
    public Object getHeaderValue(String name) throws RemoteException {
        try {
            Object obj = this.m_message.getHeaderValue(name);
            if (obj instanceof Destination) {
                obj = obj.toString();
            }
            return obj;
        }
        catch (XQMessageException e) {
            throw new RemoteException("Method 'getHeaderValue' failed", e);
        }
    }

    @Override
    public boolean getBooleanHeader(String name) throws RemoteException {
        try {
            return this.m_message.getBooleanHeader(name);
        }
        catch (XQMessageException e) {
            throw new RemoteException("Method 'getBooleanHeader' failed", e);
        }
    }

    @Override
    public byte getByteHeader(String name) throws RemoteException {
        try {
            return this.m_message.getByteHeader(name);
        }
        catch (XQMessageException e) {
            throw new RemoteException("Method 'getByteHeader' failed", e);
        }
    }

    @Override
    public int getIntHeader(String name) throws RemoteException {
        try {
            return this.m_message.getIntHeader(name);
        }
        catch (XQMessageException e) {
            throw new RemoteException("Method 'getIntHeader' failed", e);
        }
    }

    @Override
    public long getLongHeader(String name) throws RemoteException {
        try {
            return this.m_message.getLongHeader(name);
        }
        catch (XQMessageException e) {
            throw new RemoteException("Method 'getLongHeader' failed", e);
        }
    }

    @Override
    public float getFloatHeader(String name) throws RemoteException {
        try {
            return this.m_message.getFloatHeader(name);
        }
        catch (XQMessageException e) {
            throw new RemoteException("Method 'getFloatHeader' failed", e);
        }
    }

    @Override
    public double getDoubleHeader(String name) throws RemoteException {
        try {
            return this.m_message.getDoubleHeader(name);
        }
        catch (XQMessageException e) {
            throw new RemoteException("Method 'getDoubleHeader' failed", e);
        }
    }

    @Override
    public short getShortHeader(String name) throws RemoteException {
        try {
            return this.m_message.getShortHeader(name);
        }
        catch (XQMessageException e) {
            throw new RemoteException("Method 'getShortHeader' failed", e);
        }
    }

    @Override
    public String getStringHeader(String name) throws RemoteException {
        try {
            return this.m_message.getStringHeader(name);
        }
        catch (XQMessageException e) {
            throw new RemoteException("Method 'getStringHeader' failed", e);
        }
    }

    @Override
    public int getPartCount() throws RemoteException {
        try {
            return this.m_message.getPartCount();
        }
        catch (XQMessageException e) {
            throw new RemoteException("Method 'getPartCount' failed", e);
        }
    }

    @Override
    public com.sonicsw.esb.run.handlers.service.XQPartReference getPart(int index) throws RemoteException {
        try {
            XQPart part = this.m_message.getPart(index);
            if (part == null) {
                return null;
            }
            XQPartReference partRef = new XQPartReference(this.m_locationContext, part);
            return (com.sonicsw.esb.run.handlers.service.XQPartReference)this.exportSubObject(partRef);
        }
        catch (Exception e) {
            throw new RemoteException("Method 'getPart' failed", e);
        }
    }

    @Override
    public com.sonicsw.esb.run.handlers.service.XQPartReference getPart(String cid) throws RemoteException {
        try {
            XQPart part = this.m_message.getPart(cid);
            if (part == null) {
                return null;
            }
            XQPartReference partRef = new XQPartReference(this.m_locationContext, part);
            return (com.sonicsw.esb.run.handlers.service.XQPartReference)this.exportSubObject(partRef);
        }
        catch (Exception e) {
            throw new RemoteException("Method 'getPart' failed", e);
        }
    }

    @Override
    public boolean doesPartExist(String cid) throws RemoteException {
        return this.m_message.doesPartExist(cid);
    }

    @Override
    public com.sonicsw.esb.run.handlers.service.XQAddressReference getReplyTo() throws RemoteException {
        try {
            XQAddress replyTo = this.m_message.getReplyTo();
            if (replyTo == null) {
                return null;
            }
            XQAddressReference addressRef = new XQAddressReference(this.m_locationContext, replyTo);
            return (com.sonicsw.esb.run.handlers.service.XQAddressReference)this.exportSubObject(addressRef);
        }
        catch (Exception e) {
            throw new RemoteException("Method 'getReplyTo' failed", e);
        }
    }

    @Override
    public String getCorrelationId() throws RemoteException {
        try {
            return this.m_message.getCorrelationId();
        }
        catch (XQMessageException e) {
            throw new RemoteException("Method 'getCorrelationId' failed", e);
        }
    }

    @Override
    public void setHeaderValue(String name, Object value) throws RemoteException, XQMessageException {
        this.m_message.setHeaderValue(name, value);
    }

    @Override
    public void setPartContent(int partIndex, Object value, String contentType) throws RemoteException, XQMessageException {
        XQPart part = this.m_message.getPart(partIndex);
        part.setContent(value, contentType);
        this.m_message.replacePart(part, partIndex);
    }

    @Override
    public void setPartContent(String contentId, Object value, String contentType) throws RemoteException, XQMessageException {
        XQPart part = this.m_message.getPart(contentId);
        part.setContent(value, contentType);
        this.m_message.replacePart(part, contentId);
    }

    @Override
    public void setHeader(int partIndex, String headerName, String headerValue) throws RemoteException, XQMessageException {
        XQPart part = this.m_message.getPart(partIndex);
        part.getHeader().setValue(headerName, headerValue);
        this.m_message.replacePart(part, partIndex);
    }

    @Override
    public void setHeader(String contentId, String headerName, String headerValue) throws RemoteException, XQMessageException {
        XQPart part = this.m_message.getPart(contentId);
        part.getHeader().setValue(headerName, headerValue);
        this.m_message.replacePart(part, contentId);
    }

    public String getHeader(int partIndex, String headerName) throws RemoteException, XQMessageException {
        XQPart part = this.m_message.getPart(partIndex);
        return part.getHeader().getValue(headerName);
    }

    public String getHeader(String contentId, String headerName) throws RemoteException, XQMessageException {
        XQPart part = this.m_message.getPart(contentId);
        return part.getHeader().getValue(headerName);
    }
}

