/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.routingRules.impl;

import com.sonicsw.xq.service.xcbr.RoutingRuleException;
import com.sonicsw.xq.service.xcbr.configuration.RoutingListConfiguration;
import com.sonicsw.xq.service.xcbr.configuration.RoutingRulesConfiguration;
import com.sonicsw.xq.service.xcbr.context.InvocationContext;
import com.sonicsw.xq.service.xcbr.namespace.NamespaceContextFactory;
import com.sonicsw.xq.service.xcbr.routingRules.RoutingContext;
import com.sonicsw.xq.service.xcbr.routingRules.RoutingRule;
import com.sonicsw.xq.service.xcbr.routingRules.RoutingRules;
import com.sonicsw.xq.service.xcbr.routingRules.impl.RoutingRuleFactory;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.RoutingList;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.RoutingListFactory;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLOutputStream;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLOutputStreamFactory;
import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;

public class RoutingRulesImpl
implements RoutingRules {
    private String version_;
    private int processingType_ = 0;
    private String note_;
    private ArrayList<RoutingRule> routingRules_ = new ArrayList();
    private RoutingList defaultRoutingList_;
    private NamespaceContext namespaces_;
    private static final String NOTE_TAG = "Note";
    private static final String PROCESS_TYPE_TAG = "processType";

    public RoutingRulesImpl(RoutingRulesConfiguration argConfiguration) throws RoutingRuleException {
        try {
            this.setVersion(argConfiguration.getVersion());
            this.setProcessingType(argConfiguration.getProcessType());
            this.setNote(argConfiguration.getNote());
            for (int i = 0; i < argConfiguration.getNumberofRoutingRules(); ++i) {
                this.routingRules_.add(RoutingRuleFactory.create(argConfiguration.getRoutingRule(i)));
            }
            RoutingListConfiguration defaultRoutingList = argConfiguration.getDefaultRoutingList();
            if (defaultRoutingList != null) {
                this.setDefaultRoutingList(defaultRoutingList);
            }
            this.namespaces_ = NamespaceContextFactory.create(argConfiguration.getNamespaces().getPrefixes(), argConfiguration.getNamespaces().getURIs());
            this.initializeXPath(this.namespaces_);
        }
        catch (RoutingRuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RoutingRuleException(e);
        }
    }

    @Override
    public String toXML() throws RoutingRuleException {
        try {
            XMLOutputStream returnValue = XMLOutputStreamFactory.create();
            returnValue.startDocument();
            returnValue.startTag(this.getRootTag());
            returnValue.addAttribute(PROCESS_TYPE_TAG, this.getProcessingType());
            returnValue.writeTag(null, NOTE_TAG, null, this.getNote());
            for (int i = 0; i < this.numberOfRules(); ++i) {
                RoutingRule currentRule = this.getRule(i);
                currentRule.toXML(returnValue);
            }
            returnValue.endDocument();
            return returnValue.toString();
        }
        catch (RoutingRuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RoutingRuleException(e);
        }
    }

    @Override
    public boolean route(InvocationContext argMessage, RoutingContext routingContext) throws RoutingRuleException {
        boolean routed = false;
        routingContext.setVersion(this.version_);
        routingContext.setProcessingType(this.processingType_);
        int ruleCount = this.numberOfRules();
        for (int i = 0; i < ruleCount; ++i) {
            if (!this.getRule(i).route(argMessage, routingContext)) continue;
            routed = true;
            if (this.isDistinctProcessing()) break;
        }
        if (!routed && this.isDefaultRoutingsDefined()) {
            this.defaultRoutingList_.route(argMessage, routingContext);
        }
        return routed;
    }

    private void initializeXPath(NamespaceContext nc) throws RoutingRuleException {
        int ruleCount = this.numberOfRules();
        for (int i = 0; i < ruleCount; ++i) {
            this.getRule(i).initializeXPath(nc);
        }
    }

    private int numberOfRules() {
        return this.routingRules_.size();
    }

    private RoutingRule getRule(int argIndex) {
        RoutingRule returnValue = this.routingRules_.get(argIndex);
        return returnValue;
    }

    private String getRootTag() {
        String returnValue = "RoutingRules";
        return returnValue;
    }

    private String getNote() {
        return this.note_;
    }

    private String getProcessingType() {
        String returnValue = (String)ROUTING_RULE_PROCESSORS.get(this.processingType_);
        return returnValue;
    }

    private boolean isDistinctProcessing() {
        boolean returnValue = false;
        if (this.processingType_ == 0) {
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isDefaultRoutingsDefined() {
        boolean returnValue = false;
        if (this.defaultRoutingList_ != null) {
            returnValue = true;
        }
        return returnValue;
    }

    private void setVersion(String argVersion) {
        this.version_ = argVersion;
    }

    private void setProcessingType(String argProcessingType) throws RoutingRuleException {
        if (argProcessingType == null || "".equals(argProcessingType)) {
            throw new RoutingRuleException("Cannot set empty processing type");
        }
        if ("distinct".equalsIgnoreCase(argProcessingType) || "routeFirst".equalsIgnoreCase(argProcessingType) || "ROUTE_FIRST".equalsIgnoreCase(argProcessingType)) {
            this.processingType_ = 0;
        } else if ("sequential".equalsIgnoreCase(argProcessingType) || "routeAll".equalsIgnoreCase(argProcessingType) || "ROUTE_ALL".equalsIgnoreCase(argProcessingType)) {
            this.processingType_ = 1;
        } else {
            throw new RoutingRuleException("Unsupported XCBR evaluation mode: " + argProcessingType);
        }
    }

    private void setNote(String argNote) {
        this.note_ = argNote;
    }

    private void setDefaultRoutingList(RoutingListConfiguration argRoutingListConfig) throws RoutingRuleException {
        this.defaultRoutingList_ = RoutingListFactory.create(argRoutingListConfig);
    }
}

