/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.schema;

import com.sonicsw.xq.service.xcbr.schema.Destinations;
import com.sonicsw.xq.service.xcbr.schema.Namespaces;
import com.sonicsw.xq.service.xcbr.schema.RoutingRule;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class RoutingRules
implements Serializable {
    private String _xcbrVersion;
    private String _processType;
    private String _xcbrEvaluationMode;
    private String _note;
    private Namespaces _namespaces;
    private List _routingRuleList = new ArrayList();
    private Destinations _destinations;

    public void addRoutingRule(RoutingRule vRoutingRule) throws IndexOutOfBoundsException {
        this._routingRuleList.add(vRoutingRule);
    }

    public void addRoutingRule(int index, RoutingRule vRoutingRule) throws IndexOutOfBoundsException {
        this._routingRuleList.add(index, vRoutingRule);
    }

    public Enumeration enumerateRoutingRule() {
        return Collections.enumeration(this._routingRuleList);
    }

    public Destinations getDestinations() {
        return this._destinations;
    }

    public Namespaces getNamespaces() {
        return this._namespaces;
    }

    public String getNote() {
        return this._note;
    }

    public String getProcessType() {
        return this._processType;
    }

    public RoutingRule getRoutingRule(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._routingRuleList.size()) {
            throw new IndexOutOfBoundsException("getRoutingRule: Index value '" + index + "' not in range [0.." + (this._routingRuleList.size() - 1) + "]");
        }
        return (RoutingRule)this._routingRuleList.get(index);
    }

    public RoutingRule[] getRoutingRule() {
        RoutingRule[] array = new RoutingRule[]{};
        return this._routingRuleList.toArray(array);
    }

    public int getRoutingRuleCount() {
        return this._routingRuleList.size();
    }

    public String getXcbrEvaluationMode() {
        return this._xcbrEvaluationMode;
    }

    public String getXcbrVersion() {
        return this._xcbrVersion;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateRoutingRule() {
        return this._routingRuleList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllRoutingRule() {
        this._routingRuleList.clear();
    }

    public boolean removeRoutingRule(RoutingRule vRoutingRule) {
        boolean removed = this._routingRuleList.remove(vRoutingRule);
        return removed;
    }

    public RoutingRule removeRoutingRuleAt(int index) {
        Object obj = this._routingRuleList.remove(index);
        return (RoutingRule)obj;
    }

    public void setDestinations(Destinations destinations) {
        this._destinations = destinations;
    }

    public void setNamespaces(Namespaces namespaces) {
        this._namespaces = namespaces;
    }

    public void setNote(String note) {
        this._note = note;
    }

    public void setProcessType(String processType) {
        this._processType = processType;
    }

    public void setRoutingRule(int index, RoutingRule vRoutingRule) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._routingRuleList.size()) {
            throw new IndexOutOfBoundsException("setRoutingRule: Index value '" + index + "' not in range [0.." + (this._routingRuleList.size() - 1) + "]");
        }
        this._routingRuleList.set(index, vRoutingRule);
    }

    public void setRoutingRule(RoutingRule[] vRoutingRuleArray) {
        this._routingRuleList.clear();
        for (int i = 0; i < vRoutingRuleArray.length; ++i) {
            this._routingRuleList.add(vRoutingRuleArray[i]);
        }
    }

    public void setXcbrEvaluationMode(String xcbrEvaluationMode) {
        this._xcbrEvaluationMode = xcbrEvaluationMode;
    }

    public void setXcbrVersion(String xcbrVersion) {
        this._xcbrVersion = xcbrVersion;
    }

    public static RoutingRules unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (RoutingRules)Unmarshaller.unmarshal(RoutingRules.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

