/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.ws.rm;

import com.sonicsw.esb.ws.rm.IWSRMSequence;
import com.sonicsw.esb.ws.rm.IWSRMSequenceContext;
import com.sonicsw.esb.ws.rm.IWSReliableInvocation;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import com.sonicsw.xqimpl.ws.rm.SequenceContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SequenceCapsule
implements IWSRMSequence {
    private static XQLog log = XQLogImpl.getCategoryLog((int)16384);
    private String m_id = null;
    private int m_nr = 0;
    private String m_url = null;
    private String m_policy = null;
    private IWSRMSequenceContext m_context = null;
    private Map m_creationParams = null;

    public SequenceCapsule(String id, String endpointURL) {
        this.m_id = id;
        this.m_url = endpointURL;
        log.logDebug("SequenceCapsule<ctor> Offer id=" + id + " URL=" + endpointURL);
    }

    public SequenceCapsule(String id, IWSReliableInvocation targetInvocation, Map creationParams) {
        Object o;
        this.m_id = id;
        this.m_nr = 0;
        this.m_url = targetInvocation.getSOAPEndpointURL();
        this.m_policy = targetInvocation.getEffectivePolicy();
        log.logDebug("SequenceCapsule<ctor> Initiating id=" + id + " URL=" + this.m_url);
        this.m_creationParams = new HashMap();
        if (creationParams != null && (o = creationParams.get("RoutingNode")) != null) {
            this.m_creationParams.put("RoutingNode", o);
        }
    }

    SequenceCapsule(Element elem) {
        this.deserialize(elem);
    }

    private SequenceCapsule(SequenceCapsule orig) {
        this.m_id = orig.m_id;
        this.m_nr = orig.m_nr;
        this.m_url = orig.m_url;
        this.m_policy = orig.m_policy;
        this.m_context = orig.m_context;
        this.m_creationParams = orig.m_creationParams;
    }

    public String getSequenceID() {
        return this.m_id;
    }

    public int getSequenceNumber() {
        return this.m_nr;
    }

    public String getRMEndpointURL() {
        return this.m_url;
    }

    public Map getRuntimeParameters() {
        return this.m_creationParams;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        this.serialize(buff);
        return buff.toString();
    }

    public IWSRMSequence getNext() {
        SequenceCapsule next = new SequenceCapsule(this);
        ++next.m_nr;
        return next;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceCapsule that = (SequenceCapsule)obj;
        return this.m_id.equals(that.m_id);
    }

    public int hashCode() {
        return this.m_id.hashCode();
    }

    public String getPolicy() {
        return this.m_policy;
    }

    public void setSequenceContext(IWSRMSequenceContext contextObj) {
        this.m_context = contextObj;
    }

    public IWSRMSequenceContext getSequenceContext() {
        return this.m_context;
    }

    public void serialize(StringBuilder buff) {
        buff.append("<capsule");
        buff.append(" id=\"" + this.m_id + "\"");
        buff.append(" nr=\"" + this.m_nr + "\"");
        buff.append(" url=\"" + this.m_url + "\">");
        if (this.m_policy != null) {
            buff.append("<policy>");
            buff.append(this.m_policy);
            buff.append("</policy>");
        }
        if (this.m_context != null) {
            buff.append("<context>");
            buff.append(this.m_context.toString());
            buff.append("</context>");
        }
        if (this.m_creationParams != null) {
            buff.append("<creationParams>");
            for (Object key : this.m_creationParams.keySet()) {
                Object value = this.m_creationParams.get(key);
                buff.append("<param name=\"" + key.toString() + "\">");
                buff.append("<![CDATA[");
                buff.append(value);
                buff.append("]]>");
                buff.append("</param>");
            }
            buff.append("</creationParams>");
        }
        buff.append("</capsule>");
    }

    private void deserialize(Element elem) {
        Element e;
        this.m_id = elem.getAttribute("id");
        this.m_nr = Integer.parseInt(elem.getAttribute("nr"));
        this.m_url = elem.getAttribute("url");
        String context = DOMUtils.getFirstTextValueOfChild((Element)elem, (String)"context");
        if (context != null) {
            this.m_context = new SequenceContext(context);
        }
        if ((e = DOMUtils.getImmediateChildElementByName((Element)elem, (String)"policy")) != null && (e = DOMUtils.getFirstChildElement((Element)e)) != null) {
            this.m_policy = DOMUtils.getElementAsString((Element)e, (boolean)false);
        }
        if ((e = DOMUtils.getImmediateChildElementByName((Element)elem, (String)"creationParams")) != null) {
            List paramList = DOMUtils.getImmediateChildElementsByName((Element)e, (String)"param");
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < paramList.size(); ++i) {
                Element paramElem = (Element)paramList.get(i);
                String txt = ((Text)DOMUtils.getFirstChildOfType((Element)paramElem, (int)4)).getData();
                map.put(paramElem.getAttribute("name"), txt);
            }
            this.m_creationParams = map;
        }
    }
}

