/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.ItineraryEngine;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.model.CompositeToken;
import com.sonicsw.esb.itinerary.model.EsbNode;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.process.model.impl.DefaultGuard;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xqimpl.common.XQAbstractAddressImpl;
import com.sonicsw.xqimpl.envelope.XQProcessStepRoutingAddressImpl;
import com.sonicsw.xqimpl.service.MessageSendingHelper;

public class NextAddressGuard
extends DefaultGuard {
    private ActivityNode m_destStepNode;
    private XQAbstractAddressImpl m_destNodeAddr;
    private boolean m_isIntraContainer;

    public NextAddressGuard(ActivityNode esbStepNode) {
        super("Destination node " + esbStepNode.getId());
        this.m_destStepNode = esbStepNode;
        this.m_destNodeAddr = (XQAbstractAddressImpl)((EsbNode)this.m_destStepNode).getEndpointRef(null);
        if (this.m_destNodeAddr.getType() == 4) {
            this.m_destNodeAddr = null;
        } else if (this.m_destNodeAddr != null) {
            this.m_isIntraContainer = ItineraryEngine.useIntraContainerDispatch((XQAddress)this.m_destNodeAddr);
        }
    }

    @Override
    public boolean evaluate(Token token) {
        boolean accept = false;
        if (token == null || token instanceof CompositeToken || token.isTokenOfType(Token.Type.FAULT, false) || token.isTokenOfType(Token.Type.RME, false) || token.isTokenOfType(Token.Type.NULL, false) || token.getData() == null) {
            return false;
        }
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        XQAddress messageDestination = mex.getDestinationAddress();
        if (messageDestination != null) {
            boolean isIntraContainer = this.m_isIntraContainer;
            XQAbstractAddressImpl destNodeAddr = this.m_destNodeAddr;
            if (destNodeAddr == null) {
                destNodeAddr = (XQAbstractAddressImpl)((EsbNode)this.m_destStepNode).getEndpointRef(token);
                isIntraContainer = ItineraryEngine.useIntraContainerDispatch((XQAddress)destNodeAddr);
            }
            if (messageDestination == destNodeAddr || destNodeAddr.relaxedEquals(messageDestination)) {
                accept = isIntraContainer || NextAddressGuard.setupInterContainerDispatch(token, this.m_destStepNode);
            } else if (messageDestination.getType() == 4) {
                accept = isIntraContainer || NextAddressGuard.setupInterContainerDispatch(token, destNodeAddr, this.m_destStepNode);
            } else if (messageDestination instanceof XQProcessStepRoutingAddressImpl) {
                XQProcessStepRoutingAddressImpl routingAddr = (XQProcessStepRoutingAddressImpl)messageDestination;
                String processName = routingAddr.getName();
                if (this.m_destStepNode.getParentProcess().getProcessName().equals(processName)) {
                    String stepName = routingAddr.getStepName();
                    if (this.m_destStepNode.getDisplayName().equals(stepName)) {
                        boolean bl = accept = isIntraContainer || NextAddressGuard.setupInterContainerDispatch(token, destNodeAddr, this.m_destStepNode);
                    }
                }
            }
            if (accept && isIntraContainer) {
                XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
                MessageSendingHelper.setSender(mex.getInputMessage(), procInst.getProcessDefinition().getProcessName());
            }
        }
        return accept;
    }

    private static boolean setupInterContainerDispatch(Token token, ActivityNode destStepNode) {
        token.setDestinationNode(destStepNode);
        return false;
    }

    private static boolean setupInterContainerDispatch(Token token, XQAbstractAddressImpl nextAddress, ActivityNode destStepNode) {
        token.setDestinationNode(destStepNode);
        ((EsbMessageExchange)token.getData()).setDestinationAddress((XQAddress)nextAddress);
        return false;
    }
}

