/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.model;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.mapping.DefaultMessageMapper;
import com.sonicsw.esb.itinerary.model.InlineEsbStepNode;
import com.sonicsw.esb.process.model.ActivityGroup;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.esb.visitor.ESBVisitor;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.util.XQParametersImpl;
import java.util.HashMap;
import java.util.Map;

public class TransformationStepNode
extends InlineEsbStepNode {
    public TransformationStepNode(String id, String stepName, ActivityGroup parent) {
        super(id, stepName, parent, "InternalStep.Transformation");
    }

    @Override
    protected Token executeInline(Token token) throws Exception {
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        XQMessageInternal msgInternal = (XQMessageInternal)mex.getInputMessage();
        HashMap<String, Object> visitorParams = new HashMap<String, Object>();
        ESBVisitor visitor = msgInternal.getVisitor();
        boolean receivedByStepInvoked = false;
        XQParameters params = mex.getXQParameters();
        try {
            receivedByStepInvoked = this.actionalNotifyPreStep(msgInternal, params, visitor, visitorParams);
            if (this.m_messageMapper != null) {
                DefaultMessageMapper.mapInputMessage(this.m_messageMapper, mex);
            }
        }
        catch (RuntimeException re) {
            XQServiceException exception = new XQServiceException("Message mapping failure: " + re.getMessage(), (Throwable)re);
            s_log.logError((Throwable)exception);
            throw exception;
        }
        finally {
            if (receivedByStepInvoked) {
                this.actionalEndServerInteraction(visitor, visitorParams);
            }
        }
        return token;
    }

    @Override
    protected void populateXQParameters(EsbMessageExchange mex) {
        XQParametersImpl runtimeParams = (XQParametersImpl)mex.getXQParameters();
        runtimeParams.setParameter("SonicXQ.ContainerName", 1, XQContainer.getXQContainerName());
        runtimeParams.setParameter("SonicXQ.ApplicationName", 1, "InternalStep.Transformation");
    }

    private boolean actionalNotifyPreStep(XQMessage message, XQParameters params, ESBVisitor visitor, Map<String, Object> visitorParams) {
        boolean actionalEnabled = visitor != null;
        boolean receivedByStepInvoked = false;
        if (actionalEnabled) {
            String processName = params.getParameter("SonicXQ.ProcessName", 1);
            if (processName != null) {
                visitorParams.put("ESBVisitor.PARAM_PROCESS_NAME", processName);
            }
            visitorParams.put("ESBVisitor.PARAM_XQ_PARAMETERS", params);
            visitorParams.put("ESBVisitor.PARAM_XQ_MESSAGE", message);
            visitor.sentToStep(visitorParams);
            this.actionalNotifyReceivedByStep(visitor, visitorParams, processName, params, message);
            receivedByStepInvoked = true;
        }
        return receivedByStepInvoked;
    }

    private void actionalEndServerInteraction(ESBVisitor visitor, Map<String, Object> visitorParams) {
        if (visitor != null) {
            visitorParams.put("End SI", "true");
            visitor.receivedByStep(visitorParams);
        }
    }

    private void actionalNotifyReceivedByStep(ESBVisitor visitor, Map<String, Object> visitorParams, String processName, XQParameters params, XQMessage message) {
        visitorParams.put("ESBVisitor.PARAM_PROCESS_NAME", processName);
        visitorParams.put("ESBVisitor.PARAM_SERVICE_NAME", "Transformation");
        visitorParams.put("ESBVisitor.PARAM_XQ_PARAMETERS", params);
        visitorParams.put("ESBVisitor.PARAM_XQ_MESSAGE", message);
        visitor.receivedByStep(visitorParams);
    }
}

