/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.run.handlers.service.impl;

import com.sonicsw.esb.run.Location;
import java.util.regex.Pattern;

public class ProcessLocation
extends com.sonicsw.esb.run.impl.Location
implements com.sonicsw.esb.run.handlers.service.ProcessLocation {
    static final long serialVersionUID = 8316968047902958624L;
    protected final String m_processName;
    protected final String m_processStep;
    protected final Pattern m_pattern;

    public ProcessLocation(String processName, String processStep) {
        this.m_processName = processName;
        if (processStep != null && processStep.startsWith(":")) {
            processStep = processStep.substring(1);
        }
        String escapedStepName = this.m_processStep = processStep;
        if (this.m_processStep != null) {
            escapedStepName = Pattern.quote(this.m_processStep);
        }
        this.m_pattern = Pattern.compile("(.*:)?" + escapedStepName + "$");
    }

    @Override
    public String getProcessName() {
        return this.m_processName;
    }

    @Override
    public String getProcessStep() {
        return this.m_processStep;
    }

    @Override
    public boolean same(Location location) {
        if (super.same(location)) {
            if (location.isAnyLocation()) {
                return true;
            }
            if (location instanceof ProcessLocation) {
                ProcessLocation otherLocation = (ProcessLocation)location;
                if ((this.getProcessName() == null || otherLocation.getProcessName() != null && otherLocation.getProcessName().equals(this.getProcessName())) && this.matchesStepName(otherLocation.getProcessStep())) {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean matchesStepName(String otherStepName) {
        if (this.getProcessStep() == null) {
            return true;
        }
        if (otherStepName != null) {
            boolean result = this.m_pattern.matcher(otherStepName).matches();
            return result;
        }
        return false;
    }

    public String toString() {
        return "[ProcessLocation: {" + this.m_processName + ", " + this.m_processStep + "}]";
    }
}

