/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.connector.jms;

import com.sonicsw.xq.XQEndpoint;
import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQEndpointException;
import com.sonicsw.xq.XQEndpointTimeoutException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.connector.jms.IConnectionRegistry;
import com.sonicsw.xq.connector.jms.JMSConnectionCfg;
import com.sonicsw.xq.connector.jms.JMSEndpointCfg;
import com.sonicsw.xq.connector.jms.JMSEndpointConnection;
import com.sonicsw.xq.connector.jms.MappingException;
import com.sonicsw.xq.connector.jms.MessageMapper;
import com.sonicsw.xq.connector.jms.StandaloneConnectionRegistry;
import com.sonicsw.xq.connector.jms.XQJMSMessageMapper;
import com.sonicsw.xq.connector.jms.messagingbean.Session;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQConnectionTypeConfig;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.config.XQEndpointTypeConfig;
import com.sonicsw.xqimpl.endpoint.IJMSEntryEndpointState;
import com.sonicsw.xqimpl.service.IXQMessageListener;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class JMSEndpointStandalone
implements XQEndpoint {
    private static XQLog log = XQLogImpl.getCategoryLog((int)256);
    private JMSEndpointCfg m_cfg = null;
    private JMSConnectionCfg m_connectionCfg = null;
    private XQJMSMessageMapper m_msgMapper = null;
    private boolean m_uniqueConnectionPerReceiver = false;
    private boolean m_isTmpEP = false;
    private final Map<String, JMSEndpointConnection> m_endpointConnections = new HashMap<String, JMSEndpointConnection>();
    private String m_connectionName = null;
    private static ThreadLocal<IJMSEntryEndpointState> s_jmsEndpointThreadLocal = new ThreadLocal();
    private Set<String> m_listenersInOnMessage = Collections.synchronizedSet(new HashSet());
    private volatile String m_sendingDestination = null;
    private boolean m_runOutsideContainer = false;
    private static final IConnectionRegistry m_support = StandaloneConnectionRegistry.getInstance();

    public String toString() {
        return "JMSEndpoint[" + this.getName() + "]";
    }

    public JMSEndpointStandalone() {
    }

    public JMSEndpointStandalone(XQEndpointConfig config, XQEndpointTypeConfig typeConfig, XQLog log) throws XQEndpointCreationException {
        this(config, typeConfig, log, null, null);
    }

    public JMSEndpointStandalone(XQEndpointConfig config, XQEndpointTypeConfig typeConfig, XQLog log, XQConnectionConfig connection, Hashtable<?, ?> props, boolean isTmpEP) throws XQEndpointCreationException {
        this.m_msgMapper = this.getMsgMapper();
        try {
            XQConfigManager mgr = XQConfigManager.getInstance(props);
            if (connection == null) {
                XQConnectionConfig connectionConfig = this.lookupConnectionConfig(mgr, config);
                this.m_connectionCfg = new JMSConnectionCfg(connectionConfig, this.lookupConnectionTypeConfig(mgr, connectionConfig));
            } else {
                this.m_connectionCfg = new JMSConnectionCfg(connection, this.lookupConnectionTypeConfig(mgr, connection));
            }
            this.m_cfg = new JMSEndpointCfg(config, typeConfig);
        }
        catch (XQConfigurationException ne) {
            throw new XQEndpointCreationException("Bad connection configuration: ", (Throwable)ne);
        }
        this.configRunOutsideContainer();
        this.m_isTmpEP = isTmpEP;
    }

    private XQJMSMessageMapper getMsgMapper() {
        return this.isStandalone() ? XQJMSMessageMapper.createStandalone() : XQJMSMessageMapper.create();
    }

    public JMSEndpointStandalone(XQEndpointConfig config, XQEndpointTypeConfig typeConfig, XQLog log, XQConnectionConfig connection, Hashtable<?, ?> props) throws XQEndpointCreationException {
        this(config, typeConfig, log, connection, props, false);
    }

    public JMSEndpointStandalone(XQEndpointConfig config, XQEndpointTypeConfig typeConfig, XQConnectionConfig connectionConfigParam, XQConnectionTypeConfig connTypeConfig, XQLog log, boolean runOutsideContainer) throws XQEndpointCreationException {
        XQConnectionConfig connectionConfig = connectionConfigParam;
        this.m_msgMapper = this.getMsgMapper();
        try {
            XQConfigManager mgr = XQConfigManager.getInstance(null);
            if (connectionConfig == null) {
                connectionConfig = this.lookupConnectionConfig(mgr, config);
            }
            this.m_connectionCfg = connTypeConfig == null ? new JMSConnectionCfg(connectionConfig, this.lookupConnectionTypeConfig(mgr, connectionConfig)) : new JMSConnectionCfg(connectionConfig, connTypeConfig);
            this.m_cfg = new JMSEndpointCfg(config, typeConfig);
        }
        catch (XQConfigurationException ne) {
            throw new XQEndpointCreationException("Bad connection configuration: ", (Throwable)ne);
        }
        this.configRunOutsideContainer();
        this.m_runOutsideContainer = runOutsideContainer;
    }

    private void configRunOutsideContainer() {
        if (this.m_connectionCfg.getMaxReceiveSessionsPerConnection() == 1) {
            this.m_uniqueConnectionPerReceiver = true;
        }
    }

    public XQEndpointConfig getConfig() {
        return this.m_cfg.getConfig();
    }

    public XQParameters getParameters() {
        return this.m_cfg.getParameters();
    }

    public XQMessage createMessage() throws XQEndpointException {
        try {
            return this.m_msgMapper.createMessage();
        }
        catch (MappingException me) {
            throw new XQEndpointException("Error creating message", (Throwable)((Object)me));
        }
    }

    public void destroy() {
        if (log.isDebugLoggingEnabled()) {
            log.logDebug(this.toString() + ": destroy");
        }
        for (JMSEndpointConnection connection : this.m_endpointConnections.values()) {
            connection.destroy();
        }
        this.m_endpointConnections.clear();
    }

    public void stopMessageListener(String name) throws Exception {
        JMSEndpointConnection connection = this.getConnection(name);
        connection.stopMessageListener(name);
    }

    public void setMessageListener(String name, IXQMessageListener msgListener, Map<String, Object> subscriptionSpec) throws Exception {
        JMSEndpointConnection connection = this.getConnection(name);
        connection.setMessageListener(name, msgListener, subscriptionSpec);
    }

    public void send(String name, XQMessage msg) throws XQEndpointException {
        this.getConnection().send(name, msg);
    }

    public void sendExactlyOnce(String sessionName, int deliveryMode, XQMessage msg) throws XQEndpointException {
        this.getConnection(sessionName).sendWithUnbound(sessionName, deliveryMode, msg);
    }

    public void send(XQMessage msg) throws XQEndpointException {
        XQQualityofService qos = XQQualityofService.valueOf((String)this.getConfig().getQOS());
        this.sendWithQoS(null, false, qos, msg);
    }

    public void send(String sessionName, int deliveryMode, XQMessage msg) throws XQEndpointException {
        this.getConnection().send(sessionName, deliveryMode, msg);
    }

    public HashMap<String, String> sendWithQoS(String sessionName, boolean commit, XQQualityofService qos, XQMessage msg) throws XQEndpointException {
        return this.getConnection().sendWithQoS(sessionName, commit, qos, msg);
    }

    public void sendWithUnbound(String sessionName, int deliveryMode, XQMessage msg) throws XQEndpointException {
        this.getConnection().sendWithUnbound(sessionName, deliveryMode, msg);
    }

    public XQMessage call(XQMessage msg, long timeout) throws XQEndpointException, XQEndpointTimeoutException {
        String pool = this.m_cfg.getConfig().getQOS();
        return this.getConnection().call(msg, timeout, pool);
    }

    public XQMessage callWithQoS(XQMessage msg, long timeout, XQQualityofService qos) throws XQEndpointException, XQEndpointTimeoutException {
        return this.getConnection().callWithQoS(msg, timeout, qos);
    }

    public XQMessage syncWSInvokeWithQoS(XQMessage msg, long timeout, XQQualityofService qos) throws XQEndpointException, XQEndpointTimeoutException {
        return this.getConnection().syncWSInvokeWithQoS(msg, timeout, qos);
    }

    public Map<String, String> asyncWSInvokeWithQoS(XQQualityofService qos, XQMessage msg) throws XQEndpointException {
        return this.getConnection().asyncWSInvokeWithQoS(msg, qos);
    }

    public String getName() {
        return this.m_cfg.getConfig().getName();
    }

    public boolean getTmpEPStatus() {
        return this.m_isTmpEP;
    }

    public void setTmpEPStatus(boolean isTmpEP) {
        this.m_isTmpEP = isTmpEP;
    }

    public String getConnectionName() {
        if (this.m_connectionName == null) {
            this.m_connectionName = this.m_connectionCfg.getConfig().getName();
        }
        return this.m_connectionName;
    }

    JMSEndpointConnection getConnection() {
        return this.getConnection("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JMSEndpointConnection getConnection(String msgListenerName) {
        String name;
        JMSEndpointConnection endpointConnection;
        if (log.isDebugLoggingEnabled()) {
            log.logDebug(this.toString() + ": getConnection: msgListenerName = " + msgListenerName);
        }
        if ((endpointConnection = this.m_endpointConnections.get(name = this.getConnectionName() + (this.m_uniqueConnectionPerReceiver ? msgListenerName : ""))) == null) {
            Map<String, JMSEndpointConnection> map = this.m_endpointConnections;
            synchronized (map) {
                while ((endpointConnection = this.m_endpointConnections.get(name)) == null) {
                    if (log.isDebugLoggingEnabled()) {
                        log.logDebug(this.toString() + ": getConnection: creating new endpoint connection: name = " + name);
                    }
                    endpointConnection = new JMSEndpointConnection(name, this.m_cfg, this.m_connectionCfg, this.m_isTmpEP, this.m_runOutsideContainer, this, this.getSupport());
                    this.m_endpointConnections.put(name, endpointConnection);
                }
            }
        }
        return endpointConnection;
    }

    protected IConnectionRegistry getSupport() {
        return m_support;
    }

    public String getSendingDestination() {
        return this.m_sendingDestination;
    }

    public long getSendTimeout() {
        return this.m_cfg.getSendTimeout();
    }

    public MessageMapper getMessageMapper() {
        return this.m_msgMapper;
    }

    public static IJMSEntryEndpointState getJMSEntryEndpointState() {
        return s_jmsEndpointThreadLocal.get();
    }

    public void setJMSEntryEndpointState(IJMSEntryEndpointState state) {
        s_jmsEndpointThreadLocal.set(state);
    }

    public boolean isInListener() {
        return !this.m_listenersInOnMessage.isEmpty();
    }

    public boolean isListenerInOnMessage(String name) {
        if (name == null) {
            return false;
        }
        return this.m_listenersInOnMessage.contains(name);
    }

    public void setListenerInOnMessage(String name, boolean b) {
        if (name == null) {
            return;
        }
        if (b) {
            this.m_listenersInOnMessage.add(name);
        } else {
            this.m_listenersInOnMessage.remove(name);
        }
    }

    private XQConnectionTypeConfig lookupConnectionTypeConfig(XQConfigManager mgr, XQConnectionConfig config) throws XQConfigurationException {
        return mgr.lookupConnectionTypeConfig(config.getConnectionTypeName());
    }

    private XQConnectionConfig lookupConnectionConfig(XQConfigManager mgr, XQEndpointConfig config) throws XQConfigurationException {
        return mgr.lookupConnectionConfig(config.getConnection());
    }

    public boolean isJMS() {
        return true;
    }

    protected boolean isStandalone() {
        return true;
    }

    public IJMSEntryEndpointState createJMSEntryEndpointState() {
        return new JMSEntryEndpointState();
    }

    public class JMSEntryEndpointState
    implements IJMSEntryEndpointState {
        private Session m_session = null;

        @Override
        public void setSendingDestination(String sendingDestination) {
            JMSEndpointStandalone.this.m_sendingDestination = sendingDestination;
        }

        @Override
        public void setSession(Session session) {
            this.m_session = session;
        }

        @Override
        public Session getSession() {
            return this.m_session;
        }
    }
}

